/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.alarm.AlarmsManager;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.physstorage.StorageSpace;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.virtualization.Allocable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DirectAccessDeviceNode<T extends VolumeNode>
extends StorageDeviceNode<T>
implements Allocable {
    private static final SrLogger theLogger = SrLogger.getLogger();
    private BigInteger nonAllocatedSpace;
    private BigInteger myTotalSpace;
    private List<RemoteObject> mySplits;
    private Boolean writeCacheEnabled;
    private Boolean writeProtected;
    private Boolean m_isAllocable;
    private PhysicalStorageDriveTypeConstant myDriveType = PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_OTHER;
    private PhysicalStorageRaidLevelConstant myRaidLevel;
    private SrBITSConstant myRaidStatus;
    private BigInteger myRaidCreationTime;
    private String myRaidSysName;
    private String myRaidSysModelName;
    private String myRaidFirmwareRevision;
    private String myRaidUrlCtrl1;
    private String myRaidUrlCtrl2;

    public DirectAccessDeviceNode(T stub, String alias, boolean exposed, String transportType) throws RemoteException {
        super(stub, alias, exposed, transportType);
        theLogger.logAndAssert(SrLogCategories.ERROR, !(stub instanceof SubDirectAccessDevice) || this.getClass().equals(SubDirectAccessDeviceNode.class), new Object[0]);
        this.setStorageType(STORAGE_TYPE_DISK);
        this.setNodeIcon(ClientImageObject.DISK);
    }

    public DirectAccessDeviceNode(T aStub, String aAlias, boolean aIsExposed, String aTransportType, PhysicalStorageDriveTypeConstant aDriveType) throws RemoteException {
        this(aStub, aAlias, aIsExposed, aTransportType);
        this.myDriveType = aDriveType;
    }

    public void setRaid(PhysicalStorageRaidLevelConstant aRaidLevel, SrBITSConstant aRaidStatus, BigInteger aRaidCreationTime, String aRaidSystemName, String aRaidSystemModelName, String aRaidSystemFwRev, String aRaidUrlCtrl1, String aRaidUrlCtrl2) {
        this.myRaidLevel = aRaidLevel;
        this.myRaidStatus = aRaidStatus;
        this.myRaidCreationTime = aRaidCreationTime;
        this.myRaidSysName = aRaidSystemName;
        this.myRaidSysModelName = aRaidSystemModelName;
        this.myRaidFirmwareRevision = aRaidSystemFwRev;
        this.myRaidUrlCtrl1 = aRaidUrlCtrl1;
        this.myRaidUrlCtrl2 = aRaidUrlCtrl2;
    }

    @Override
    public PhysicalStorageRaidLevelConstant getRaidLevel() {
        return this.myRaidLevel;
    }

    public void setRaidStatus(SrBITSConstant aRaidStatus) {
        this.myRaidStatus = aRaidStatus;
    }

    public SrBITSConstant getRaidStatus() {
        return this.myRaidStatus;
    }

    public BigInteger getRaidCreationTime() {
        return this.myRaidCreationTime;
    }

    public void setRaidSysName(String aName) {
        this.myRaidSysName = aName;
    }

    public String getRaidSysName() {
        return this.myRaidSysName;
    }

    public String getRaidSysModelName() {
        return this.myRaidSysModelName;
    }

    public String getRaidFirmwareRevision() {
        return this.myRaidFirmwareRevision;
    }

    public void setRaidUrlCtrl1(String aUrl1) {
        this.myRaidUrlCtrl1 = aUrl1;
    }

    public String getRaidUrlCtrl1() {
        return this.myRaidUrlCtrl1;
    }

    public void setRaidUrlCtrl2(String aUrl2) {
        this.myRaidUrlCtrl2 = aUrl2;
    }

    public String getRaidUrlCtrl2() {
        return this.myRaidUrlCtrl2;
    }

    public void setNonAllocatedSpace(BigInteger space) {
        if (space == null) {
            throw new IllegalArgumentException("Non allocated space must be supplied");
        }
        this.nonAllocatedSpace = space;
    }

    public BigInteger getNonAllocatedSpace() {
        return this.nonAllocatedSpace;
    }

    @Override
    public void setTotalSpace(BigInteger totalSpace) {
        if (totalSpace == null) {
            throw new IllegalArgumentException("Total space must be supplied");
        }
        this.myTotalSpace = totalSpace;
    }

    public BigInteger getTotalSpace() {
        return this.myTotalSpace;
    }

    public void setDriveType(PhysicalStorageDriveTypeConstant aDriveType) {
        this.myDriveType = aDriveType;
    }

    @Override
    public PhysicalStorageDriveTypeConstant getDriveType() {
        return this.myDriveType;
    }

    public String getDriveAsString() {
        if (StorageManager.getInstance().isStorageNodeUsedByAPair(this)) {
            return "GDR";
        }
        PhysicalStorageDriveTypeConstant driveType = this.getDriveType();
        if (driveType == null) {
            return PhysicalStorageDriveTypeConstant.PHYS_STOR_DRIVE_TYPE_OTHER.toString();
        }
        return driveType.toString();
    }

    public void setIsAllocable(Boolean isAllocable) {
        this.m_isAllocable = isAllocable;
    }

    public boolean isAllocable() {
        return this.m_isAllocable;
    }

    public void setSplits(List<RemoteObject> splits) {
        this.mySplits = splits;
    }

    @Override
    public boolean hasSubdisks() {
        if (this.mySplits != null) {
            for (RemoteObject split : this.mySplits) {
                if (!(split instanceof SubDirectAccessDevice)) continue;
                return true;
            }
        }
        return false;
    }

    public List<RemoteObject> getSplits() {
        return this.mySplits;
    }

    public void setWriteCacheEnabled(Boolean writeCacheEnabled) {
        this.writeCacheEnabled = writeCacheEnabled;
    }

    public void setWriteProtected(Boolean writeProtected) {
        this.writeProtected = writeProtected;
    }

    @Override
    public String toString() {
        return this.getAlias();
    }

    public Boolean isWriteCacheEnabled() {
        return this.writeCacheEnabled;
    }

    public Boolean isWriteProtected() {
        return this.writeProtected;
    }

    public boolean isMissing() {
        return AlarmsManager.getInstance().isAlarmExist(this, AlarmsManager.DISK_IS_MISSING);
    }

    public boolean isTransportTypeISCSI() {
        String type = this.getTransportType();
        return type != null && type.equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.toString());
    }

    @Override
    public boolean isConfigured() {
        return PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_PROVISIONED.equals(this.getStorageOperStatus());
    }

    public SubDirectAccessDeviceNode getSubdisk(String aAlias) {
        for (RemoteObject subdisk : this.mySplits) {
            SubDirectAccessDeviceNode sd;
            if (!(subdisk instanceof SubDirectAccessDevice) || !(sd = (SubDirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(subdisk)).getAlias().equals(aAlias)) continue;
            return sd;
        }
        return null;
    }

    public List<SubDirectAccessDeviceNode> getSubdisks() {
        ArrayList<SubDirectAccessDeviceNode> subdisks = new ArrayList<SubDirectAccessDeviceNode>();
        if (this.mySplits != null) {
            for (RemoteObject subdisk : this.mySplits) {
                if (!(subdisk instanceof SubDirectAccessDevice)) continue;
                SubDirectAccessDeviceNode sd = (SubDirectAccessDeviceNode)SystemRootNode.getInstance().getRefByStub(subdisk);
                if (sd == null) {
                    try {
                        CommKeyClassId stubId = ((SubDirectAccessDevice)subdisk).getCommKeyClassId();
                        String alias = ((SubDirectAccessDevice)subdisk).getAlias();
                        throw new IllegalStateException("The disk " + this + " contains a subdisk stub ," + alias + "(" + stubId + "), without a reference");
                    }
                    catch (RemoteException e) {
                        theLogger.error(SrLogCategories.EXCEPTION, e, "RemoteException occured trying to get ID for stub " + subdisk);
                    }
                }
                subdisks.add(sd);
            }
        }
        return subdisks;
    }

    public List<StorageSpace> getStorageSpaceList() {
        ArrayList<StorageSpace> spaceList = new ArrayList<StorageSpace>();
        for (RemoteObject split : this.mySplits) {
            if (!(split instanceof StorageSpace)) continue;
            spaceList.add((StorageSpace)split);
        }
        return spaceList;
    }

    public BigInteger getLastSpace() {
        List<StorageSpace> spaceList = this.getStorageSpaceList();
        if (!spaceList.isEmpty()) {
            try {
                return spaceList.get(spaceList.size() - 1).getSize();
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
            }
        }
        return BigInteger.ZERO;
    }

    public boolean belongsToRAID(String aRaidWWN) {
        if (aRaidWWN == null) {
            return false;
        }
        return aRaidWWN.contains(this.getEntityName());
    }

    @Override
    public BigInteger getAllocationSpace() {
        return this.getNonAllocatedSpace();
    }
}

