/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.SequentialAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.data.storage.SubDirectAccessDeviceNode;
import com.sanrad.nms.client.event.DirectAccessDeviceEvent;
import com.sanrad.nms.client.event.DirectAccessDeviceListener;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.SequentialAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageComOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DirectAccessDeviceManager
extends ElementManager {
    private static DirectAccessDeviceManager instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer directAccessDeviceStatusChangedInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceStatusChanged(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceAliasChangedInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceAliasChanged(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceRemovedInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceRemoved(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceCreatedInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceCreated(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceInfoChangedInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceInfoChanged(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceExposedInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceExposed(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceDeExposedInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceDeExposed(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceBlinkStateChangeInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceBlinkStateChange(event);
        }
    };
    SrEventListenerManager.Informer directAccessDeviceChangedInformer = new SrEventListenerManager.Informer<DirectAccessDeviceListener, DirectAccessDeviceEvent>(){

        @Override
        public void inform(DirectAccessDeviceListener listener, DirectAccessDeviceEvent event) {
            listener.directAccessDeviceChanged(event);
        }
    };

    private DirectAccessDeviceManager() {
    }

    public static synchronized DirectAccessDeviceManager getInstance() {
        if (instance == null) {
            instance = new DirectAccessDeviceManager();
        }
        return instance;
    }

    public void addDirectAccessDeviceListener(DirectAccessDeviceListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeDirectAccessDeviceListener(DirectAccessDeviceListener listener) {
        this.m_listeners.remove(listener);
    }

    public Collection<SrFuture<Void>> blinkDisks(StorageDeviceNode<?>[] nodes, HashMap params) {
        ArrayList ids = new ArrayList(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            ids.add(nodes[i].getIdentifier());
        }
        return Collections.singleton(ClientAOImpl.getInstance().changeElements(ids, params));
    }

    public SrFuture<Void> createISCSIPhysicalStorage(ClusterNode cluster, PhysicalStorageTypeConstant type, String alias, String targetName, int lun, String serialNumber) {
        return ClientAOImpl.getInstance().createGeneralISCSIDevice(cluster.getStorageID(), type, alias, targetName, lun, serialNumber);
    }

    public SrFuture<Void> createPSCSIPhysicalStorage(ClusterNode cluster, PhysicalStorageTypeConstant type, String alias, int port, int bus, int lun, String serialNumber) {
        return ClientAOImpl.getInstance().createGeneralParallelSCSIDevice(cluster.getStorageID(), type, alias, port, bus, lun, serialNumber);
    }

    public SrFuture<Void> createFiberChannelStorage(ClusterNode cluster, PhysicalStorageTypeConstant type, String alias, byte[] targetName, int lun, String serialNumber) {
        return ClientAOImpl.getInstance().createGeneralFiberChannelDevice(cluster.getStorageID(), type, alias, targetName, lun, serialNumber);
    }

    public SrFuture<Void> renameStorageDevice(StorageDeviceNode aliasObject, HashMap params) {
        String nexsanStr = ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.NEXSAN_STRING);
        if (nexsanStr.equalsIgnoreCase(aliasObject.getVendor())) {
            return new FailedFuture<Void>(new IllegalValueException(ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_NEXSAN_DISK_ALIAS_CANNOT_BE_CHANGED_ERROR)), "DirectAccessDeviceManager.renameStorageDevice");
        }
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(aliasObject.getIdentifier()), params);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            Boolean b;
            theLogger.trace(SrLogCategories.LEGACY, "DirectAccessDeviceManager:elementChange() - " + node);
            HashMap params = this.getParameterList(e);
            Object isExposed = this.getObjectForParam(params, ClientParameterCode.VOLUME_EXPOSED, false);
            Object aliasChanged = this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, false);
            Object infoChanged = this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_DEVICE_INFO, false);
            Object isBlinking = this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_BLINK_STATUS, false);
            Object isWCE = this.getObjectForParam(params, ClientParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE, false);
            Object isAllocable = this.getObjectForParam(params, ClientParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE, false);
            Object state = this.getObjectForParam(params, ClientParameterCode.VOLUME_STATE, false);
            PhysicalStorageOperStatusConstant operStatus = (PhysicalStorageOperStatusConstant)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_OPER_STATUS, false);
            Object serialNumber = this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_SERIAL_NUMBER, true);
            Integer blockSize = (Integer)this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_BLOCK_SIZE, false);
            Object nonAllocatedSpace = this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_NON_ALLOCATED_SPACE, false);
            BigInteger blockNum = (BigInteger)this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_BLOCK_NUMBER, false);
            BigInteger totalSpace = null;
            if (blockNum != null && blockSize != null) {
                blockNum.multiply(new BigInteger(blockSize.toString()));
                totalSpace = blockNum.multiply(new BigInteger(blockSize.toString()));
            }
            Object vendor = this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_VENDOR, false);
            Object productID = this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_PRODUCT_ID, false);
            Object revisionLevel = this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_REVISION_LEVEL, false);
            Object SCSIVersion = this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_SCSI_VERSION, false);
            String raidSysName = (String)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_SYSTEM_NAME, true);
            String raidUrl1 = (String)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL1, true);
            String raidUrl2 = (String)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL2, true);
            StorageDeviceNode diskNode = (StorageDeviceNode)node;
            SrBITSConstant raidStatus = (SrBITSConstant)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_STATUS, false);
            if (aliasChanged != null) {
                this.handleAliasChange(diskNode, aliasChanged.toString());
            }
            if (params.containsKey(ClientParameterCode.VOLUME_POSITION)) {
                Integer volumePosition = (Integer)this.getObjectForParam(params, ClientParameterCode.VOLUME_POSITION, false);
                diskNode.setPositionInParent(volumePosition);
            }
            if (infoChanged != null) {
                this.handleInfoChange(diskNode, infoChanged.toString());
            }
            if (isExposed != null) {
                try {
                    this.handleExposedStatusChange(diskNode, (Boolean)isExposed);
                }
                catch (RemoteException re) {
                    theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                }
            }
            if (state != null) {
                this.handleStateChanged(diskNode, (SrBITSConstant)state);
            } else if (params.containsKey(ClientParameterCode.VOLUME_STATE)) {
                diskNode.setVolStateBits(null);
                theLogger.trace(SrLogCategories.LEGACY, "Disk: ", diskNode.getAlias(), " State Changed: null");
                this.handleStateChanged(diskNode, null);
            }
            if (isBlinking != null) {
                this.handleBlinkingStateChange(diskNode, (Integer)isBlinking);
            }
            if (isWCE != null) {
                b = new Boolean((Integer)isWCE == 1);
                this.handleWCEStateChange((DirectAccessDeviceNode)diskNode, b);
            } else if (params.containsKey(ClientParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE) && element instanceof DirectAccessDevice) {
                this.handleWCEStateChange((DirectAccessDeviceNode)diskNode, null);
            }
            if (isAllocable != null) {
                b = new Boolean((Integer)isAllocable == 1);
                this.handleIsAllocableStateChange((DirectAccessDeviceNode)diskNode, b);
            }
            boolean isChanged = false;
            if (vendor != null) {
                isChanged = true;
                ((StorageDeviceNode)node).setVendor((String)vendor);
            }
            if (SCSIVersion != null) {
                isChanged = true;
                ((StorageDeviceNode)node).setSCSIVersion((Integer)SCSIVersion);
            }
            if (revisionLevel != null) {
                isChanged = true;
                ((StorageDeviceNode)node).setRevisionLevel((String)revisionLevel);
            }
            if (productID != null) {
                isChanged = true;
                ((StorageDeviceNode)node).setProductId((String)productID);
            }
            if (blockSize != null) {
                isChanged = true;
                ((StorageDeviceNode)node).setBlockSize(blockSize);
            }
            if (totalSpace != null) {
                isChanged = true;
                ((StorageDeviceNode)node).setTotalSpace(totalSpace);
            }
            if (nonAllocatedSpace != null && node instanceof DirectAccessDeviceNode) {
                isChanged = true;
                ((DirectAccessDeviceNode)node).setNonAllocatedSpace((BigInteger)nonAllocatedSpace);
            }
            if (operStatus != null) {
                isChanged = true;
                ((StorageDeviceNode)node).setStorageOperStatus(operStatus);
            }
            if (serialNumber != null) {
                ((StorageDeviceNode)node).setSerialNumber((String)serialNumber);
            }
            if (diskNode instanceof DirectAccessDeviceNode) {
                if (raidStatus != null) {
                    ((DirectAccessDeviceNode)node).setRaidStatus(raidStatus);
                    isChanged = true;
                }
                if (raidSysName != null) {
                    ((DirectAccessDeviceNode)node).setRaidSysName(raidSysName);
                    isChanged = true;
                }
                if (raidUrl1 != null) {
                    ((DirectAccessDeviceNode)node).setRaidUrlCtrl1(raidUrl1);
                    isChanged = true;
                }
                if (raidUrl2 != null) {
                    ((DirectAccessDeviceNode)node).setRaidUrlCtrl2(raidUrl2);
                    isChanged = true;
                }
                if (isChanged || state != null) {
                    RaidManager.getInstance().reactToDiskChanged((DirectAccessDeviceNode)diskNode);
                }
            }
            if (isChanged) {
                this.fireDirectAccessDeviceChanged((StorageDeviceNode)node);
            }
        }
    }

    private void handleBlinkingStateChange(StorageDeviceNode diskNode, Integer blinkingState) {
        switch (blinkingState) {
            case 1: {
                diskNode.setBlinking(false);
                break;
            }
            case 2: {
                diskNode.setBlinking(true);
                break;
            }
            case 3: {
                diskNode.setBlinking(false);
            }
        }
        this.fireDirectAccessDeviceBlinkStateChange(diskNode);
    }

    private void handleWCEStateChange(DirectAccessDeviceNode diskNode, Boolean wceState) {
        diskNode.setWriteCacheEnabled(wceState);
        this.fireDirectAccessDeviceBlinkStateChange(diskNode);
    }

    private void handleIsAllocableStateChange(DirectAccessDeviceNode diskNode, Boolean isAllocable) {
        diskNode.setIsAllocable(isAllocable);
    }

    private synchronized void handleExposedStatusChange(StorageDeviceNode diskNode, Boolean isExposed) throws RemoteException {
        diskNode.setExposed(isExposed);
        diskNode.setFree(isExposed == false);
        if (diskNode instanceof DirectAccessDeviceNode) {
            DirectAccessDeviceNode disk = (DirectAccessDeviceNode)diskNode;
            DirectAccessDevice volNodeStub = (DirectAccessDevice)diskNode.getStub();
            BigInteger nonAllocatedSpace = volNodeStub.getNonAllocatedSpace();
            BigInteger allocatedSpace = volNodeStub.getAllocatedSpace();
            disk.setNonAllocatedSpace(nonAllocatedSpace);
            disk.setAllocatedSpace(allocatedSpace);
        }
        if (isExposed.booleanValue()) {
            theLogger.trace(SrLogCategories.LEGACY, "DirectAccessDeviceManager:: disk exposed.");
            this.fireDirectAccessDeviceExposed(diskNode);
        } else {
            theLogger.trace(SrLogCategories.LEGACY, "DirectAccessDeviceManager:: disk de-exposed.");
            this.fireDirectAccessDeviceDeExposed(diskNode);
        }
    }

    private void handleInfoChange(StorageDeviceNode diskNode, String newInfo) {
        StringBuffer toLog = new StringBuffer();
        toLog.append("disk info was changed: ");
        toLog.append(diskNode.getAlias());
        toLog.append(", new Info: ");
        toLog.append(newInfo);
        theLogger.trace(SrLogCategories.LEGACY, toLog);
        diskNode.setInfo(newInfo);
        this.fireInfoChanged(diskNode);
    }

    private void handleAliasChange(StorageDeviceNode diskNode, String newAlias) {
        StringBuffer toLog = new StringBuffer();
        toLog.append("disk alias was changed: ");
        toLog.append(diskNode.getAlias());
        toLog.append(", new Alias: ");
        toLog.append(newAlias);
        theLogger.trace(SrLogCategories.LEGACY, toLog);
        diskNode.setAlias(newAlias);
        this.fireAliasChanged(diskNode);
    }

    private void handleStateChanged(StorageDeviceNode diskNode, SrBITSConstant state) {
        diskNode.setVolStateBits(state);
        theLogger.trace(SrLogCategories.LEGACY, "Disk: ", diskNode.getAlias(), " State Changed: ", state != null ? state.toString() : null);
        this.fireDirectAccessDeviceStateChanged(diskNode);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        LogicObject element = (LogicObject)e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        try {
            GeneralSCSIDevice directAccessDevice = (GeneralSCSIDevice)element;
            HashMap params = this.getParameterList(e);
            Object isExposedObj = this.getObjectForParam(params, ClientParameterCode.VOLUME_EXPOSED, true);
            Object aliasObj = this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, true);
            Object subDisksObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.DIRECT_ACCESS_DEVICE_SUB_DEVICES", true);
            Object isFreeObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_IS_FREE", true);
            Object blockSize = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_BLOCK_SIZE", true);
            Object nonAllocatedSpace = this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_NON_ALLOCATED_SPACE, true);
            BigInteger totalSpace = null;
            Object storageSpaceStatus = this.getObjectForParam(params, "Missing code - ClientParameterCode.DIRECT_ACCESS_DEVICE_STOR_SPACE_STATUS", true);
            Object isWriteCacheEnabled = this.getObjectForParam(params, "Missing code - ClientParameterCode.DIRECT_ACCESS_DEVICE_IS_W_CACHE_ENABLE", true);
            Object isWriteProtected = this.getObjectForParam(params, "Missing code - ClientParameterCode.DIRECT_ACCESS_DEVICE_IS_W_PROTECTED", true);
            Object lun = this.getObjectForParam(params, "Missing code - ClientParameterCode.SCSI_DEVICE_LUN", true);
            Object entityName = this.getObjectForParam(params, "Missing code - ClientParameterCode.SCSI_DEVICE_ENTITY_NAME", true);
            Object allocatedSpace = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_ALLOCATED_SPACE", true);
            Object vendor = this.getObjectForParam(params, "Missing code - ClientParameterCode.SCSI_DEVICE_VENDOR", true);
            Object info = this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_DEVICE_INFO, true);
            Object driveType = this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, true);
            Object deviceType = this.getObjectForParam(params, "Missing code - ClientParameterCode.SCSI_DEVICE_TYPE", true);
            Object isBlinking = this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_BLINK_STATUS, true);
            Object serialNumber = this.getObjectForParam(params, ClientParameterCode.SCSI_DEVICE_SERIAL_NUMBER, true);
            Object productID = this.getObjectForParam(params, "Missing code - ClientParameterCode.SCSI_DEVICE_PRODUCT_ID", true);
            Object revisionLevel = this.getObjectForParam(params, "Missing code - ClientParameterCode.SCSI_DEVICE_REVISION_LEVEL", true);
            Object SCSIVersion = this.getObjectForParam(params, "Missing code - ClientParameterCode.SCSI_DEVICE_SCSI_VERSION", true);
            Object accessibleSpace = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_ACCESSIBLE_SPACE", true);
            Object volState = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_STATE", true);
            Object positionInParent = this.getObjectForParam(params, "Missing code - ClientParameterCode.VOLUME_POSITION_IN_PARENT", true);
            Object propagatedState = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", true);
            Object transportType = this.getObjectForParam(params, "Missing code - ClientParameterCode.DIRECT_ACCESS_DEVICE_TRANSPORT_TYPE", true);
            Object isAllocable = this.getObjectForParam(params, "Missing code - ClientParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE", true);
            PhysicalStorageOperStatusConstant operStatus = (PhysicalStorageOperStatusConstant)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_OPER_STATUS, true);
            PhysicalStorageRaidLevelConstant raidLevel = (PhysicalStorageRaidLevelConstant)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, true);
            String raidSysName = (String)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_SYSTEM_NAME, true);
            String raidModelName = (String)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_MODEL_NAME, true);
            BigInteger raidCreationTime = (BigInteger)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_CREATION_TIME, true);
            String raidFwRev = (String)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_FIRMWARE_REV, true);
            SrBITSConstant raidStatus = (SrBITSConstant)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_STATUS, true);
            String raidUrl1 = (String)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL1, true);
            String raidUrl2 = (String)this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL2, true);
            byte[] entityNameFormat = (byte[])this.getObjectForParam(params, ClientParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, true);
            boolean isDirectAccessDevice = element instanceof DirectAccessDevice;
            if (aliasObj == null) {
                aliasObj = directAccessDevice.getAlias();
            }
            if (isExposedObj == null) {
                isExposedObj = new Boolean(directAccessDevice.isExposed());
            }
            if (subDisksObj == null && isDirectAccessDevice) {
                subDisksObj = ((DirectAccessDevice)directAccessDevice).getSubDirectAccessDevices();
            }
            if (isFreeObj == null) {
                isFreeObj = new Boolean(directAccessDevice.isFree());
            }
            if (isDirectAccessDevice) {
                if (blockSize == null) {
                    blockSize = new Integer(((DirectAccessDevice)directAccessDevice).getBlockSize());
                }
                if (nonAllocatedSpace == null) {
                    nonAllocatedSpace = ((DirectAccessDevice)directAccessDevice).getNonAllocatedSpace();
                }
                if (totalSpace == null) {
                    totalSpace = ((DirectAccessDevice)directAccessDevice).getTotalSpace();
                }
                if (storageSpaceStatus == null) {
                    storageSpaceStatus = ((DirectAccessDevice)directAccessDevice).getStorageSpaceStatus();
                }
                if (isWriteCacheEnabled == null) {
                    isWriteCacheEnabled = ((DirectAccessDevice)directAccessDevice).isWriteCacheEnabled();
                }
                if (isWriteProtected == null) {
                    isWriteProtected = ((DirectAccessDevice)directAccessDevice).isWriteProtected();
                }
                if (isAllocable == null) {
                    isAllocable = ((DirectAccessDevice)directAccessDevice).isAllocable();
                }
            }
            if (lun == null) {
                lun = directAccessDevice.getLUN();
            }
            if (entityName == null) {
                entityName = directAccessDevice.getEntityName();
            }
            if (allocatedSpace == null) {
                allocatedSpace = directAccessDevice.getAllocatedSpace();
            }
            if (vendor == null) {
                vendor = directAccessDevice.getVendor();
            }
            if (deviceType == null) {
                deviceType = directAccessDevice.getType();
            }
            if (isBlinking == null) {
                isBlinking = new Boolean(directAccessDevice.isBlinking());
            }
            if (serialNumber == null) {
                serialNumber = directAccessDevice.getSerialNumber();
            }
            if (productID == null) {
                productID = directAccessDevice.getProductID();
            }
            if (revisionLevel == null) {
                revisionLevel = directAccessDevice.getRevisionLevel();
            }
            if (SCSIVersion == null) {
                SCSIVersion = directAccessDevice.getSCSIVersion();
            }
            if (accessibleSpace == null) {
                accessibleSpace = directAccessDevice.getAccessibleSpace();
            }
            if (volState == null) {
                volState = directAccessDevice.getVolumeState();
            }
            if (positionInParent == null) {
                positionInParent = directAccessDevice.getPositionInParent();
            }
            if (propagatedState == null) {
                propagatedState = directAccessDevice.getPropagatedState();
            }
            if (transportType == null) {
                transportType = directAccessDevice.getTransportType();
            }
            String alias = (String)aliasObj;
            String transportTypeStr = transportType.toString();
            boolean isExposed = (Boolean)isExposedObj;
            List subdisks = null;
            if (isDirectAccessDevice && subDisksObj != null) {
                subdisks = (List)subDisksObj;
            }
            StorageDeviceNode node = null;
            SrTreeNode o = SystemRootNode.getInstance().getRefByStub(directAccessDevice);
            node = o != null ? (DirectAccessDeviceNode<DirectAccessDevice>)o : (isDirectAccessDevice ? new DirectAccessDeviceNode<DirectAccessDevice>((DirectAccessDevice)element, alias, isExposed, transportTypeStr) : (element instanceof SequentialAccessDevice ? new SequentialAccessDeviceNode((SequentialAccessDevice)element, alias, isExposed, transportTypeStr) : new StorageDeviceNode<LogicObject>(element, alias, isExposed, transportTypeStr)));
            node.setFree((Boolean)isFreeObj);
            if (isDirectAccessDevice) {
                node.setBlockSize((Integer)blockSize);
                ((DirectAccessDeviceNode)node).setNonAllocatedSpace((BigInteger)nonAllocatedSpace);
                ((DirectAccessDeviceNode)node).setTotalSpace(totalSpace);
                ((DirectAccessDeviceNode)node).setSplits((List)storageSpaceStatus);
                ((DirectAccessDeviceNode)node).setWriteCacheEnabled((Boolean)isWriteCacheEnabled);
                ((DirectAccessDeviceNode)node).setWriteProtected((Boolean)isWriteProtected);
                ((DirectAccessDeviceNode)node).setIsAllocable((Boolean)isAllocable);
                ((DirectAccessDeviceNode)node).setDriveType((PhysicalStorageDriveTypeConstant)driveType);
                ((DirectAccessDeviceNode)node).setRaid(raidLevel, raidStatus, raidCreationTime, raidSysName, raidModelName, raidFwRev, raidUrl1, raidUrl2);
            }
            node.setStorageOperStatus(operStatus);
            node.setRemoteLU((String)lun);
            node.setGroup("");
            node.setEntityName((String)entityName);
            node.setEntityNameFormat(new SrEntityNameFormat(entityNameFormat));
            node.setAllocatedSpace((BigInteger)allocatedSpace);
            node.setVendor((String)vendor);
            node.setInfo((String)info);
            node.setDeviceType((String)deviceType);
            if (isBlinking instanceof Integer) {
                PhysicalStorageComOperStatusConstant blink = PhysicalStorageComOperStatusConstant.getOperStat((Integer)isBlinking);
                isBlinking = new Boolean(blink.equals(PhysicalStorageComOperStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK));
            }
            node.setBlinking((Boolean)isBlinking);
            node.setSerialNumber((String)serialNumber);
            node.setProductId((String)productID);
            node.setRevisionLevel((String)revisionLevel);
            node.setSCSIVersion((Integer)SCSIVersion);
            node.setAccessibleSpace((BigInteger)accessibleSpace);
            node.setVolStateBits((SrBITSConstant)volState);
            node.setPositionInParent((Integer)positionInParent);
            node.setStatus(DirectAccessDeviceManager.getSeverity((AlarmSeverity)propagatedState));
            if (isDirectAccessDevice) {
                this.handleSubdisksCreation(subdisks, (DirectAccessDeviceNode)node);
            }
            StorageDeviceNode[] nodes = new StorageDeviceNode[]{node};
            SystemRootNode.getInstance().putRefAndStub(element, node);
            StorageManager.getInstance().addStorageData(nodes);
            if (isDirectAccessDevice) {
                RaidManager.getInstance().reactToDiskCreated((DirectAccessDeviceNode)node);
            }
            this.fireDirectAccessDeviceCreated(node);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "caught exception while creating the Disk node.");
            DirectAccessDeviceManager.onConnectionError();
        }
    }

    private void handleSubdisksCreation(List subdisks, DirectAccessDeviceNode node) throws RemoteException {
        for (int i = 0; i < subdisks.size(); ++i) {
            SubDirectAccessDevice stub = (SubDirectAccessDevice)subdisks.get(i);
            SrTreeNode object = SystemRootNode.getInstance().getRefByStub(stub);
            SubDirectAccessDeviceNode subnode = null;
            if (object == null) {
                subnode = new SubDirectAccessDeviceNode(stub, stub.getAlias(), stub.isExposed());
                SystemRootNode.getInstance().putRefAndStub(stub, subnode);
            } else {
                subnode = (SubDirectAccessDeviceNode)object;
            }
            subnode.setTotalSpace(stub.getSize());
            subnode.setBlockSize(new Integer(stub.getBlockSize()));
            subnode.setEntityName(stub.getEntityName());
            subnode.setFree(stub.isFree());
            subnode.setTotalSpace(stub.getSize());
            subnode.setDirectAccessDeviceParent(node);
            subnode.setStartAddress(stub.getStartAddress());
            subnode.setEndAddress(stub.getEndAddress());
            subnode.setInfo(stub.getInfo());
            subnode.setAllocatedSpace(stub.getAllocatedSpace());
            subnode.setStatus(DirectAccessDeviceManager.getSeverity(stub.getPropagatedState()));
            subnode.setAccessibleSpace(stub.getAccessibleSpace());
            subnode.setPositionInParent(stub.getPositionInParent());
            subnode.setSubdiskOperStatus(stub.getOperStatus());
        }
    }

    @Override
    public void alreadyKnownByVSwitch(CommunicationEvent e) {
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof DirectAccessDevice || element instanceof SequentialAccessDevice || element instanceof GeneralSCSIDevice) {
            if (SystemRootNode.getInstance().getRefByStub(element) == null) {
                theLogger.trace(SrLogCategories.LEGACY, "DirectAccessDeviceManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            theLogger.trace(SrLogCategories.LEGACY, "DirectAccessDeviceManager: propagatedStateChanged().");
            super.propagatedStateChanged(e);
            DirectAccessDeviceEvent event = new DirectAccessDeviceEvent(this, element);
            this.fireStatusChanged(event);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (element instanceof SubDirectAccessDevice) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "DirectAccessDeviceManager: elementRemoved()");
        SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
        if (node != null) {
            if (node instanceof DirectAccessDeviceNode) {
                RaidManager.getInstance().reactToDiskRemoved((DirectAccessDeviceNode)node);
            }
            this.fireDirectAccessDeviceRemoved((StorageDeviceNode)node);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
            StorageManager.getInstance().removeStorage((StorageDeviceNode)node);
        }
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    private void fireStatusChanged(DirectAccessDeviceEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "DirectAccessDeviceManager: fireStatusChanged().");
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceStatusChangedInformer);
    }

    private void fireAliasChanged(StorageDeviceNode device) {
        DirectAccessDeviceEvent event = this.createEvent(device);
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceAliasChangedInformer);
    }

    private void fireDirectAccessDeviceRemoved(StorageDeviceNode node) {
        DirectAccessDeviceEvent event = this.createEvent(node);
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceRemovedInformer);
    }

    private void fireDirectAccessDeviceCreated(StorageDeviceNode node) {
        DirectAccessDeviceEvent event = this.createEvent(node);
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceCreatedInformer);
    }

    private void fireInfoChanged(StorageDeviceNode node) {
        DirectAccessDeviceEvent event = this.createEvent(node);
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceInfoChangedInformer);
    }

    private void fireDirectAccessDeviceExposed(StorageDeviceNode device) {
        DirectAccessDeviceEvent event = this.createEvent(device);
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceExposedInformer);
    }

    private void fireDirectAccessDeviceDeExposed(StorageDeviceNode device) {
        DirectAccessDeviceEvent event = this.createEvent(device);
        device.setConfigurationParent(null);
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceDeExposedInformer);
    }

    private void fireDirectAccessDeviceBlinkStateChange(StorageDeviceNode device) {
        DirectAccessDeviceEvent event = this.createEvent(device);
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceBlinkStateChangeInformer);
    }

    public void fireDirectAccessDeviceChanged(StorageDeviceNode device) {
        DirectAccessDeviceEvent event = this.createEvent(device);
        this.m_listeners.fireEvent(DirectAccessDeviceListener.class, event, this.directAccessDeviceChangedInformer);
    }

    public void fireDirectAccessDeviceStateChanged(StorageDeviceNode node) {
    }

    private DirectAccessDeviceEvent createEvent(StorageDeviceNode device) {
        DirectAccessDeviceEvent event = null;
        event = new DirectAccessDeviceEvent(this, device, (RemoteObject)device.getStub(), device.getAlias());
        return event;
    }

    public List<DirectAccessDeviceNode<DirectAccessDevice>> getAllDisks(ClusterNode aCluster) {
        List<StorageDeviceNode> storgList = StorageManager.getInstance().getStorages(aCluster);
        ArrayList<DirectAccessDeviceNode<DirectAccessDevice>> retList = new ArrayList<DirectAccessDeviceNode<DirectAccessDevice>>();
        for (StorageDeviceNode strg : storgList) {
            if (!strg.isDisk()) continue;
            retList.add((DirectAccessDeviceNode)strg);
        }
        return retList;
    }
}

