/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.storage;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StoragePoolSelector;
import com.sanrad.nms.client.gui.storage.AvailableStorageTableHeader;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageDriveTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import com.sanrad.util.Util;
import com.sanrad.util.filter.SortKeyProvider;
import com.sanrad.util.filter.SrSortingMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AvailableStorageTableModel
extends SrTableModel {
    private static final long serialVersionUID = 1L;

    public AvailableStorageTableModel() {
        super(new SrDefaultTableColumns((List<String>)AvailableStorageTableHeader.getColumnNames()));
    }

    public void updateTable(ClusterNode aCluster) {
        if (aCluster == null) {
            this.removeAllRows();
            return;
        }
        List<DirectAccessDeviceNode> disks = StoragePoolSelector.getClusterDisks(aCluster);
        Map<RaidParams, List<DirectAccessDeviceNode>> map = SrSortingMap.sort(new RaidParams(), disks);
        ArrayList<RaidParams> allParams = new ArrayList<RaidParams>(map.keySet());
        Iterator<RaidParams> i = allParams.iterator();
        while (i.hasNext()) {
            RaidParams params = i.next();
            int row = this.findRow(params);
            List<DirectAccessDeviceNode> sortedGroup = map.get(params);
            BigInteger totalSpace = this.getTotalSpace(sortedGroup);
            BigInteger freeSpace = this.getFreeSpace(sortedGroup);
            if (BigInteger.ZERO.equals(freeSpace)) {
                i.remove();
                continue;
            }
            if (row < 0) {
                this.addRow(this.createRow(params, totalSpace, freeSpace));
                continue;
            }
            this.editRow(row, this.createRow(params, totalSpace, freeSpace));
        }
        List allParamsInTable = this.getColumnValues(AvailableStorageTableHeader.TYPE.getColumnName());
        allParamsInTable.removeAll(map.keySet());
        ArrayList<Integer> oldRowsIndices = new ArrayList<Integer>();
        for (RaidParams prevParams : allParamsInTable) {
            int oldRowIndex = this.findRow(prevParams);
            if (oldRowIndex <= -1) continue;
            oldRowsIndices.add(oldRowIndex);
        }
        Collections.sort(oldRowsIndices);
        Collections.reverse(oldRowsIndices);
        for (Integer i2 : oldRowsIndices) {
            this.removeRow(i2);
        }
    }

    private Object[] createRow(RaidParams aParams, BigInteger aTotalSpace, BigInteger aFreeSpace) {
        Object[] row = new Object[]{aParams, aTotalSpace, aFreeSpace};
        return row;
    }

    private BigInteger getTotalSpace(List<DirectAccessDeviceNode> aDisks) {
        if (aDisks == null) {
            throw new IllegalArgumentException("The given disks should not be null.");
        }
        BigInteger total = BigInteger.ZERO;
        for (DirectAccessDeviceNode disk : aDisks) {
            total = total.add(disk.getTotalSpace());
        }
        return total;
    }

    private BigInteger getFreeSpace(List<DirectAccessDeviceNode> aDisks) {
        if (aDisks == null) {
            throw new IllegalArgumentException("The given disks should not be null.");
        }
        BigInteger total = BigInteger.ZERO;
        for (DirectAccessDeviceNode disk : aDisks) {
            total = total.add(disk.getNonAllocatedSpace());
        }
        return total;
    }

    @Override
    public void addListeners() {
    }

    @Override
    public void removeListeners() {
    }

    public static class RaidParams
    implements SortKeyProvider<RaidParams, DirectAccessDeviceNode> {
        PhysicalStorageDriveTypeConstant myType;
        PhysicalStorageRaidLevelConstant myLevel;

        RaidParams() {
        }

        private RaidParams(PhysicalStorageDriveTypeConstant aType, PhysicalStorageRaidLevelConstant aRaidLevel) {
            this.myType = aType;
            this.myLevel = aRaidLevel;
        }

        public PhysicalStorageDriveTypeConstant getDriveType() {
            return this.myType;
        }

        public PhysicalStorageRaidLevelConstant getRaidLevel() {
            return this.myLevel;
        }

        @Override
        public RaidParams getSortBy(DirectAccessDeviceNode aValue) {
            return new RaidParams(aValue.getDriveType(), aValue.getRaidLevel());
        }

        public boolean equals(Object o) {
            if (!(o instanceof RaidParams)) {
                return false;
            }
            RaidParams other = (RaidParams)o;
            boolean isSameType = Util.equalsWithNull(other.getDriveType(), this.getDriveType());
            boolean isSameRaidLevel = Util.equalsWithNull(other.getRaidLevel(), this.getRaidLevel());
            return isSameType && isSameRaidLevel;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('[');
            sb.append(String.valueOf(this.myType));
            sb.append(',');
            sb.append(String.valueOf(this.myLevel));
            sb.append(']');
            return sb.toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

