/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.srv.radius;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.data.srv.SrExternalServersTableModel;
import com.sanrad.nms.client.data.srv.radius.RadiusServerNode;
import com.sanrad.nms.client.event.srv.radius.RadiusServerEvent;
import com.sanrad.nms.client.gui.srv.radius.RadiusServersTableHeader;
import com.sanrad.swing.SrDefaultTableColumns;
import java.util.Vector;

public class SrRadiusServersTableModel
extends SrExternalServersTableModel {
    public SrRadiusServersTableModel(ClusterNode aClusterNode) {
        super(new SrDefaultTableColumns(RadiusServersTableHeader.getColumnNames()));
        Vector radiusServers = aClusterNode.getRadiusServers();
        for (int i = 0; i < radiusServers.size(); ++i) {
            this.addRow((RadiusServerNode)radiusServers.get(i));
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    protected void addRow(ExternalServerNode serverNode) {
        RadiusServerNode radiusNode = (RadiusServerNode)serverNode;
        Vector<Comparable> rowData = new Vector<Comparable>(RadiusServersTableHeader.getColumnNames().size());
        rowData.addElement(radiusNode);
        rowData.addElement(radiusNode.getPort());
        this.addRowQuetly(rowData.toArray(), -1);
    }

    public void radiusServerCreated(RadiusServerEvent e) {
        ExternalServerNode serverNode = e.getServerNode();
        this.addRow(serverNode);
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    public void radiusServerRemoved(RadiusServerEvent e) {
        ExternalServerNode serverNode = e.getServerNode();
        int rows = this.getRowCount();
        int col = this.getColumnOfServer();
        for (int i = 0; i < rows; ++i) {
            if (!this.getValueAt(i, col).equals(serverNode)) continue;
            this.removeRow(i);
            return;
        }
    }

    public void radiusServerStatusChanged(RadiusServerEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }

    @Override
    protected int getColumnOfServer() {
        return this.getColumnIndex(RadiusServersTableHeader.SERVER.getColumnName());
    }
}

