/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.srv.radius;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.srv.ExternalServerValidator;
import com.sanrad.util.SrConstantsBundleKeys;

public class RadiusServerValidator
extends ExternalServerValidator {
    public static int MAX_KEY_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.RADIUS_SERVER_MAX_KEY_LENGTH));
    public static int MIN_KEY_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.RADIUS_SERVER_MIN_KEY_LENGTH));
    private String ip;
    private String port;
    private String key1;
    private String key2;

    public RadiusServerValidator(String ip, String port, String key1, String key2) {
        this.ip = ip;
        this.port = port;
        this.key1 = key1;
        this.key2 = key2;
    }

    @Override
    public boolean isValidForCreation() {
        if (this.key1.equals("") || this.key2.equals("")) {
            this.setErrorMessage("Invalid Key");
            return false;
        }
        if (!this.key1.equalsIgnoreCase(this.key2)) {
            this.setErrorMessage("Invalid Key");
            return false;
        }
        int len = this.key1.length();
        if (len < MIN_KEY_LENGTH || len > MAX_KEY_LENGTH) {
            this.setErrorMessage("Key must contain " + MIN_KEY_LENGTH + " - " + MAX_KEY_LENGTH + " characters.");
            return false;
        }
        if (this.ip.equals("")) {
            this.setErrorMessage("Invalid IP.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidForRemoval() {
        return false;
    }
}

