/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.srv.radius;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.ExternalServerManager;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.data.srv.radius.RadiusServerNode;
import com.sanrad.nms.client.event.srv.radius.RadiusServerEvent;
import com.sanrad.nms.client.event.srv.radius.RadiusServerListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.srv.radius.RadiusServer;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class RadiusServerManager
extends ExternalServerManager<RadiusServer> {
    private static RadiusServerManager instance;
    private static SrLogger theLogger;
    SrEventListenerManager.Informer radiusServerCreatedInformer = new SrEventListenerManager.Informer<RadiusServerListener, RadiusServerEvent>(){

        @Override
        public void inform(RadiusServerListener listener, RadiusServerEvent event) {
            listener.radiusServerCreated(event);
        }
    };
    SrEventListenerManager.Informer radiusServerRemovedInformer = new SrEventListenerManager.Informer<RadiusServerListener, RadiusServerEvent>(){

        @Override
        public void inform(RadiusServerListener listener, RadiusServerEvent event) {
            listener.radiusServerRemoved(event);
        }
    };
    SrEventListenerManager.Informer radiusServerStatusChangedInformer = new SrEventListenerManager.Informer<RadiusServerListener, RadiusServerEvent>(){

        @Override
        public void inform(RadiusServerListener listener, RadiusServerEvent event) {
            listener.radiusServerStatusChanged(event);
        }
    };

    private RadiusServerManager() {
    }

    public static synchronized RadiusServerManager getInstance() {
        if (instance == null) {
            instance = new RadiusServerManager();
        }
        return instance;
    }

    public void addRasiusServerListener(RadiusServerListener l) {
        this.m_listeners.add(l);
    }

    public void removeRasiusServerListener(RadiusServerListener l) {
        this.m_listeners.remove(l);
    }

    public SrFuture<Void> addNewRadiusServer(ClusterNode clusterNode, String serverIp, String port, String key) {
        return ClientAOImpl.getInstance().addNewRadiusServer((CommKeyClassId)clusterNode.getIdentifier(), serverIp, port, key);
    }

    @Override
    public void clearExternalServers(ClusterNode clusterNode) {
        Vector radiusServers = clusterNode.getRadiusServers();
        for (int i = 0; i < radiusServers.size(); ++i) {
            this.fireExternalServerRemovedEvent((RadiusServerNode)radiusServers.get(i));
        }
        radiusServers.clear();
    }

    @Override
    protected boolean isExternalServerType(Object element) {
        return element instanceof RadiusServer;
    }

    @Override
    protected void removeExternalServerNode(ClusterNode clusterNode, ExternalServerNode radiusNode) {
        clusterNode.removeRadiusServer(radiusNode);
    }

    @Override
    protected void addExternalServerToCluster(ClusterNode clusterNode, ExternalServerNode radiusNode) {
        clusterNode.addRadiusServer(radiusNode);
    }

    @Override
    protected ExternalServerNode createExternalServerNode(RadiusServer radiusServer, HashMap params) throws RemoteException {
        Object radiusServerPort = this.getObjectForParam(params, "Missing code - ClientParameterCode.RADIUS_SERVER_PORT", true);
        Object radiusServerKey = this.getObjectForParam(params, "Missing code - ClientParameterCode.RADIUS_SERVER_KEY", true);
        Object serverIP = this.getObjectForParam(params, "Missing code - ClientParameterCode.RADIUS_SERVER_IP", true);
        Object propagatedStateObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", true);
        if (radiusServerPort == null) {
            radiusServerPort = radiusServer.getRadiusServerPort();
        }
        if (radiusServerKey == null) {
            radiusServerKey = radiusServer.getRadiusServerKey();
        }
        if (serverIP == null) {
            serverIP = radiusServer.getServerIP();
        }
        if (propagatedStateObj == null) {
            propagatedStateObj = radiusServer.getPropagatedState();
        }
        Integer port = (Integer)radiusServerPort;
        String key = (String)radiusServerKey;
        String ip = (String)serverIP;
        RadiusServerNode radiusNode = new RadiusServerNode(radiusServer, ip, port, key);
        radiusNode.setStatus(RadiusServerManager.getSeverity((AlarmSeverity)propagatedStateObj));
        SystemRootNode.getInstance().putRefAndStub(radiusServer, radiusNode);
        return radiusNode;
    }

    @Override
    protected void fireExternalServerCreatedEvent(ExternalServerNode serverNode) {
        RadiusServerEvent event = new RadiusServerEvent((Object)this, (RemoteObject)serverNode.getStub(), (RadiusServerNode)serverNode);
        this.m_listeners.fireEvent(RadiusServerListener.class, event, this.radiusServerCreatedInformer);
    }

    @Override
    protected void fireExternalServerRemovedEvent(ExternalServerNode serverNode) {
        RadiusServerEvent event = new RadiusServerEvent((Object)this, (RemoteObject)serverNode.getStub(), (RadiusServerNode)serverNode);
        this.m_listeners.fireEvent(RadiusServerListener.class, event, this.radiusServerRemovedInformer);
    }

    @Override
    protected void externalServerPropertiesChanged(ExternalServerNode serverNode, HashMap params) {
    }

    @Override
    protected void fireExternalServerChanged(ExternalServerNode serverNode) {
    }

    @Override
    protected void fireExternalServerStatusChanged(ExternalServerNode serverNode) {
        RadiusServerEvent event = new RadiusServerEvent((Object)this, (RemoteObject)serverNode.getStub(), (RadiusServerNode)serverNode);
        this.m_listeners.fireEvent(RadiusServerListener.class, event, this.radiusServerStatusChangedInformer);
    }

    @Override
    public Vector readAllExternalServers(ClusterNode clusterNode, boolean broadcast) {
        Vector radiusServers = ClusterManager.getInstance().getAllRadiusServers(clusterNode);
        Vector<ExternalServerNode> radiusServersNodes = new Vector<ExternalServerNode>(radiusServers.size());
        try {
            for (int i = 0; i < radiusServers.size(); ++i) {
                RadiusServer radiusServer = (RadiusServer)radiusServers.get(i);
                ExternalServerNode radiusServerNode = this.createExternalServerNode(radiusServer, (HashMap)null);
                radiusServersNodes.addElement(radiusServerNode);
                if (!broadcast) continue;
                this.fireExternalServerCreatedEvent(radiusServerNode);
            }
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e, new Object[0]);
            Manager.onConnectionError();
        }
        return radiusServersNodes;
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

