/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.srv.isns;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.data.srv.SrExternalServersTableModel;
import com.sanrad.nms.client.data.srv.isns.ISNSServerNode;
import com.sanrad.nms.client.event.srv.isns.ISNSServerEvent;
import com.sanrad.nms.client.gui.srv.isns.ISNSServersTableHeader;
import com.sanrad.swing.SrDefaultTableColumns;
import java.util.Vector;

public class SrISNSServersTableModel
extends SrExternalServersTableModel {
    public SrISNSServersTableModel(ClusterNode aClusterNode) {
        super(new SrDefaultTableColumns(ISNSServersTableHeader.getColumnNames()));
        Vector isnsServers = aClusterNode.getISNSServers();
        for (int i = 0; i < isnsServers.size(); ++i) {
            this.addRow((ISNSServerNode)isnsServers.get(i));
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    protected int getColumnOfServer() {
        return this.getColumnIndex(ISNSServersTableHeader.SERVER.getColumnName());
    }

    protected void addRow(ExternalServerNode serverNode) {
        ISNSServerNode isnsNode = (ISNSServerNode)serverNode;
        Vector<ISNSServerNode> rowData = new Vector<ISNSServerNode>(ISNSServersTableHeader.getColumnNames().size());
        rowData.addElement(isnsNode);
        this.addRowQuetly(rowData.toArray(), -1);
    }

    public void isnsServerCreated(ISNSServerEvent e) {
        ExternalServerNode serverNode = e.getServerNode();
        this.addRow(serverNode);
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    public void isnsServerRemoved(ISNSServerEvent e) {
        ExternalServerNode serverNode = e.getServerNode();
        int rows = this.getRowCount();
        int col = this.getColumnOfServer();
        for (int i = 0; i < rows; ++i) {
            if (!this.getValueAt(i, col).equals(serverNode)) continue;
            this.removeRow(i);
            return;
        }
    }

    public void isnsServerStatusChanged(ISNSServerEvent e) {
        this.fireTableRowsUpdated(0, this.getLastRowIndex());
    }
}

