/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.srv.isns;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterManager;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.ExternalServerManager;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.data.srv.isns.ISNSServerNode;
import com.sanrad.nms.client.event.srv.isns.ISNSServerEvent;
import com.sanrad.nms.client.event.srv.isns.ISNSServerListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.srv.isns.ISNSServer;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class ISNSServerManager
extends ExternalServerManager<ISNSServer> {
    private static ISNSServerManager instance;
    private static SrLogger theLogger;
    SrEventListenerManager.Informer isnsServerCreatedInformer = new SrEventListenerManager.Informer<ISNSServerListener, ISNSServerEvent>(){

        @Override
        public void inform(ISNSServerListener listener, ISNSServerEvent event) {
            listener.isnsServerCreated(event);
        }
    };
    SrEventListenerManager.Informer isnsServerRemovedInformer = new SrEventListenerManager.Informer<ISNSServerListener, ISNSServerEvent>(){

        @Override
        public void inform(ISNSServerListener listener, ISNSServerEvent event) {
            listener.isnsServerRemoved(event);
        }
    };
    SrEventListenerManager.Informer isnsServerStatusChangedInformer = new SrEventListenerManager.Informer<ISNSServerListener, ISNSServerEvent>(){

        @Override
        public void inform(ISNSServerListener listener, ISNSServerEvent event) {
            listener.isnsServerStatusChanged(event);
        }
    };

    private ISNSServerManager() {
    }

    public static synchronized ISNSServerManager getInstance() {
        if (instance == null) {
            instance = new ISNSServerManager();
        }
        return instance;
    }

    public void addISNSServerListener(ISNSServerListener l) {
        this.m_listeners.add(l);
    }

    public void removeISNSServerListener(ISNSServerListener l) {
        this.m_listeners.remove(l);
    }

    public SrFuture<Void> addNewISNSServer(ClusterNode clusterNode, String ip) {
        return ClientAOImpl.getInstance().addNewISNSServer((CommKeyClassId)clusterNode.getIdentifier(), ip);
    }

    @Override
    public void clearExternalServers(ClusterNode clusterNode) {
        Vector isnsServers = clusterNode.getISNSServers();
        for (int i = 0; i < isnsServers.size(); ++i) {
            this.fireExternalServerRemovedEvent((ISNSServerNode)isnsServers.get(i));
        }
        isnsServers.clear();
    }

    @Override
    protected boolean isExternalServerType(Object element) {
        return element instanceof ISNSServer;
    }

    @Override
    protected void removeExternalServerNode(ClusterNode clusterNode, ExternalServerNode isnsNode) {
        clusterNode.removeISNSServer(isnsNode);
    }

    @Override
    protected ExternalServerNode createExternalServerNode(ISNSServer isnsServer, HashMap params) throws RemoteException {
        Object ipObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.ISNS_SERVER_IP", true);
        Object propagatedStateObj = this.getObjectForParam(params, "Missing code - ClientParameterCode.PROPAGATED_STATE", true);
        if (ipObj == null) {
            ipObj = isnsServer.getServerIP();
        }
        if (propagatedStateObj == null) {
            propagatedStateObj = isnsServer.getPropagatedState();
        }
        String ip = (String)ipObj;
        ISNSServerNode isnsNode = new ISNSServerNode(isnsServer, ip);
        isnsNode.setStatus(ISNSServerManager.getSeverity((AlarmSeverity)propagatedStateObj));
        SystemRootNode.getInstance().putRefAndStub(isnsServer, isnsNode);
        return isnsNode;
    }

    @Override
    protected void fireExternalServerCreatedEvent(ExternalServerNode serverNode) {
        ISNSServerEvent event = new ISNSServerEvent((Object)this, (RemoteObject)serverNode.getStub(), (ISNSServerNode)serverNode);
        this.m_listeners.fireEvent(ISNSServerListener.class, event, this.isnsServerCreatedInformer);
    }

    @Override
    protected void fireExternalServerRemovedEvent(ExternalServerNode serverNode) {
        ISNSServerEvent event = new ISNSServerEvent((Object)this, (RemoteObject)serverNode.getStub(), (ISNSServerNode)serverNode);
        this.m_listeners.fireEvent(ISNSServerListener.class, event, this.isnsServerRemovedInformer);
    }

    @Override
    protected void externalServerPropertiesChanged(ExternalServerNode serverNode, HashMap params) {
    }

    @Override
    protected void fireExternalServerChanged(ExternalServerNode serverNode) {
    }

    @Override
    protected void fireExternalServerStatusChanged(ExternalServerNode serverNode) {
        ISNSServerEvent event = new ISNSServerEvent((Object)this, (RemoteObject)serverNode.getStub(), (ISNSServerNode)serverNode);
        this.m_listeners.fireEvent(ISNSServerListener.class, event, this.isnsServerStatusChangedInformer);
    }

    @Override
    public Vector readAllExternalServers(ClusterNode clusterNode, boolean broadcast) {
        Vector isnsServers = ClusterManager.getInstance().getAllISNSServers(clusterNode);
        Vector<ExternalServerNode> isnsServersNodes = new Vector<ExternalServerNode>(isnsServers.size());
        try {
            for (int i = 0; i < isnsServers.size(); ++i) {
                ISNSServer isnsServer = (ISNSServer)isnsServers.get(i);
                ExternalServerNode isnsServerNode = this.createExternalServerNode(isnsServer, (HashMap)null);
                isnsServersNodes.addElement(isnsServerNode);
                if (!broadcast) continue;
                this.fireExternalServerCreatedEvent(isnsServerNode);
            }
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e, new Object[0]);
            Manager.onConnectionError();
        }
        return isnsServersNodes;
    }

    @Override
    protected void addExternalServerToCluster(ClusterNode clusterNode, ExternalServerNode serverNode) {
        clusterNode.addISNSServer(serverNode);
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

