/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.srv;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.srv.ExternalServerNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.srv.ExternalServer;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public abstract class ExternalServerManager<T extends ExternalServer>
extends ElementManager {
    private static SrLogger theLogger = SrLogger.getLogger();

    protected ExternalServerManager() {
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        try {
            RemoteObject element = e.getElement();
            if (this.isClusterInDiscovery(element)) {
                return;
            }
            if (this.isExternalServerType(element)) {
                if (this.alreadyExist(element)) {
                    return;
                }
                HashMap params = this.getParameterList(e);
                Cluster cluster = SystemRootNode.getCluster((ExternalServer)element);
                ExternalServerNode serverNode = this.createExternalServerNode((ExternalServer)element, params);
                ClusterNode clusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(cluster);
                this.addExternalServerToCluster(clusterNode, serverNode);
                SystemRootNode.getInstance().putRefAndStub(element, serverNode);
                this.fireExternalServerCreatedEvent(serverNode);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ExternalServerManager.onConnectionError();
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        SrTreeNode node;
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.isExternalServerType(element) && (node = SystemRootNode.getInstance().getRefByStub(element)) != null) {
            Cluster cluster = null;
            try {
                cluster = SystemRootNode.getCluster((ExternalServer)element);
            }
            catch (RemoteException ex) {
                theLogger.error(SrLogCategories.LEGACY, ex, new Object[0]);
            }
            ClusterNode clusterNode = (ClusterNode)SystemRootNode.getInstance().getRefByStub(cluster);
            this.removeExternalServerNode(clusterNode, (ExternalServerNode)node);
            this.fireExternalServerRemovedEvent((ExternalServerNode)node);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.isExternalServerType(element)) {
            HashMap map = this.getParameterList(e);
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
            if (node != null) {
                this.externalServerPropertiesChanged((ExternalServerNode)node, map);
                this.fireExternalServerChanged((ExternalServerNode)node);
            }
        }
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject element = e.getStub();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.isExternalServerType(element)) {
            SrTreeNode node = SystemRootNode.getInstance().getRefByStub(element);
            if (node == null) {
                theLogger.trace(SrLogCategories.LEGACY, "ExternalServerManager- propagatedStateChanged() on an unknown element !");
                return;
            }
            super.propagatedStateChanged(e);
            this.fireExternalServerStatusChanged((ExternalServerNode)node);
        }
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    protected abstract ExternalServerNode createExternalServerNode(T var1, HashMap var2) throws RemoteException;

    protected abstract void removeExternalServerNode(ClusterNode var1, ExternalServerNode var2);

    protected abstract void fireExternalServerCreatedEvent(ExternalServerNode var1);

    protected abstract void fireExternalServerRemovedEvent(ExternalServerNode var1);

    protected abstract void externalServerPropertiesChanged(ExternalServerNode var1, HashMap var2);

    protected abstract void fireExternalServerChanged(ExternalServerNode var1);

    protected abstract void fireExternalServerStatusChanged(ExternalServerNode var1);

    public abstract Vector readAllExternalServers(ClusterNode var1, boolean var2) throws RemoteException;

    protected abstract void addExternalServerToCluster(ClusterNode var1, ExternalServerNode var2);

    protected abstract boolean isExternalServerType(Object var1);

    public abstract void clearExternalServers(ClusterNode var1);
}

