/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.site;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.util.BundleKeysInterface;
import java.rmi.RemoteException;
import java.util.Vector;

public class SiteNode
extends VSwitchGroupNode<Site> {
    private String m_alias;

    public SiteNode(Site stub, String alias, Integer groupId) throws RemoteException {
        super(stub, groupId);
        this.setNodeIcon(ClientImageObject.SITE_NODE);
        this.setAlias(alias);
    }

    @Override
    public String type() {
        return "Site";
    }

    @Override
    public String toString() {
        return this.m_alias;
    }

    @Override
    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public ClusterNode[] getSiteClusters() {
        ClusterNode[] children = new ClusterNode[this.getChildCount()];
        for (int i = 0; i < this.getChildCount(); ++i) {
            children[i] = (ClusterNode)this.getChildAt(i);
        }
        return children;
    }

    public boolean containsVSwitches() {
        for (ClusterNode clusterNode : this.getSiteClusters()) {
            if (!clusterNode.hasVSwitch()) continue;
            return true;
        }
        return false;
    }

    public Vector getConsistencyGroupList() {
        return null;
    }

    public Vector getSiteVSwitchGroups() {
        return null;
    }

    public Vector addVSwitchGroup(VSwitchGroupNode vsg) {
        return null;
    }

    public VSwitchGroupNode removeVSwitchGroup(VSwitchGroupNode vsg) {
        return null;
    }

    public void plannedFailOver() {
    }

    public void disasterOccurred() {
    }

    public void fallBack() {
    }

    public boolean inDiscoveryProcess() {
        ClusterNode[] clusters = this.getSiteClusters();
        int clustersLength = clusters.length;
        if (clusters != null && clustersLength > 0) {
            for (int i = 0; i < clustersLength; ++i) {
                if (!clusters[i].isInDiscoveryProcess()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getProblemOnDeletion() {
        return this.inDiscoveryProcess() ? ClientLoader.BUNDLE.getString((BundleKeysInterface)SrClientBundleKeys.CLIENT_GUI_SITE_IN_DISCOVERY, this.m_alias) : super.getProblemOnDeletion();
    }
}

