/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.site;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.VSwitchGroupNode;
import com.sanrad.nms.client.data.dr.DRManager;
import com.sanrad.nms.client.data.dr.DRPairNode;
import com.sanrad.nms.client.data.dr.DRSyncPairNode;
import com.sanrad.nms.client.data.dr.ExtendedElementNode;
import com.sanrad.nms.client.data.dr.SrConsistencyGroupsTableModel;
import com.sanrad.nms.client.data.dr.SrPairDetailsTableModel;
import com.sanrad.nms.client.data.site.SiteNode;
import com.sanrad.nms.client.event.alarm.PropagatedStateEvent;
import com.sanrad.nms.client.event.site.SiteEvent;
import com.sanrad.nms.client.event.site.SiteListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.client.gui.dr.wizards.activation.SrDisasterOccurredWizardFrame;
import com.sanrad.nms.client.gui.dr.wizards.activation.SrFallbackWizardFrame;
import com.sanrad.nms.client.gui.dr.wizards.activation.SrPlannedFailoverWizardFrame;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.swing.wizard.SrWizardFrame;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class SiteManager
extends ElementManager {
    private static SiteManager m_theInstance;
    private static SrLogger theLogger;
    SrEventListenerManager.Informer sitePropertiesChangedInformer = new SrEventListenerManager.Informer<SiteListener, SiteEvent>(){

        @Override
        public void inform(SiteListener listener, SiteEvent event) {
            listener.sitePropertiesChanged(event);
        }
    };
    SrEventListenerManager.Informer siteCreatedInformer = new SrEventListenerManager.Informer<SiteListener, SiteEvent>(){

        @Override
        public void inform(SiteListener listener, SiteEvent event) {
            listener.siteCreated(event);
        }
    };
    SrEventListenerManager.Informer siteRemovedInformer = new SrEventListenerManager.Informer<SiteListener, SiteEvent>(){

        @Override
        public void inform(SiteListener listener, SiteEvent event) {
            listener.siteRemoved(event);
        }
    };

    private SiteManager() {
    }

    public static synchronized SiteManager getInstance() {
        if (m_theInstance == null) {
            m_theInstance = new SiteManager();
        }
        return m_theInstance;
    }

    public SiteNode getSiteByName(String name) {
        return SystemRootNode.getInstance().getSiteNode(name);
    }

    public void addSiteListener(SiteListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeSiteListener(SiteListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void propagatedStateChanged(PropagatedStateEvent e) {
        RemoteObject obj = e.getStub();
        if (obj instanceof Site) {
            theLogger.trace(SrLogCategories.LEGACY, "SiteManager: propagatedStateChanged().");
            SiteNode node = (SiteNode)SystemRootNode.getInstance().getRefByStub(obj);
            if (node != null) {
                SiteEvent event = new SiteEvent((Object)this, node, obj);
                this.fireSiteChanged(event);
            }
        }
    }

    private void fireSiteChanged(SiteEvent event) {
        theLogger.trace(SrLogCategories.LEGACY, "SiteManager: fireSiteChanged().");
        this.m_listeners.fireEvent(SiteListener.class, event, this.sitePropertiesChangedInformer);
    }

    public SrFuture<Void> addSite(String alias, SiteNode parent) {
        theLogger.trace(SrLogCategories.LEGACY, "Try to add site: ", alias);
        return ClientAOImpl.getInstance().createSite((CommKeyClassId)parent.getIdentifier(), alias);
    }

    public SrFuture<Void> addCluster(String alias, SiteNode parent) {
        theLogger.trace(SrLogCategories.LEGACY, "Try to add cluster: ", alias);
        return ClientAOImpl.getInstance().addCluster(alias, (CommKeyClassId)parent.getIdentifier());
    }

    public SrFuture<Void> setAlias(SiteNode siteNode, String newAlias) {
        HashMap<ClientParameterCode, String> params = new HashMap<ClientParameterCode, String>();
        params.put(ClientParameterCode.SITE_ALIAS, newAlias);
        return ClientAOImpl.getInstance().changeElements(Collections.singleton(siteNode.getIdentifier()), params);
    }

    @Override
    protected Object discoverElement() {
        return new UnsupportedOperationException();
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        Site site = (Site)e.getElement();
        SiteNode node = (SiteNode)SystemRootNode.getInstance().getRefByStub(site);
        try {
            node.setAlias(site.getAlias());
            this.fireSiteChanged(new SiteEvent((Object)this, node, e.getElement()));
        }
        catch (RemoteException ex) {
            theLogger.error(SrLogCategories.LEGACY, ex, new Object[0]);
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        try {
            if (element instanceof Site) {
                Site site = (Site)element;
                SiteNode node = new SiteNode(site, site.getAlias(), site.getVSwitchGroupId());
                node.setStatus(SiteManager.getSeverity(site.getPropagatedState()));
                SystemRootNode.getInstance().putRefAndStub(element, node);
                this.fireSiteCreatedEvent(new SiteEvent((Object)this, node, element));
            }
        }
        catch (RemoteException ex) {
            theLogger.error(SrLogCategories.LEGACY, ex, new Object[0]);
        }
    }

    private void fireSiteCreatedEvent(SiteEvent event) {
        this.m_listeners.fireEvent(SiteListener.class, event, this.siteCreatedInformer);
    }

    private void fireSiteRemovedEvent(SiteEvent event) {
        this.m_listeners.fireEvent(SiteListener.class, event, this.siteRemovedInformer);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        SiteNode node;
        RemoteObject element = e.getElement();
        if (element instanceof Site && (node = (SiteNode)SystemRootNode.getInstance().getRefByStub((Site)element)) != null) {
            SiteEvent event = new SiteEvent((Object)this, node, element);
            this.fireSiteRemovedEvent(event);
            SystemRootNode.getInstance().removeRefAndIdByStub(element);
        }
    }

    public SiteNode[] discoverSystemSites() {
        SiteNode[] sites = null;
        try {
            ArrayList list = Communication.getInstance().getSystemRootStub().getVSwitchGroups();
            ArrayList<SiteNode> siteList = new ArrayList<SiteNode>();
            int i = list.size();
            while (i-- > 0) {
                RemoteObject stub = (RemoteObject)list.get(i);
                if (!(stub instanceof Site)) continue;
                Site site = (Site)stub;
                SiteNode node = new SiteNode(site, site.getAlias(), site.getVSwitchGroupId());
                SystemRootNode.getInstance().putRefAndStub(stub, node);
                node.setStatus(SiteManager.getSeverity(site.getPropagatedState()));
                siteList.add(node);
            }
            sites = new SiteNode[siteList.size()];
            siteList.toArray(sites);
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.LEGACY, e, new Object[0]);
        }
        return sites;
    }

    public Vector getAllClusters(String siteAlias) {
        return null;
    }

    public void refreshSite(SiteNode siteNode) {
    }

    public SrFuture<Void> createVSwitch(String ownerVSwitchGruopName, String ip, String mask, int snmpPort, int trapPort, String readCommunity, String writeCommunity, int timeout, int retries, String aRaidName, String aRaidFirstIp, String aRaidSecondIp, VSwitchGroupNode<?> parent) {
        theLogger.trace(SrLogCategories.LEGACY, "Try to add vSwitch: ", ip);
        return ClientAOImpl.getInstance().addVSwitch((CommKeyClassId)parent.getIdentifier(), ownerVSwitchGruopName, ip, mask, snmpPort, trapPort, readCommunity, writeCommunity, timeout, retries, SnmpVersion.V2C);
    }

    public void disasterOccurred(SrTreeNode[] drElements, JFrame owner) {
        if (SrWizardFrame.isAlreadyRunningWizard(SrDisasterOccurredWizardFrame.class)) {
            SrWizardFrame.bringToFront(SrDisasterOccurredWizardFrame.class);
            return;
        }
        SrDisasterOccurredWizardFrame frm = new SrDisasterOccurredWizardFrame(owner, drElements);
        frm.runWizard();
    }

    public void fallback(SrTreeNode[] drElements, JFrame owner) {
        if (SrWizardFrame.isAlreadyRunningWizard(SrFallbackWizardFrame.class)) {
            SrWizardFrame.bringToFront(SrFallbackWizardFrame.class);
            return;
        }
        SrFallbackWizardFrame frm = new SrFallbackWizardFrame(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_FALLBACK_WIZ_TITLE), drElements);
        frm.runWizard();
    }

    public void plannedFailover(SrTreeNode[] drElements, JFrame owner) {
        if (SrWizardFrame.isAlreadyRunningWizard(SrPlannedFailoverWizardFrame.class)) {
            SrWizardFrame.bringToFront(SrPlannedFailoverWizardFrame.class);
            return;
        }
        SrPlannedFailoverWizardFrame frm = new SrPlannedFailoverWizardFrame(owner, ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_DR_PLANNED_FAILOVER_WIZ_TITLE), drElements);
        frm.runWizard();
    }

    public SrFuture<Void> abortReplication(SiteNode siteNode) {
        SrFuture<Void> retVal = ClientAOImpl.getInstance().abortReplicate(Collections.singleton(siteNode.getIdentifier()));
        DRPairNode[] secondaryPairs = SrPairDetailsTableModel.getInstance().getPairsSecondaryOnSite(siteNode);
        ExtendedElementNode[] secondaryCGs = SrConsistencyGroupsTableModel.getInstance().getNodesSecondaryOnSite(siteNode);
        DRPairNode[] primaryPairs = SrPairDetailsTableModel.getInstance().getPairsPrimaryOnSite(siteNode);
        List<ExtendedElementNode> primaryCGs = SrConsistencyGroupsTableModel.getInstance().getAllGroupsPrimaryOnSite(siteNode);
        int i = primaryPairs.length;
        while (i-- > 0) {
            if (!(primaryPairs[i] instanceof DRSyncPairNode) || !primaryPairs[i].getMode().equals(DRModeConstant.NORMAL)) continue;
            DRManager.getInstance().abortReplicationRequestNotify(primaryPairs[i]);
        }
        for (ExtendedElementNode cg : primaryCGs) {
            if (!cg.getMode().equals(DRModeConstant.NORMAL)) continue;
            DRManager.getInstance().abortReplicationRequestNotify(cg);
        }
        i = secondaryPairs.length;
        while (i-- > 0) {
            if (!(secondaryPairs[i] instanceof DRSyncPairNode) || !secondaryPairs[i].getMode().equals(DRModeConstant.SWITCHED)) continue;
            DRManager.getInstance().abortReplicationRequestNotify(secondaryPairs[i]);
        }
        i = secondaryCGs.length;
        while (i-- > 0) {
            if (!secondaryCGs[i].getMode().equals(DRModeConstant.SWITCHED)) continue;
            DRManager.getInstance().abortReplicationRequestNotify(secondaryCGs[i]);
        }
        return retVal;
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

