/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.scsi;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.scsi.SrDeviceNode;
import com.sanrad.nms.client.data.vswitch.TableRowNode;
import com.sanrad.nms.server.logic.iscsi.ISCSIDevice;
import com.sanrad.nms.server.logic.scsi.SCSIPort;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;

public class SrSCSIPortNode<T extends SCSIPort>
extends TableRowNode<T> {
    private ISCSIDevice m_deviceStub;
    private HashMap m_values;
    private String m_name;
    private BigInteger m_readMBs;
    private BigInteger m_writtenMBs;

    public SrSCSIPortNode(T stub, VSwitch parentStub, ISCSIDevice deviceStub) throws RemoteException {
        super(stub, parentStub);
        this.m_deviceStub = deviceStub;
    }

    @Override
    public String type() {
        return "SCSI Port: " + this.m_name;
    }

    public ISCSIDevice getDeviceStub() {
        return this.m_deviceStub;
    }

    @Override
    public String toString() {
        return this.m_name;
    }

    public void setChangedValues(HashMap values) {
        this.m_values = values;
    }

    public HashMap getChangedValues() {
        return this.m_values;
    }

    public SrDeviceNode getDeviceNode() {
        ISCSIDevice stub = this.getDeviceStub();
        SrDeviceNode node = (SrDeviceNode)SystemRootNode.getInstance().getRefByStub(stub);
        return node;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setReadMBs(BigInteger readMBs) {
        this.m_readMBs = readMBs;
    }

    public BigInteger getReadMBs() {
        return this.m_readMBs;
    }

    public void setWrittenMBs(BigInteger writtenMBs) {
        this.m_writtenMBs = writtenMBs;
    }

    public BigInteger getWrittenMBs() {
        return this.m_writtenMBs;
    }
}

