/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.scsi;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.scsi.SrSCSIPortNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import java.util.ArrayList;

public class SrDeviceNode<T extends RemoteObject, I>
extends SrTreeNode<T, I> {
    protected String m_alias;
    protected String m_name;
    protected ArrayList m_scsiPorts;
    protected ArrayList m_iscsiSessions;

    public SrDeviceNode(T stub, I id) {
        super(stub, id);
    }

    public SrDeviceNode(T stub, I id, String alias, ClientImageObject icon) {
        this(stub, id);
        this.m_alias = alias;
        this.setNodeIcon(icon);
        this.m_scsiPorts = new ArrayList();
        this.m_iscsiSessions = new ArrayList();
    }

    @Override
    public String type() {
        StringBuffer sb = new StringBuffer("Device ");
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.m_alias != null ? this.m_alias : "";
    }

    public void setAlias(String alias) {
        if (alias != null && !alias.equals("")) {
            this.m_alias = alias;
        }
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setISCSISessions(ISCSISession[] iscsiSessions) {
        ArrayList<ISCSISessionNode> sessions = new ArrayList<ISCSISessionNode>();
        for (int index = 0; index < iscsiSessions.length; ++index) {
            ISCSISessionNode sessionNode = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(iscsiSessions[index]);
            sessions.add(sessionNode);
        }
        this.setISCSISessions(sessions);
    }

    public void setISCSISessions(ArrayList iscsiSessions) {
        this.m_iscsiSessions.clear();
        this.m_iscsiSessions.addAll(iscsiSessions);
    }

    public ArrayList getISCSISessions() {
        return this.m_iscsiSessions;
    }

    public void addISCSISession(ISCSISessionNode sessionNode) {
        if (!this.m_iscsiSessions.contains(sessionNode)) {
            this.m_iscsiSessions.add(sessionNode);
        }
    }

    public void removeISCSISession(ISCSISessionNode sessionNode) {
        this.m_iscsiSessions.remove(sessionNode);
    }

    public Integer getNumberOfPorts() {
        return new Integer(this.m_scsiPorts.size());
    }

    public void setSCSIPorts(ArrayList ports) {
        this.m_scsiPorts = ports;
    }

    public SrSCSIPortNode[] getSCSIPorts() {
        SrSCSIPortNode[] array = new SrSCSIPortNode[this.m_scsiPorts.size()];
        return this.m_scsiPorts.toArray(array);
    }

    public void addSCSIPort(SrSCSIPortNode portNode) {
        if (!this.m_scsiPorts.contains(portNode)) {
            this.m_scsiPorts.add(portNode);
        }
    }

    public void removeSCSIPort(SrSCSIPortNode portNode) {
        this.m_scsiPorts.remove(portNode);
    }

    public void removeSCSIPorts() {
        for (int index = 0; index < this.m_scsiPorts.size(); ++index) {
            SrSCSIPortNode portNode = (SrSCSIPortNode)this.m_scsiPorts.get(index);
            SystemRootNode.getInstance().removeRefAndIdByStub((RemoteObject)portNode.getStub());
            this.removeSCSIPort(portNode);
        }
    }
}

