/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.raid;

import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;

public class UnmanagedRaidSystem
extends RaidSystem {
    private String myDisplayName;

    public UnmanagedRaidSystem(DirectAccessDeviceNode aDisk, RaidSystem.Type aType) {
        super(aDisk, aType);
        this.myDisplayName = aDisk.getVendor();
        this.addDisk(aDisk);
    }

    public UnmanagedRaidSystem(DirectAccessDeviceNode aDisk) {
        this(aDisk, RaidSystem.Type.GENERAL_UNMANAGED_RAID);
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UnmanagedRaidSystem)) {
            return false;
        }
        return this.getWWN().equals(((UnmanagedRaidSystem)other).getWWN()) && this.getDisplayName().equals(((UnmanagedRaidSystem)other).getDisplayName());
    }

    public String toString() {
        return "[Unmanaged Raid]: " + this.getWWN();
    }

    @Override
    public boolean isStatusOK() {
        return !this.hasDisksWhichAreNotOK();
    }

    @Override
    public String getFullDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDisplayName()).append(':');
        SrEntityNameFormat wwn = this.getWWN();
        if (this.isIscsiRaid()) {
            if (wwn != null) {
                sb.append(new String(wwn.getBytes()));
            }
        } else {
            sb.append(wwn);
        }
        return sb.toString();
    }
}

