/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.raid;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.RaidNode;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RaidSystem {
    protected static final SrLogger theLogger = SrLogger.getLogger();
    private String myName;
    protected List<ClusterNode> myClusters = new ArrayList<ClusterNode>();
    protected Map<ClusterNode, RaidNode> myClusterToRaidNodeMap = new HashMap<ClusterNode, RaidNode>();
    private String myCtrlIp1;
    private String myCtrlIp2;
    protected List<DirectAccessDeviceNode> myDisks = new ArrayList<DirectAccessDeviceNode>();
    private Type myType = null;
    SrEntityNameFormat myWWN = null;

    public RaidSystem(DirectAccessDeviceNode aDisk, Type aType) {
        this.myType = aType;
        this.myWWN = aDisk.getEntityNameFormat();
        this.setName(aDisk.getRaidSysName());
        this.addCluster(SystemRootNode.getInstance().getClusterNodeOfSource(aDisk));
    }

    public void addCluster(ClusterNode aCluster) {
        if (aCluster == null) {
            return;
        }
        if (!this.myClusters.contains(aCluster)) {
            this.myClusters.add(aCluster);
        }
    }

    public boolean removeCluster(ClusterNode aCluster) {
        this.myClusterToRaidNodeMap.remove(aCluster);
        return this.myClusters.remove(aCluster);
    }

    public abstract boolean equals(Object var1);

    void reactToDiskStatusChange(DirectAccessDeviceNode aDiskChanged) {
        if (!this.myDisks.contains(aDiskChanged)) {
            return;
        }
        this.updateRaidNodesOfStatusChange();
    }

    protected void updateRaidNodesOfStatusChange() {
        for (RaidNode raidNode : this.myClusterToRaidNodeMap.values()) {
            raidNode.setIconByStatus(this.isStatusOK());
        }
    }

    protected boolean hasDisksWhichAreNotOK() {
        for (DirectAccessDeviceNode disk : this.getDisks()) {
            if (!PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_INVALID.equals(disk.getStorageOperStatus()) && !PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_MISSING.equals(disk.getStorageOperStatus())) continue;
            return true;
        }
        return false;
    }

    boolean addDisk(DirectAccessDeviceNode aDisk) {
        boolean retVal = false;
        if (aDisk == null) {
            return false;
        }
        if (!this.myDisks.contains(aDisk)) {
            retVal = this.myDisks.add(aDisk);
            this.updateRaidNodesOfStatusChange();
        }
        return retVal;
    }

    public Type getType() {
        return this.myType;
    }

    void removeDisk(DirectAccessDeviceNode aDisk) {
        if (aDisk == null) {
            return;
        }
        this.myDisks.remove(aDisk);
        this.updateRaidNodesOfStatusChange();
    }

    public List<DirectAccessDeviceNode> getDisks() {
        return new ArrayList<DirectAccessDeviceNode>(this.myDisks);
    }

    public List<ClusterNode> getClusters() {
        return new ArrayList<ClusterNode>(this.myClusters);
    }

    public abstract String getDisplayName();

    public String getName() {
        return this.myName;
    }

    protected void setName(String aName) {
        this.myName = aName;
    }

    public String getCtrlIp1() {
        return this.myCtrlIp1;
    }

    protected void setCtrlIp1(String aCtrlIp1) {
        this.myCtrlIp1 = aCtrlIp1;
    }

    public String getCtrlIp2() {
        return this.myCtrlIp2;
    }

    protected void setCtrlIp2(String aCtrlIp2) {
        this.myCtrlIp2 = aCtrlIp2;
    }

    void addRaidNode(ClusterNode aCluster, RaidNode aRaidNode) {
        if (!this.myClusters.contains(aCluster)) {
            throw new IllegalArgumentException("The given cluster " + aCluster + " was not added to the RAIDSystem " + this + " using the method Raidsystem.addCluster");
        }
        if (!this.myClusterToRaidNodeMap.values().contains(aRaidNode)) {
            this.myClusterToRaidNodeMap.put(aCluster, aRaidNode);
        }
    }

    public RaidNode getRaidNode(ClusterNode aCluster) {
        return this.myClusterToRaidNodeMap.get(aCluster);
    }

    RaidNode removeRaidNode(ClusterNode aCluster) {
        RaidNode raidNodeToRemove = this.myClusterToRaidNodeMap.remove(aCluster);
        return raidNodeToRemove;
    }

    public boolean isManaged() {
        return Type.GENERAL_MANAGED_RAID.equals((Object)this.getType()) || Type.NEXSAN_MANAGED_RAID.equals((Object)this.getType());
    }

    public abstract boolean isStatusOK();

    public SrEntityNameFormat getWWN() {
        return this.myWWN;
    }

    protected void setWWN(SrEntityNameFormat aWWN) {
        this.myWWN = aWWN;
    }

    public String getFirmwareRevision() {
        return this.myDisks.get(0).getRevisionLevel();
    }

    public boolean isIscsiRaid() {
        for (DirectAccessDeviceNode disk : this.getDisks()) {
            if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.toString().equals(disk.getTransportType())) continue;
            return false;
        }
        return true;
    }

    public abstract String getFullDescription();

    public static enum Type {
        NEXSAN_MANAGED_RAID,
        GENERAL_MANAGED_RAID,
        GENERAL_UNMANAGED_RAID,
        GDR_UNMANAGED_RAID;

    }
}

