/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.raid;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.gui.ClientImageObject;

public abstract class RaidNode
extends SrTreeNode {
    protected RaidSystem myRaid = null;

    public RaidNode(RaidSystem aRaid) {
        if (aRaid == null) {
            throw new IllegalArgumentException("The RaidSystem should not be null");
        }
        this.myRaid = aRaid;
        this.setIconByStatus(aRaid.isStatusOK());
    }

    @Override
    public String type() {
        return "RAID";
    }

    public RaidSystem getRaid() {
        return this.myRaid;
    }

    public RaidSystem.Type getType() {
        return this.myRaid.getType();
    }

    public void setIconByStatus(boolean aIsStatusOK) {
        if (!aIsStatusOK) {
            this.setNodeIcon(ClientImageObject.STORAGE_ERROR);
            return;
        }
        this.setNodeIcon(ClientImageObject.STORAGE_OK);
    }

    @Override
    public String toString() {
        return this.myRaid.getFullDescription();
    }
}

