/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.raid;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.GdrUnmanagedRaidNode;
import com.sanrad.nms.client.data.raid.GdrUnmanagedRaidSystem;
import com.sanrad.nms.client.data.raid.ManagedRaidNode;
import com.sanrad.nms.client.data.raid.ManagedRaidSystem;
import com.sanrad.nms.client.data.raid.NexsanManagedRaidNode;
import com.sanrad.nms.client.data.raid.NexsanManagedRaidSystem;
import com.sanrad.nms.client.data.raid.RaidNode;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.raid.UnmanagedRaidNode;
import com.sanrad.nms.client.data.raid.UnmanagedRaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.client.data.storage.StorageManager;
import com.sanrad.nms.client.event.raid.RaidEvent;
import com.sanrad.nms.client.event.raid.RaidEventFactory;
import com.sanrad.nms.client.event.raid.RaidManagerListener;
import com.sanrad.nms.client.gui.SrClientBundleKeys;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.util.Util;
import java.util.ArrayList;
import java.util.List;

public class RaidManager {
    private static RaidManager myInstance = new RaidManager();
    private static final SrLogger theLogger = SrLogger.getLogger();
    private List<RaidSystem> myRaids = new ArrayList<RaidSystem>();
    private List<RaidManagerListener> myListeners = new ArrayList<RaidManagerListener>();
    private static final String NEXSAN_VENDOR = ClientLoader.BUNDLE.getString(SrClientBundleKeys.CLIENT_GUI_RAID_NEXSAN_VENDOR);

    private RaidManager() {
    }

    public static RaidManager getInstance() {
        return myInstance;
    }

    public void addListener(RaidManagerListener aListener) {
        if (this.myListeners.contains(aListener)) {
            return;
        }
        this.myListeners.add(aListener);
    }

    public void removeListener(RaidManagerListener aListener) {
        this.myListeners.remove(aListener);
    }

    void notifyListenersOfNewEvent(RaidEvent aEvent) {
        ArrayList<RaidManagerListener> listenList = new ArrayList<RaidManagerListener>(this.myListeners);
        for (RaidManagerListener listener : listenList) {
            switch (aEvent.getType()) {
                case RAID_CREATED: {
                    listener.RaidCreated(aEvent);
                    break;
                }
                case RAID_REMOVED: {
                    listener.RaidRemoved(aEvent);
                    break;
                }
                case RAID_ATTACHED: {
                    listener.RaidAttached(aEvent);
                    break;
                }
                case RAID_DETACHED: {
                    listener.RaidDetached(aEvent);
                    break;
                }
                case RAID_CHANGED: {
                    listener.RaidChanged(aEvent);
                }
            }
        }
    }

    public List<RaidSystem> getRaids() {
        return new ArrayList<RaidSystem>(this.myRaids);
    }

    public List<RaidSystem> getRaids(ClusterNode aCluster) {
        ArrayList<RaidSystem> retRaids = new ArrayList<RaidSystem>(this.myRaids);
        for (RaidSystem curRaid : this.myRaids) {
            if (curRaid.getClusters().contains(aCluster)) continue;
            retRaids.remove(curRaid);
        }
        return retRaids;
    }

    public RaidSystem getRaid(String aIpOrWWN) {
        if (aIpOrWWN != null) {
            for (RaidSystem curRaid : this.myRaids) {
                if (!aIpOrWWN.equals(curRaid.getCtrlIp1()) && !aIpOrWWN.equals(curRaid.getCtrlIp2()) && !aIpOrWWN.equals(curRaid.getWWN())) continue;
                return curRaid;
            }
        }
        return null;
    }

    private void removeRaidNodes(RaidSystem aRaid) {
        List<ClusterNode> clusters = aRaid.getClusters();
        if (clusters == null) {
            return;
        }
        for (ClusterNode cluster : clusters) {
            RaidNode raidNodeRemoved = aRaid.removeRaidNode(cluster);
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForRaidNodeRemoved(this, aRaid, raidNodeRemoved, cluster));
        }
    }

    private void setNodesForRaid(RaidSystem aRaidSys) {
        List<ClusterNode> clusters = aRaidSys.getClusters();
        for (ClusterNode cluster : clusters) {
            RaidNode raidNode = aRaidSys.getRaidNode(cluster);
            if (raidNode != null) continue;
            RaidSystem.Type raidType = aRaidSys.getType();
            switch (raidType) {
                case NEXSAN_MANAGED_RAID: {
                    raidNode = new NexsanManagedRaidNode((NexsanManagedRaidSystem)aRaidSys);
                    break;
                }
                case GENERAL_MANAGED_RAID: {
                    raidNode = new ManagedRaidNode((ManagedRaidSystem)aRaidSys);
                    break;
                }
                case GENERAL_UNMANAGED_RAID: {
                    raidNode = new UnmanagedRaidNode((UnmanagedRaidSystem)aRaidSys);
                    break;
                }
                case GDR_UNMANAGED_RAID: {
                    raidNode = new GdrUnmanagedRaidNode((GdrUnmanagedRaidSystem)aRaidSys);
                    break;
                }
                default: {
                    throw new IllegalStateException("Raid = " + aRaidSys + " for cluster " + cluster + " has Invalid Type: " + (Object)((Object)raidType));
                }
            }
            aRaidSys.addRaidNode(cluster, raidNode);
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForRaidNodeAdded(this, aRaidSys, raidNode, cluster));
        }
    }

    private RaidSystem setRaidFromDisk(DirectAccessDeviceNode aNewDisk) {
        RaidSystem newRaidSys = this.createAppropriateRaidForDisk(aNewDisk);
        if (!this.addRaid(newRaidSys)) {
            RaidSystem retRaid = this.getRaidFromContainer(newRaidSys);
            if (!retRaid.addDisk(aNewDisk)) {
                return retRaid;
            }
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForDiskAdded(this, retRaid, aNewDisk));
            ClusterNode clusterDisk = SystemRootNode.getInstance().getClusterNodeOfSource(aNewDisk);
            if (!retRaid.getClusters().contains(clusterDisk)) {
                retRaid.addCluster(clusterDisk);
                this.setNodesForRaid(retRaid);
            }
            return retRaid;
        }
        this.setNodesForRaid(newRaidSys);
        return newRaidSys;
    }

    public boolean addRaid(RaidSystem aRaid) {
        if (aRaid == null) {
            return false;
        }
        if (!this.isExists(aRaid)) {
            this.myRaids.add(aRaid);
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForRaidCreation(this, aRaid));
            return true;
        }
        return false;
    }

    private void removeRaid(RaidSystem aRaid) {
        if (this.myRaids.remove(aRaid)) {
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForRaidRemoval(this, aRaid));
        }
    }

    public boolean isExists(RaidSystem aRaid) {
        return this.myRaids.contains(aRaid);
    }

    private RaidSystem getRaidFromContainer(RaidSystem aRaid) {
        int indexOfExistsRaid = this.myRaids.indexOf(aRaid);
        if (indexOfExistsRaid > -1) {
            return this.myRaids.get(indexOfExistsRaid);
        }
        return null;
    }

    RaidSystem getRaidByDisk(DirectAccessDeviceNode aDisk) {
        for (RaidSystem raid : this.myRaids) {
            if (!raid.getDisks().contains(aDisk)) continue;
            return raid;
        }
        return null;
    }

    public String toString() {
        return "Raids: " + this.myRaids;
    }

    private RaidSystem createAppropriateRaidForDisk(DirectAccessDeviceNode aNewDisk) {
        if (StorageManager.getInstance().isStorageNodeUsedByAPair(aNewDisk)) {
            return new GdrUnmanagedRaidSystem(aNewDisk);
        }
        PhysicalStorageRaidLevelConstant raidLevel = aNewDisk.getRaidLevel();
        if (raidLevel == null || PhysicalStorageRaidLevelConstant.NO_RAID.equals(raidLevel)) {
            return new UnmanagedRaidSystem(aNewDisk);
        }
        if (NEXSAN_VENDOR.equals(aNewDisk.getVendor())) {
            return new NexsanManagedRaidSystem(aNewDisk);
        }
        return new ManagedRaidSystem(aNewDisk);
    }

    public void reactToDiskCreated(DirectAccessDeviceNode aNewDisk) {
        if (aNewDisk == null) {
            return;
        }
        this.setRaidFromDisk(aNewDisk);
    }

    public void reactToDiskRemoved(DirectAccessDeviceNode aDisk) {
        if (aDisk == null) {
            return;
        }
        RaidSystem raid = this.getRaidByDisk(aDisk);
        if (raid == null) {
            return;
        }
        raid.removeDisk(aDisk);
        this.notifyListenersOfNewEvent(RaidEventFactory.createEventForDiskRemoved(this, raid, aDisk));
        if (raid.getDisks().isEmpty()) {
            this.removeRaid(raid);
            this.removeRaidNodes(raid);
        }
    }

    public void reactToClusterRemoved(ClusterNode aCluster) {
        List<RaidSystem> currentRaids = this.getRaids();
        for (RaidSystem raid : currentRaids) {
            if (!raid.removeCluster(aCluster)) continue;
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForClusterRemoved(this, raid, aCluster));
            if (!raid.getClusters().isEmpty()) continue;
            this.removeRaid(raid);
        }
    }

    public void reactToClusterDiscoveryStarted(ClusterNode aCluster) {
        List<RaidSystem> currentRaids = this.getRaids();
        for (RaidSystem raid : currentRaids) {
            RaidNode node = raid.getRaidNode(aCluster);
            if (!raid.removeCluster(aCluster)) continue;
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForClusterDiscovery(this, raid, aCluster, node));
            if (!raid.getClusters().isEmpty()) continue;
            this.removeRaid(raid);
        }
    }

    public void reactToDiskChanged(DirectAccessDeviceNode aDisk) {
        RaidSystem raidSys = this.getRaidByDisk(aDisk);
        if (raidSys == null) {
            return;
        }
        RaidSystem newRaidSys = this.setRaidFromDisk(aDisk);
        if (!newRaidSys.equals(raidSys)) {
            raidSys.removeDisk(aDisk);
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForDiskRemoved(this, raidSys, aDisk));
            if (raidSys.getDisks().isEmpty()) {
                this.removeRaid(raidSys);
                this.removeRaidNodes(raidSys);
            }
        }
        raidSys.updateRaidNodesOfStatusChange();
        if (raidSys.isManaged() && ((ManagedRaidSystem)raidSys).updateRaidSysNameByDisks()) {
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForRaidNameChanged(this, raidSys));
        }
        this.notifyListenersOfNewEvent(RaidEventFactory.createEventForDiskStatusChanged(this, raidSys, aDisk));
        this.notifyListenersOfNewEvent(RaidEventFactory.createEventForRaidStatusChanged(this, raidSys));
    }

    public void reactToRaidAttachedOrDetached(String aRaidWWN, boolean aIsAttachedOperation) {
        RaidSystem raidSys = this.getRaid(aRaidWWN);
        if (raidSys == null) {
            return;
        }
        if (aIsAttachedOperation) {
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForRaidAttached(this, raidSys));
        } else {
            this.notifyListenersOfNewEvent(RaidEventFactory.createEventForRaidDetached(this, raidSys));
        }
    }

    public void reactToDRPairEvents() {
        boolean replaceDisk = false;
        for (RaidSystem raidSys : this.getRaids()) {
            for (DirectAccessDeviceNode disk : raidSys.getDisks()) {
                replaceDisk = false;
                if (StorageManager.getInstance().isStorageNodeUsedByAPair(disk)) {
                    if (!RaidSystem.Type.GDR_UNMANAGED_RAID.equals((Object)raidSys.getType())) {
                        replaceDisk = true;
                    }
                } else if (RaidSystem.Type.GDR_UNMANAGED_RAID.equals((Object)raidSys.getType())) {
                    replaceDisk = true;
                }
                if (!replaceDisk) continue;
                this.reactToDiskRemoved(disk);
                this.reactToDiskCreated(disk);
            }
        }
    }

    RaidSystem findRaid(ClusterNode aCluster, SrEntityNameFormat aRaidWwn, String aCtrlIp1, String aCtrlIp2) {
        Util.validateInputNotNull(aCluster, "Cluster node");
        List<RaidSystem> clusterRaids = this.getRaids(aCluster);
        List<String> ips = Util.convertToList(aCtrlIp1, aCtrlIp2);
        for (RaidSystem raidSys : clusterRaids) {
            List<String> raidSysIps = Util.convertToList(raidSys.getCtrlIp1(), raidSys.getCtrlIp2());
            if (!Util.equalsWithNull(raidSys.getWWN(), aRaidWwn)) continue;
            return raidSys;
        }
        return null;
    }
}

