/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.raid;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.storage.DirectAccessDeviceNode;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidLevelConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageRaidStatusConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class ManagedRaidSystem
extends RaidSystem {
    private String myModelName;
    private String myFirmwareRevision;
    private PhysicalStorageRaidLevelConstant myLevel;
    private SrBITSConstant myStatus;
    private BigInteger myCreationTime;

    protected ManagedRaidSystem(DirectAccessDeviceNode aDisk, RaidSystem.Type aType) {
        super(aDisk, aType);
        String ip1Str = aDisk.getRaidUrlCtrl1();
        String ip2Str = aDisk.getRaidUrlCtrl2();
        String ip1 = this.extractIp(ip1Str);
        String ip2 = this.extractIp(ip2Str);
        if (ip1 != null && !ip1.isEmpty()) {
            this.setCtrlIp1(ip1);
        }
        if (ip2 != null && !ip2.isEmpty()) {
            this.setCtrlIp2(ip2);
        }
        this.setFirmwareRevision(aDisk.getRaidFirmwareRevision());
        this.setModelName(aDisk.getRaidSysModelName());
        this.setLevel(aDisk.getRaidLevel());
        this.setStatus(aDisk.getRaidStatus());
        this.setCreationTime(aDisk.getRaidCreationTime());
        this.addDisk(aDisk);
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    private String extractIp(String aIpOrUrl) {
        if (aIpOrUrl != null && !aIpOrUrl.isEmpty()) {
            if (SrString.isUrl(aIpOrUrl)) {
                try {
                    return new SrIpAddress(new URL(aIpOrUrl)).toString();
                }
                catch (MalformedURLException e) {
                    theLogger.error(SrLogCategories.EXCEPTION, e, "Should not be here, Ip2 = " + aIpOrUrl + " checked to be URL but failed in creating URL object");
                }
            } else {
                return new SrIpAddress(aIpOrUrl).toString();
            }
        }
        return null;
    }

    public ManagedRaidSystem(DirectAccessDeviceNode aDisk) {
        this(aDisk, RaidSystem.Type.GENERAL_MANAGED_RAID);
    }

    protected void setModelName(String aModelName) {
        this.myModelName = aModelName;
    }

    public String getModelName() {
        return this.myModelName;
    }

    protected void setFirmwareRevision(String aFwRevision) {
        this.myFirmwareRevision = aFwRevision;
    }

    @Override
    public String getFirmwareRevision() {
        return super.getFirmwareRevision();
    }

    protected void setStatus(SrBITSConstant aStatus) {
        this.myStatus = aStatus;
        this.updateRaidNodesOfStatusChange();
    }

    public SrBITSConstant getStatus() {
        return this.myStatus;
    }

    public PhysicalStorageRaidLevelConstant getLevel() {
        return this.myLevel;
    }

    protected void setLevel(PhysicalStorageRaidLevelConstant aLevel) {
        this.myLevel = aLevel;
    }

    public void setCreationTime(BigInteger aCreationTime) {
        this.myCreationTime = aCreationTime;
    }

    public BigInteger getCreationTime() {
        return this.myCreationTime;
    }

    public String toString() {
        return "[ManagedRaidSystem]: {" + this.getDisplayName() + " / " + Util.convertToList(this.getCtrlIp1(), this.getCtrlIp2()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ManagedRaidSystem)) {
            return false;
        }
        ManagedRaidSystem other = (ManagedRaidSystem)o;
        List<String> ips = Util.convertToList(this.getCtrlIp1(), this.getCtrlIp2());
        List<String> otherIps = Util.convertToList(other.getCtrlIp1(), other.getCtrlIp2());
        return Util.equalsListNotOrdered(ips, otherIps);
    }

    @Override
    public void reactToDiskStatusChange(DirectAccessDeviceNode aDiskChanged) {
        super.reactToDiskStatusChange(aDiskChanged);
        this.reactToRaidStatusChanged(aDiskChanged);
    }

    public void reactToRaidStatusChanged(DirectAccessDeviceNode aDiskContainsRaidStatus) {
        SrBITSConstant newStatus = aDiskContainsRaidStatus.getRaidStatus();
        if (!this.getStatus().equals(newStatus)) {
            this.setStatus(newStatus);
        }
    }

    @Override
    public boolean isStatusOK() {
        return !this.hasDisksWhichAreNotOK() && !this.getStatus().contains(PhysicalStorageRaidStatusConstant.PHYS_STOR_RAID_STATUS_SYSTEM_FAULT);
    }

    @Override
    public String getFullDescription() {
        return ((DirectAccessDeviceNode)this.myDisks.get(0)).getVendor() + ":" + this.getDisplayName();
    }

    protected boolean updateRaidSysNameByDisks() {
        if (!this.myDisks.isEmpty()) {
            String raidName = ((DirectAccessDeviceNode)this.myDisks.get(0)).getRaidSysName();
            boolean isSameRaidNameInAll = true;
            for (DirectAccessDeviceNode disk : this.myDisks) {
                if (Util.equalsWithNull(raidName, disk.getRaidSysName())) continue;
                isSameRaidNameInAll = false;
                break;
            }
            if (isSameRaidNameInAll && !Util.equalsWithNull(raidName, this.getName())) {
                this.setName(raidName);
                return true;
            }
        }
        return false;
    }
}

