/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.raid;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.raid.AttachedRaidNode;
import com.sanrad.nms.client.data.raid.RaidManager;
import com.sanrad.nms.client.data.raid.RaidSystem;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.raid.RaidEvent;
import com.sanrad.nms.client.event.raid.RaidEventFactory;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.raid.AttachedRaid;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.util.Util;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AttachedRaidManager
extends ElementManager {
    private static final AttachedRaidManager theInstance = new AttachedRaidManager();
    private static SrLogger theLogger = SrLogger.getLogger();
    private HashMap<ClusterNode, ArrayList<AttachedRaidNode>> myClusterToRaidsMap = new HashMap();

    public static AttachedRaidManager getInstance() {
        return theInstance;
    }

    private AttachedRaidManager() {
    }

    private boolean isAttachedRaidExists(ClusterNode aCluster, AttachedRaidNode raid) {
        Util.validateInputNotNull(aCluster, "Cluster Node");
        List<AttachedRaidNode> raids = this.getAttachedRaids(aCluster);
        return raids.contains(raid);
    }

    private void addAttachedRaid(ClusterNode aCluster, AttachedRaidNode aAttachedRaidNode) {
        Util.validateInputNotNull(aCluster, "Cluster node");
        Util.validateInputNotNull(aAttachedRaidNode, "Attached Raid Node");
        if (this.isAttachedRaidExists(aCluster, aAttachedRaidNode)) {
            throw new IllegalArgumentException("Attached RAID " + aAttachedRaidNode + " already exists in cluster " + aCluster);
        }
        ArrayList<AttachedRaidNode> raids = this.myClusterToRaidsMap.get(aCluster);
        if (raids == null) {
            raids = new ArrayList();
            this.myClusterToRaidsMap.put(aCluster, raids);
        }
        SystemRootNode.getInstance().putRefAndStub((RemoteObject)aAttachedRaidNode.getStub(), aAttachedRaidNode);
        raids.add(aAttachedRaidNode);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        AttachedRaid attahcedRaidStub = (AttachedRaid)e.getElement();
        AttachedRaidNode attachedRaidNode = (AttachedRaidNode)SystemRootNode.getInstance().getRefByStub(attahcedRaidStub);
        theLogger.trace(SrLogCategories.INFORMATIVE, "AttachedRaidManager: attached RAID removed - ", attachedRaidNode);
        if (attachedRaidNode == null) {
            return;
        }
        ClusterNode cluster = this.getAttachedRaidCluster(attachedRaidNode);
        this.removeAttachedRaid(attachedRaidNode);
        this.fireAttachedRaidRemoved(attachedRaidNode, cluster);
    }

    private void removeAttachedRaid(AttachedRaidNode aAttachedRaid) {
        Util.validateInputNotNull(aAttachedRaid, "Attached RAID");
        SystemRootNode.getInstance().removeRefAndIdByStub((RemoteObject)aAttachedRaid.getStub());
        Manager.removeStubAndId(aAttachedRaid);
        for (ClusterNode cluster : this.myClusterToRaidsMap.keySet()) {
            ArrayList<AttachedRaidNode> attachedRaids = this.myClusterToRaidsMap.get(cluster);
            if (attachedRaids == null) {
                throw new IllegalStateException("The cluster " + cluster + " does not have a list of RAIDs as a value in the map: " + this.myClusterToRaidsMap);
            }
            boolean isRemoved = attachedRaids.remove(aAttachedRaid);
            if (!isRemoved) continue;
            if (attachedRaids.isEmpty()) {
                this.myClusterToRaidsMap.remove(cluster);
            }
            return;
        }
    }

    private ClusterNode getAttachedRaidCluster(AttachedRaidNode aAttachedRaidNode) {
        Util.validateInputNotNull(aAttachedRaidNode, "Attached RAID Node");
        for (ClusterNode cluster : this.myClusterToRaidsMap.keySet()) {
            ArrayList<AttachedRaidNode> raids = this.myClusterToRaidsMap.get(cluster);
            if (raids == null) {
                throw new IllegalStateException("The mapping contains null for cluster: " + cluster);
            }
            if (!raids.contains(aAttachedRaidNode)) continue;
            return cluster;
        }
        return null;
    }

    public List<AttachedRaidNode> getAttachedRaids(ClusterNode aCluster) {
        Util.validateInputNotNull(aCluster, "Cluster Node");
        ArrayList<AttachedRaidNode> retRaids = new ArrayList<AttachedRaidNode>();
        ArrayList<AttachedRaidNode> raids = this.myClusterToRaidsMap.get(aCluster);
        if (raids != null) {
            retRaids.addAll(raids);
        }
        return retRaids;
    }

    public List<AttachedRaidNode> getAttachedRaids(VSwitchNode aVSwitch) {
        Util.validateInputNotNull(aVSwitch, "V-Switch Node");
        ClusterNode cluster = aVSwitch.getParentCluster();
        List<AttachedRaidNode> clusterAttachedRaids = this.getAttachedRaids(cluster);
        ArrayList<AttachedRaidNode> vswitchAttchedRaids = new ArrayList<AttachedRaidNode>();
        if (clusterAttachedRaids != null) {
            for (AttachedRaidNode attachedRaid : clusterAttachedRaids) {
                if (!aVSwitch.equals(attachedRaid.getVswitch())) continue;
                vswitchAttchedRaids.add(attachedRaid);
            }
        }
        return vswitchAttchedRaids;
    }

    public List<RaidSystem> getAttachedRaidSystems(VSwitchNode aVSwitch) {
        Util.validateInputNotNull(aVSwitch, "V-Switch Node");
        ArrayList<RaidSystem> attachedRaidSystems = new ArrayList<RaidSystem>();
        for (AttachedRaidNode attachedRaidNode : this.getAttachedRaids(aVSwitch)) {
            RaidSystem raidSys = this.findEquivalent(attachedRaidNode);
            if (raidSys == null) continue;
            attachedRaidSystems.add(raidSys);
        }
        return attachedRaidSystems;
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        AttachedRaid stub = (AttachedRaid)e.getElement();
        AttachedRaidNode raid = (AttachedRaidNode)SystemRootNode.getInstance().getRefByStub(stub);
        if (raid == null) {
            return;
        }
        HashMap params = this.getParameterList(e);
        String name = (String)params.get(ClientParameterCode.ATTACHED_RAID_NAME);
        byte[] wwnBytes = (byte[])params.get(ClientParameterCode.ATTACHED_RAID_UNIQUE_NAME);
        SrEntityNameFormat wwn = null;
        if (wwnBytes != null) {
            wwn = new SrEntityNameFormat(wwnBytes);
        }
        String ctrlIp1 = (String)params.get(ClientParameterCode.ATTACHED_RAID_CTRL_IP1);
        String ctrlIp2 = (String)params.get(ClientParameterCode.ATTACHED_RAID_CTRL_IP2);
        if (name != null) {
            raid.setName(name);
        }
        if (wwn != null) {
            raid.setWwn(wwn);
        }
        if (params.containsKey(ClientParameterCode.ATTACHED_RAID_CTRL_IP1)) {
            raid.setCtrlIp1(ctrlIp1);
        }
        if (params.containsKey(ClientParameterCode.ATTACHED_RAID_CTRL_IP2)) {
            raid.setCtrlIp1(ctrlIp2);
        }
        ClusterNode cluster = e.getClusterNode();
        this.fireAttachedRaidChanged(raid, cluster);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        AttachedRaidNode attachedRaidNode;
        AttachedRaid stub = (AttachedRaid)e.getElement();
        HashMap params = this.getParameterList(e);
        try {
            attachedRaidNode = this.createAttachedRaidNode(stub, params);
        }
        catch (RemoteException e1) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e1, new Object[0]);
            return;
        }
        ClusterNode cluster = e.getClusterNode();
        if (attachedRaidNode != null && cluster != null) {
            this.addAttachedRaid(cluster, attachedRaidNode);
            this.fireAttachedRaidCreated(attachedRaidNode, cluster);
        }
    }

    private void fireAttachedRaidCreated(AttachedRaidNode aAttachedRaid, ClusterNode aCluster) {
        Util.validateInputNotNull(aCluster, "Cluster node");
        Util.validateInputNotNull(aAttachedRaid, "Attached Raid Node");
        RaidSystem raidSys = RaidManager.getInstance().findRaid(aCluster, aAttachedRaid.getWwn(), aAttachedRaid.getCtrlIp1(), aAttachedRaid.getCtrlIp2());
        if (raidSys == null) {
            throw new IllegalStateException("Failed to find RaidSystem for Attached Raid [" + aAttachedRaid + "]");
        }
        RaidEvent event = RaidEventFactory.createEventForRaidAttached(this, raidSys);
        RaidManager.getInstance().notifyListenersOfNewEvent(event);
    }

    private void fireAttachedRaidRemoved(AttachedRaidNode aAttachedRaid, ClusterNode aCluster) {
        Util.validateInputNotNull(aCluster, "Cluster node");
        Util.validateInputNotNull(aAttachedRaid, "Attached Raid Node");
        RaidSystem raidSys = RaidManager.getInstance().findRaid(aCluster, aAttachedRaid.getWwn(), aAttachedRaid.getCtrlIp1(), aAttachedRaid.getCtrlIp2());
        if (raidSys != null) {
            RaidEvent event = RaidEventFactory.createEventForRaidDetached(this, raidSys);
            RaidManager.getInstance().notifyListenersOfNewEvent(event);
        }
    }

    private void fireAttachedRaidChanged(AttachedRaidNode aAttachedRaid, ClusterNode aCluster) {
    }

    private AttachedRaidNode createAttachedRaidNode(AttachedRaid aStub, HashMap aParams) throws RemoteException {
        String name = (String)aParams.get(ClientParameterCode.ATTACHED_RAID_NAME);
        byte[] wwnBytes = (byte[])aParams.get(ClientParameterCode.ATTACHED_RAID_UNIQUE_NAME);
        SrEntityNameFormat wwn = null;
        if (wwnBytes != null) {
            wwn = new SrEntityNameFormat(wwnBytes);
        }
        InetAddress ctrlIp1 = (InetAddress)aParams.get(ClientParameterCode.ATTACHED_RAID_CTRL_IP1);
        InetAddress ctrlIp2 = (InetAddress)aParams.get(ClientParameterCode.ATTACHED_RAID_CTRL_IP2);
        CommKeyClassId vswitchId = (CommKeyClassId)aParams.get(ClientParameterCode.VSWITCH_ID);
        if (vswitchId == null || name == null && wwn == null) {
            theLogger.error(SrLogCategories.ILLEGAL_ARGUMENT, new IllegalArgumentException(), "The attached RAID stub = ", aStub, " with params ", aParams, " Received is empty or missing elements.");
            return null;
        }
        String ctrlIpStr1 = ctrlIp1 != null ? ctrlIp1.getHostAddress() : null;
        String ctrlIpStr2 = ctrlIp2 != null ? ctrlIp2.getHostAddress() : null;
        return new AttachedRaidNode(aStub, aStub.getCommKeyClassId(), name, wwn, ctrlIpStr1, ctrlIpStr2, vswitchId);
    }

    public void readDataFromServer(ClusterNode aCluster) {
        try {
            for (AttachedRaid raidStub : ((Cluster)aCluster.getStub()).getAttachedRaids()) {
                HashMap params = raidStub.getClientParameterList();
                this.addAttachedRaid(aCluster, this.createAttachedRaidNode(raidStub, params));
            }
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e.getMessage());
        }
        catch (IllegalValueException e) {
            theLogger.error(SrLogCategories.CLIENT_SERVER_INTERFACE, e.getMessage());
        }
    }

    public void readDataFromServer() {
        for (ClusterNode cluster : SystemRootNode.getInstance().getClusterNodes()) {
            this.readDataFromServer(cluster);
        }
    }

    public void removeAttachedRaids(ClusterNode aCluster) {
        Util.validateInputNotNull(aCluster, "Cluster Node");
        ArrayList<AttachedRaidNode> attahcedRaids = this.myClusterToRaidsMap.remove(aCluster);
        if (attahcedRaids == null) {
            return;
        }
        for (AttachedRaidNode node : attahcedRaids) {
            this.removeAttachedRaid(node);
        }
    }

    public boolean isAttached(RaidSystem aRaidSys) {
        return this.isAttached(aRaidSys, null);
    }

    public boolean isAttached(RaidSystem aRaidSys, VSwitchNode aVswitch) {
        AttachedRaidNode attachedRaid = this.findEquivalent(aRaidSys);
        if (attachedRaid != null && aVswitch != null) {
            return aVswitch.equals(attachedRaid.getVswitch());
        }
        return attachedRaid != null;
    }

    public AttachedRaidNode findEquivalent(RaidSystem aRaidSys) {
        Util.validateInputNotNull(aRaidSys, "RAID System");
        for (ClusterNode cluster : aRaidSys.getClusters()) {
            List<AttachedRaidNode> attachedRaids = this.getAttachedRaids(cluster);
            for (AttachedRaidNode attachedRaid : attachedRaids) {
                RaidSystem equivalentRaidSys = RaidManager.getInstance().findRaid(cluster, attachedRaid.getWwn(), attachedRaid.getCtrlIp1(), attachedRaid.getCtrlIp2());
                if (!aRaidSys.equals(equivalentRaidSys)) continue;
                return attachedRaid;
            }
        }
        return null;
    }

    private RaidSystem findEquivalent(AttachedRaidNode aAttachedRaid) {
        Util.validateInputNotNull(aAttachedRaid, "Attached RAID node");
        VSwitchNode vs = aAttachedRaid.getVswitch();
        if (vs != null) {
            RaidSystem equivalentRaidSys = RaidManager.getInstance().findRaid(vs.getParentCluster(), aAttachedRaid.getWwn(), aAttachedRaid.getCtrlIp1(), aAttachedRaid.getCtrlIp2());
            return equivalentRaidSys;
        }
        throw new IllegalStateException(aAttachedRaid + " has no V-Switch Node");
    }
}

