/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.login.dialogs;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.login.User;
import com.sanrad.nms.client.data.login.UsersManager;
import com.sanrad.nms.client.event.login.UserEvent;
import com.sanrad.nms.client.event.login.UserListener;
import com.sanrad.nms.client.gui.login.UsersTableHeader;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrUsersTableModel
extends SrTableModel
implements UserListener {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrUsersTableModel() {
        super(new SrDefaultTableColumns(UsersTableHeader.getColumnNames()));
        Vector data = UsersManager.getInstance().getAllUsers();
        this.initModel(data);
    }

    private void initModel(Vector data) {
        this.removeAllRows();
        for (int i = 0; i < data.size(); ++i) {
            Vector rowData = new Vector();
            rowData.addElement(data.get(i));
            this.addRowQuetly(rowData.toArray(), -1);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    public void addListeners() {
        UsersManager.getInstance().addUserListener(this);
    }

    @Override
    public void removeListeners() {
        UsersManager.getInstance().removeUserListener(this);
    }

    @Override
    public void loginSucceed(UserEvent e) {
    }

    @Override
    public void userCreated(UserEvent e) {
        User user = e.getUser();
        Vector<User> rowData = new Vector<User>(1);
        rowData.addElement(user);
        this.addRow(rowData.toArray());
    }

    @Override
    public void userRemoved(UserEvent e) {
        User user = e.getUser();
        int rows = this.getRowCount();
        int col = this.getColumnIndex(UsersTableHeader.USER.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object obj = this.getValueAt(i, col);
            if (!obj.equals(user)) continue;
            this.removeRow(i);
            return;
        }
    }

    @Override
    public void userPasswordChanged(UserEvent e) {
    }
}

