/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.login;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.login.User;
import com.sanrad.nms.client.event.login.UserEvent;
import com.sanrad.nms.client.event.login.UserListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.security.StringCodec;
import com.sanrad.swing.actions.OperationController;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class UsersManager
extends ElementManager {
    private static UsersManager instance = null;
    private Vector users;
    private String key = null;
    private com.sanrad.nms.server.user.User currentUser = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer loginSucceedInformer = new SrEventListenerManager.Informer<UserListener, UserEvent>(){

        @Override
        public void inform(UserListener listener, UserEvent event) {
            listener.loginSucceed(event);
        }
    };
    SrEventListenerManager.Informer userRemovedInformer = new SrEventListenerManager.Informer<UserListener, UserEvent>(){

        @Override
        public void inform(UserListener listener, UserEvent event) {
            listener.userRemoved(event);
        }
    };
    SrEventListenerManager.Informer userCreatedInformer = new SrEventListenerManager.Informer<UserListener, UserEvent>(){

        @Override
        public void inform(UserListener listener, UserEvent event) {
            listener.userCreated(event);
        }
    };

    private UsersManager() {
        this.users = new Vector();
    }

    public void addUserListener(UserListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeUserListener(UserListener listener) {
        this.m_listeners.remove(listener);
    }

    public static synchronized UsersManager getInstance() {
        if (instance == null) {
            instance = new UsersManager();
        }
        return instance;
    }

    public SrFuture<Void> changePassword(String oldPassword, String newPassword) {
        theLogger.logAndAssert(SrLogCategories.ERROR, this.currentUser != null, new Object[]{"Change password before login!"});
        if (this.currentUser == null) {
            return new CompleteFuture<Void>("changePassword");
        }
        String encOldPassword = StringCodec.encryptString(this.key, oldPassword);
        String encNewPassword = StringCodec.encryptString(this.key, newPassword);
        return ClientAOImpl.getInstance().changePassword(encOldPassword, encNewPassword);
    }

    public SrFuture<Void> addUser(String username, String password) {
        String encPassword = StringCodec.encryptString(this.key, password);
        return ClientAOImpl.getInstance().addUser(username, encPassword);
    }

    public void removeUser(String username, OperationController controller) {
    }

    public SrFuture<Void> removeUsers(Vector users) {
        int size = users.size();
        Vector<String> usersToDelete = new Vector<String>(size);
        for (int i = 0; i < size; ++i) {
            User user = (User)users.get(i);
            usersToDelete.addElement(user.getIdentifier());
        }
        return ClientAOImpl.getInstance().removeUsers(usersToDelete);
    }

    public Vector getAllUsers() {
        return this.users;
    }

    public com.sanrad.nms.server.user.User getCurrentUser() {
        return this.currentUser;
    }

    public String getCurrentUserName() {
        try {
            return this.currentUser.getUsername();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            UsersManager.onConnectionError();
            return "User";
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    private void getUsersFromServer() {
        try {
            HashMap map = Communication.getInstance().getUserManager().getAllUsers();
            if (map.isEmpty()) {
                return;
            }
            Set set = map.keySet();
            for (Object nextkey : set) {
                Object value = map.get(nextkey);
                User user = new User((String)nextkey, (RemoteObject)value);
                this.users.addElement(user);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            UsersManager.onConnectionError();
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, ive.getMessage());
        }
    }

    @Override
    public void loginSucceed(CommunicationEvent e) {
        this.getUsersFromServer();
        RemoteObject obj = e.getElement();
        this.currentUser = (com.sanrad.nms.server.user.User)obj;
        UserEvent event = new UserEvent(this);
        this.m_listeners.fireEvent(UserListener.class, event, this.loginSucceedInformer);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        try {
            com.sanrad.nms.server.user.User u = (com.sanrad.nms.server.user.User)element;
            String username = u.getUsername();
            User user = new User(username, u);
            this.users.addElement(user);
            this.fireUserCreated(user);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            UsersManager.onConnectionError();
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        try {
            String username = ((com.sanrad.nms.server.user.User)element).getUsername();
            User user = this.getUser(username);
            if (user != null) {
                this.users.remove(user);
                this.fireUserRemoved(user);
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            UsersManager.onConnectionError();
        }
    }

    @Override
    public Object discoverElement() {
        return null;
    }

    private User getUser(String username) {
        for (int i = 0; i < this.users.size(); ++i) {
            User u = (User)this.users.get(i);
            if (!u.getUserName().equalsIgnoreCase(username)) continue;
            return u;
        }
        return null;
    }

    private void fireUserRemoved(User user) {
        UserEvent event = new UserEvent(this, user);
        this.m_listeners.fireEvent(UserListener.class, event, this.userRemovedInformer);
    }

    private void fireUserCreated(User user) {
        UserEvent event = new UserEvent(this, user);
        this.m_listeners.fireEvent(UserListener.class, event, this.userCreatedInformer);
    }
}

