/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.login;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.ElementValidator;
import com.sanrad.util.SrConstantsBundleKeys;

public class LoginValidator
extends ElementValidator {
    public static final int MAX_PASSWORD_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.LOGIN_MAX_PASSWORD_LENGTH));
    public static final int MIN_PASSWORD_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.LOGIN_MIN_PASSWORD_LENGTH));
    public static final int MIN_USER_NAME_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.LOGIN_MIN_USER_NAME_LENGTH));
    public static final int MAX_USER_NAME_LENGTH = Integer.parseInt(ClientLoader.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.LOGIN_MAX_USER_NAME_LENGTH));
    private String userName;
    private String password;

    public LoginValidator(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    @Override
    public boolean isValidForCreation() {
        StringBuffer sb = new StringBuffer();
        int len = this.userName.trim().length();
        if (len < MIN_USER_NAME_LENGTH || len > MAX_USER_NAME_LENGTH) {
            sb.append("User Name must contain [");
            sb.append(MIN_USER_NAME_LENGTH);
            sb.append("-");
            sb.append(MAX_USER_NAME_LENGTH);
            sb.append("] characters.");
            this.setErrorMessage(sb.toString());
            return false;
        }
        len = this.password.trim().length();
        if (len < MIN_PASSWORD_LENGTH || len > MAX_PASSWORD_LENGTH) {
            sb.append("Password must contain [");
            sb.append(MIN_PASSWORD_LENGTH);
            sb.append("-");
            sb.append(MAX_PASSWORD_LENGTH);
            sb.append("] characters.");
            this.setErrorMessage(sb.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidForRemoval() {
        return true;
    }
}

