/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.log;

import com.sanrad.log.LogManager;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.Communication;
import com.sanrad.nms.client.data.log.LogParameterConfigMgr;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.user.UserManager;
import com.sanrad.swing.StatusPanel;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;

public class LogParameterMgr
implements LogParameterConfigMgr {
    private static LogParameterMgr theInstance = null;
    private static final String SERVER_PROPERTY = "log4j.logger.com.sanrad.nms.server";
    private static final String CLIENT_PROPERTY = "log4j.logger.com.sanrad.nms.client";
    private static final String CLIENT_EXCEPTION_APPENDER_FILE = "log4j.appender.EXP_APP.File";
    private static final String EXCEPTION_FILE_NAME = "exceptions.log";
    private static final String EXPORT_TOPOLOGY_XML_FILENAME_PROPERTY = "log4j.appender.EXPORT_TOPOLOGY_APP.File";
    private static final String EXPORT_TOPOLOGY_XML_DIR_PROPERTY = "log4j.appender.EXPORT_TOPOLOGY_APP.Dir";
    private static final String EXPORT_TOPOLOGY_XSL_FILE = "log4j.appender.EXPORT_TOPOLOGY_APP.XSLFile";
    private Properties myClientLogProps = new Properties();
    private Properties myServerLogProps = new Properties();

    public static LogParameterMgr getInstance() {
        return theInstance;
    }

    protected LogParameterMgr() {
    }

    @Override
    public synchronized void setServerProps(Properties aProp) {
        assert (aProp != null) : "The given properties should not be null";
        if (aProp != null) {
            this.myServerLogProps = aProp;
        }
        if (aProp != null && !aProp.isEmpty()) assert (aProp.containsKey(SERVER_PROPERTY)) : "The logging configuration should contain the server logging configuration.";
    }

    @Override
    public SrFuture<Void> reloadProperties() {
        return ClientAOImpl.getInstance().reloadProperties();
    }

    @Override
    public synchronized String getClientLogLabel() {
        return this.getLoggingToolbarString(this.myClientLogProps, CLIENT_PROPERTY);
    }

    @Override
    public synchronized String getServerLogLabel() {
        return this.getLoggingToolbarString(this.myServerLogProps, SERVER_PROPERTY);
    }

    private String getLoggingToolbarString(Properties aProp, String aTargetProp) {
        String curLevel = aProp.getProperty(aTargetProp);
        if (curLevel != null && !curLevel.equals("")) {
            curLevel = curLevel.split(",")[0];
            if (SrLogger.getLogLevels().contains(Level.toLevel(curLevel))) {
                return curLevel;
            }
        }
        return "INVALID";
    }

    @Override
    public synchronized void handleLogConfigChangeEvent(RemoteEvent event) {
        if (event == null) {
            assert (false) : "The given event should not be null.";
            return;
        }
        try {
            Properties newProp = ((ElementEvent)event).getProperties();
            if (SrLogger.isServerProperties(newProp)) {
                StatusPanel.getInstance().setServerLogLevel(this.getLoggingToolbarString(newProp, SERVER_PROPERTY));
                this.myServerLogProps = newProp;
            } else if (SrLogger.isClientProperties(newProp)) {
                StatusPanel.getInstance().setClientLogLevel(this.getLoggingToolbarString(newProp, CLIENT_PROPERTY));
                this.setProps(newProp);
            } else assert (false) : "The given properties type is invalid.";
        }
        catch (RemoteException e) {
            System.err.println("The logging configuration could not be changed. The exception is: " + e);
        }
    }

    @Override
    public SrFuture<Void> replaceLoggingLevels(String aClientPropName, String aClientLevel, String aServerPropName, String aServerLevel) {
        return ClientAOImpl.getInstance().replaceLoggingLevels(aClientPropName, aClientLevel, aServerPropName, aServerLevel);
    }

    @Override
    public synchronized String getClientLevel() {
        return this.getLoggingLevel(this.myClientLogProps, CLIENT_PROPERTY);
    }

    @Override
    public String getServerLevel() {
        Properties props = this.getServerProps();
        return this.getLoggingLevel(props, SERVER_PROPERTY);
    }

    @Override
    public synchronized void setProps(Properties aProps) {
        assert (aProps != null) : "Props cannot be null!!";
        this.myClientLogProps = aProps;
        SrLogger.reInit(aProps);
    }

    private String getLoggingLevel(Properties aProp, String aKey) {
        String retLevel = aProp.getProperty(aKey);
        if (retLevel == null) {
            return "";
        }
        retLevel = retLevel.split(",")[0];
        return retLevel;
    }

    @Override
    public Properties getServerProps() {
        if (this.myServerLogProps == null) {
            assert (false) : "The server properties should never be null at this point";
            this.myServerLogProps = new Properties();
        }
        return this.myServerLogProps;
    }

    public String getClientExportTopologyXMLDirectory() {
        String directoryLoc = this.getClientProps().getProperty(EXPORT_TOPOLOGY_XML_DIR_PROPERTY);
        if (directoryLoc == null) {
            return null;
        }
        return this.replacePropertiesWithValues(directoryLoc);
    }

    public String getClientExportTopologyXMLFileName() {
        return this.getClientProps().getProperty(EXPORT_TOPOLOGY_XML_FILENAME_PROPERTY);
    }

    public String getClientExportTopologyXSLFile() {
        String xslLocation = this.getClientProps().getProperty(EXPORT_TOPOLOGY_XSL_FILE);
        xslLocation = this.replacePropertiesWithValues(xslLocation);
        SrLogger.getLogger().info(SrLogCategories.INFORMATIVE, "The Export Topology XSL location returned is: ", xslLocation);
        return xslLocation;
    }

    private String replacePropertiesWithValues(String aInpString) {
        String retStr = aInpString;
        Pattern p = Pattern.compile("\\$\\{.+\\}");
        Matcher m = p.matcher(aInpString);
        while (m.find()) {
            retStr = retStr.replace(m.group(), System.getProperty(m.group().substring(2, m.group().indexOf(125))));
        }
        return this.replaceFileSeparator(retStr);
    }

    public String replaceFileSeparator(String aStr) {
        String fileSep = System.getProperties().getProperty("file.separator");
        if (fileSep.equals("\\")) {
            fileSep = fileSep + "\\";
        }
        String regex = "\\\\";
        String retStr = aStr.replaceAll(regex, fileSep);
        retStr = retStr.replaceAll("/", fileSep);
        return retStr;
    }

    public Properties getClientProps() {
        return this.myClientLogProps;
    }

    @Override
    public void reloadLoggingLevels() {
        assert (false) : "This method should not be used in this manager.";
    }

    public Properties getClientProps(String aHostName, int aRmiPort) {
        try {
            UserManager curUserMan = null;
            curUserMan = Communication.getInstance().getUserManager(aHostName, aRmiPort);
            if (curUserMan == null) {
                return new Properties();
            }
            LogManager curLogManager = curUserMan.getLogManager();
            if (curLogManager == null) {
                return new Properties();
            }
            Properties retProps = curLogManager.getClientLogProps();
            if (retProps == null) {
                return new Properties();
            }
            return retProps;
        }
        catch (RemoteException re) {
            System.err.println("The log configuration could not be loaded because a connection to the server has not been established.");
        }
        catch (NotBoundException nbe) {
            System.err.println("The log configuration could not be loaded because a connection to the server has not been established.");
        }
        return new Properties();
    }

    static {
        theInstance = new LogParameterMgr();
    }
}

