/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.statistics;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.SrISCSISessionsStatisticsTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import java.util.Vector;

public class SrISCSISessionsStatisticsTargetViewTableModel
extends SrISCSISessionsStatisticsTableModel {
    private String myContextNodeName = null;
    private String myContextNodeAlias = null;

    public SrISCSISessionsStatisticsTargetViewTableModel(TargetNode targethNode) {
        this.initModel(targethNode);
    }

    protected void initModel(TargetNode targetNode) {
        if (targetNode != null) {
            this.myContextNodeName = targetNode.getName();
            this.myContextNodeAlias = targetNode.getAlias();
        }
        this.removeAllRows();
        ClusterNode clusterNode = SystemRootNode.getInstance().getCurrentClusterNode();
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        for (int index1 = 0; index1 < clusterVswitches.size(); ++index1) {
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index1);
            Vector vswitchSessionStatistics = vswitchNode.getISCSISessionsStatisticsTableNodes();
            for (int index2 = 0; index2 < vswitchSessionStatistics.size(); ++index2) {
                ISCSISessionStatisticsNode sessionStatisticsNode = (ISCSISessionStatisticsNode)vswitchSessionStatistics.elementAt(index2);
                String targetName = sessionStatisticsNode.getTargetName();
                if (targetName == null || !targetName.equals(targetNode.getName())) continue;
                this.addEntryToTable(sessionStatisticsNode);
            }
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    protected boolean nodeRelevantToContext(ISCSISessionStatisticsNode aNode) {
        if (this.myContextNodeAlias == null || this.myContextNodeName == null) {
            return false;
        }
        String alias = aNode.getTargetAlias();
        String name = aNode.getTargetName();
        if (alias == null || name == null) {
            throw new IllegalStateException("The ISCSISessionStatistics target alias and name should not be null. Alias = " + alias + "; Name = " + name + "; ISCSISessionStatisticsNode = " + aNode);
        }
        return name.equals(this.myContextNodeName) && alias.equals(this.myContextNodeAlias);
    }
}

