/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.statistics;

import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionsStatisticsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsListener;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsStatisticsListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.iscsi.session.statistics.ISCSISessionsStatisticsTableHeader;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public abstract class SrISCSISessionsStatisticsTableModel
extends SrTableModel
implements ISCSISessionsStatisticsListener,
ISCSISessionsListener,
VSwitchListener {
    private ArrayList m_tableNodes = new ArrayList();

    protected SrISCSISessionsStatisticsTableModel() {
        super(new SrDefaultTableColumns(ISCSISessionsStatisticsTableHeader.getColumnNames()));
    }

    @Override
    public void removeListeners() {
        ISCSISessionsStatisticsManager.getInstance().removeISCSISessionsStatisticsListener(this);
        ISCSISessionsManager.getInstance().removeISCSISessionsListener(this);
        VSwitchManager.getInstance().removeVSwitchListener(this);
    }

    @Override
    public void addListeners() {
        ISCSISessionsStatisticsManager.getInstance().addISCSISessionsStatisticsListener(this);
        ISCSISessionsManager.getInstance().addISCSISessionsListener(this);
        VSwitchManager.getInstance().addVSwitchListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int initiatorNameIndex = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.INITIATOR_NAME.getColumnName());
        if (col == initiatorNameIndex) {
            return true;
        }
        return super.isCellEditable(row, col);
    }

    public ISCSISessionStatisticsNode[] getSessionStatisticsNodes() {
        ISCSISessionStatisticsNode[] array = new ISCSISessionStatisticsNode[this.m_tableNodes.size()];
        return this.m_tableNodes.toArray(array);
    }

    protected void addEntryToTable(ISCSISessionStatisticsNode sessionStatisticsNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(sessionStatisticsNode.getSessionShowStub());
        rowData.addElement(sessionStatisticsNode.getStub());
        rowData.addElement(sessionStatisticsNode.getParentStub());
        rowData.addElement(sessionStatisticsNode.getVSwitchName());
        rowData.addElement(sessionStatisticsNode.getInitiatorAlias());
        rowData.addElement(sessionStatisticsNode.getInitiatorName());
        rowData.addElement(sessionStatisticsNode.getISID());
        rowData.addElement(sessionStatisticsNode.getTargetAlias());
        rowData.addElement(sessionStatisticsNode.getTargetName());
        rowData.addElement(sessionStatisticsNode.getTSIH());
        rowData.addElement(sessionStatisticsNode.getCmdPDUs());
        rowData.addElement(sessionStatisticsNode.getRspPDUs());
        rowData.addElement(sessionStatisticsNode.getTxBytes());
        rowData.addElement(sessionStatisticsNode.getRxBytes());
        rowData.addElement(sessionStatisticsNode.getDigestsErr());
        rowData.addElement(sessionStatisticsNode.getTimeoutErr());
        this.m_tableNodes.add(sessionStatisticsNode);
        this.addRowQuetly(rowData.toArray(), -1);
    }

    public void addCreatedSessionStatistics(ISCSISessionStatisticsNode statisticsNode) {
        this.addEntryToTable(statisticsNode);
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    protected void removeFromTable(ISCSISessionStatisticsNode statisticsNode) {
        int size = this.getRowCount();
        int rowStubCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.SESSION_STATISTICS_STUB.getColumnName());
        for (int i = size - 1; i >= 0; --i) {
            Object tableRowStub = this.getValueAt(i, rowStubCol);
            if (!((ISCSISessionStatistics)statisticsNode.getStub()).equals(tableRowStub)) continue;
            this.removeRow(i);
            this.m_tableNodes.remove(statisticsNode);
            break;
        }
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        ISCSISessionStatisticsNode statisticsNode = (ISCSISessionStatisticsNode)e.getStatisticsNode();
        HashMap changedValsMap = statisticsNode.getChangedValues();
        Object changedRowStub = statisticsNode.getStub();
        int rows = this.getRowCount();
        int rowStubCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.SESSION_STATISTICS_STUB.getColumnName());
        int cmdPDUsCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.CMD_PDUS.getColumnName());
        int rspPDUsCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.RSP_PDUS.getColumnName());
        int txBytesCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.TX_BYTES.getColumnName());
        int rxBytesCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.RX_BYTES.getColumnName());
        int digestsErrCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.DIGESTS_ERR.getColumnName());
        int timeoutErrCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.TIMEOUT_ERR.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object tableRowStub = this.getValueAt(i, rowStubCol);
            if (!changedRowStub.equals(tableRowStub)) continue;
            BigInteger cmdPDUsVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_SESSION_STATISTICS_CMD_PDUS);
            BigInteger rspPDUsVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_SESSION_STATISTICS_RSP_PDUS);
            BigInteger txBytesVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_SESSION_STATISTICS_TX_BYTES);
            BigInteger rxBytesVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_SESSION_STATISTICS_RX_BYTES);
            BigInteger digestErrVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_SESSION_STATISTICS_DIGESTS_ERR);
            BigInteger timeoutErrVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_SESSION_STATISTICS_TIMEOUT_ERR);
            if (cmdPDUsVal != null) {
                this.setValueAt(cmdPDUsVal, i, cmdPDUsCol);
            }
            if (rspPDUsVal != null) {
                this.setValueAt(rspPDUsVal, i, rspPDUsCol);
            }
            if (txBytesVal != null) {
                this.setValueAt(txBytesVal, i, txBytesCol);
            }
            if (rxBytesVal != null) {
                this.setValueAt(rxBytesVal, i, rxBytesCol);
            }
            if (digestErrVal != null) {
                this.setValueAt(digestErrVal, i, digestsErrCol);
            }
            if (timeoutErrVal == null) continue;
            this.setValueAt(timeoutErrVal, i, timeoutErrCol);
        }
    }

    @Override
    public void iscsiSessionStatisticsCreated(StatisticsEvent e) {
        ISCSISessionStatisticsNode statisticsNode = (ISCSISessionStatisticsNode)e.getStatisticsNode();
        if (!this.nodeRelevantToContext(statisticsNode)) {
            return;
        }
        this.addCreatedSessionStatistics(statisticsNode);
    }

    @Override
    public void iscsiSessionStatisticsRemoved(StatisticsEvent e) {
        ISCSISessionStatisticsNode statisticsNode = (ISCSISessionStatisticsNode)e.getStatisticsNode();
        this.removeFromTable(statisticsNode);
    }

    @Override
    public void iscsiSessionCreated(ISCSISessionEvent e) {
    }

    @Override
    public void iscsiSessionRemoved(ISCSISessionEvent e) {
    }

    @Override
    public void iscsiSessionChanged(ISCSISessionEvent e) {
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        int rows = this.getRowCount();
        int vswitchCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.VSWITCH_STUB.getColumnName());
        int vswitchNameCol = this.getColumnIndex(ISCSISessionsStatisticsTableHeader.VSWITCH.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object vswitchRowStub = this.getValueAt(i, vswitchCol);
            String vswitchName = (String)this.getValueAt(i, vswitchNameCol);
            if (!vswitchRowStub.equals(e.getStub())) continue;
            String name = e.getName();
            if (name == null || name.equalsIgnoreCase(vswitchName)) break;
            this.setValueAt(name, i, vswitchNameCol);
            break;
        }
    }

    protected abstract boolean nodeRelevantToContext(ISCSISessionStatisticsNode var1);
}

