/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.statistics;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.SrISCSISessionsStatisticsTableModel;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.util.Vector;

public class SrISCSISessionsStatisticsClusterViewTableModel
extends SrISCSISessionsStatisticsTableModel {
    private CommKeyClassId myContextNodeCkci = null;

    public SrISCSISessionsStatisticsClusterViewTableModel(ClusterNode clusterNode) {
        this.initModel(clusterNode);
    }

    public void initModel(ClusterNode clusterNode) {
        if (clusterNode != null) {
            this.myContextNodeCkci = (CommKeyClassId)clusterNode.getIdentifier();
        }
        this.removeAllRows();
        if (clusterNode == null) {
            return;
        }
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        for (int index1 = 0; index1 < clusterVswitches.size(); ++index1) {
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index1);
            Vector vswitchSessionsStatistics = vswitchNode.getISCSISessionsStatisticsTableNodes();
            for (int index2 = 0; index2 < vswitchSessionsStatistics.size(); ++index2) {
                ISCSISessionStatisticsNode sessionStatisticsNode = (ISCSISessionStatisticsNode)vswitchSessionsStatistics.elementAt(index2);
                this.addEntryToTable(sessionStatisticsNode);
            }
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    protected boolean nodeRelevantToContext(ISCSISessionStatisticsNode aNode) {
        ClusterNode curCluster = (ClusterNode)aNode.getVSwitch().getParent();
        if (curCluster == null || this.myContextNodeCkci == null) {
            return false;
        }
        return this.myContextNodeCkci.equals(curCluster.getIdentifier());
    }
}

