/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.statistics;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.ISCSISessionStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.statistics.SessionsGroupStatisticsNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsStatisticsListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionsGroupStatistics;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class ISCSISessionsStatisticsManager
extends ElementManager {
    private static ISCSISessionsStatisticsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer statisticsElementChangedInformer = new SrEventListenerManager.Informer<ISCSISessionsStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(ISCSISessionsStatisticsListener listener, StatisticsEvent event) {
            listener.statisticsElementChanged(event);
        }
    };
    SrEventListenerManager.Informer iscsiSessionStatisticsCreatedInformer = new SrEventListenerManager.Informer<ISCSISessionsStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(ISCSISessionsStatisticsListener listener, StatisticsEvent event) {
            listener.iscsiSessionStatisticsCreated(event);
        }
    };
    SrEventListenerManager.Informer iscsiSessionStatisticsRemovedInformer = new SrEventListenerManager.Informer<ISCSISessionsStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(ISCSISessionsStatisticsListener listener, StatisticsEvent event) {
            listener.iscsiSessionStatisticsRemoved(event);
        }
    };

    private ISCSISessionsStatisticsManager() {
    }

    public static synchronized ISCSISessionsStatisticsManager getInstance() {
        if (m_instance == null) {
            m_instance = new ISCSISessionsStatisticsManager();
        }
        return m_instance;
    }

    public void addISCSISessionsStatisticsListener(ISCSISessionsStatisticsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSISessionsStatisticsListener(ISCSISessionsStatisticsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public SessionsGroupStatisticsNode readISCSISessionsGroupStatistics(VSwitchNode aVSwitchNode) {
        try {
            ISCSISessionsGroupStatistics sessionsGroupStatistics = ((VSwitch)aVSwitchNode.getStub()).getISCSISessionsGroupStatistics();
            SessionsGroupStatisticsNode sessionsGroupStatisticsNode = new SessionsGroupStatisticsNode(sessionsGroupStatistics, aVSwitchNode);
            SystemRootNode.getInstance().putRefAndStub(sessionsGroupStatistics, sessionsGroupStatisticsNode);
            return sessionsGroupStatisticsNode;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, "Failed to create ISCSISessions Statistics Group.");
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSISessionsStatisticsManager.onConnectionError("Failed to create ISCSISessions Statistics Group.");
            return null;
        }
    }

    public Vector readAllISCSISessionsStatistics(VSwitch vSwitch) {
        Vector<ISCSISessionStatisticsNode> iscsiSessionStatisticsNodes = new Vector<ISCSISessionStatisticsNode>();
        try {
            Vector<? extends ISCSISessionStatistics> iscsiSessionsStatisticsTable = vSwitch.getISCSISessionsStatisticsTable();
            if (iscsiSessionsStatisticsTable != null && !iscsiSessionsStatisticsTable.isEmpty()) {
                for (int index = 0; index < iscsiSessionsStatisticsTable.size(); ++index) {
                    ISCSISessionStatistics initiator = iscsiSessionsStatisticsTable.get(index);
                    ISCSISessionStatisticsNode sessionStatisticsNode = this.discoverSessionStatistics(initiator);
                    iscsiSessionStatisticsNodes.addElement(sessionStatisticsNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSISessionsStatisticsManager.onConnectionError("Failed to get ISCSI Session Statistics Table from the Server.");
        }
        return iscsiSessionStatisticsNodes;
    }

    protected ISCSISessionStatisticsNode discoverSessionStatistics(ISCSISessionStatistics sessionStatistics) {
        ISCSISessionStatisticsNode sessionStatisticsNode = (ISCSISessionStatisticsNode)SystemRootNode.getInstance().getRefByStub(sessionStatistics);
        if (sessionStatisticsNode == null) {
            try {
                sessionStatisticsNode = new ISCSISessionStatisticsNode(sessionStatistics, sessionStatistics.getVSwitchStub(), sessionStatistics.getSessionStub());
                sessionStatisticsNode.setCmdPDUs(sessionStatistics.getCmdPDUs());
                sessionStatisticsNode.setRspPDUs(sessionStatistics.getRspPDUs());
                sessionStatisticsNode.setTxBytes(sessionStatistics.getTxBytes());
                sessionStatisticsNode.setRxBytes(sessionStatistics.getRxBytes());
                sessionStatisticsNode.setDigestsErr(sessionStatistics.getDigestsErr());
                sessionStatisticsNode.setTimeoutErr(sessionStatistics.getTimeoutErr());
                SystemRootNode.getInstance().putRefAndStub(sessionStatistics, sessionStatisticsNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                ISCSISessionsStatisticsManager.onConnectionError("Failed to discover Session Statistics.");
            }
        }
        return sessionStatisticsNode;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSISessionsStatisticsManager: Session created");
        ISCSISessionStatistics session = (ISCSISessionStatistics)element;
        try {
            VSwitch vswitch = session.getVSwitchStub();
            ISCSISessionStatisticsNode sessionStatisticsNode = this.discoverSessionStatistics(session);
            ISCSISessionNode sessionNode = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(sessionStatisticsNode.getSessionShowStub());
            VSwitchNode sessionVswitchNode = sessionNode != null ? sessionNode.getVswitch() : (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitch);
            sessionVswitchNode.addISCSISessionStatisticsNode(sessionStatisticsNode);
            this.fireISCSISessionStatisticsCreatedEvent(sessionStatisticsNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSISessionsStatisticsManager.onConnectionError("Failed to create Session Statistics.");
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        HashMap map = e.getParameterList();
        SrTreeNode obj = SystemRootNode.getInstance().getRefByStub(element);
        if (obj != null) {
            ISCSISessionStatisticsNode node = (ISCSISessionStatisticsNode)obj;
            node.setChangedValues(map);
            this.fireSessionStatisticsChanged(node);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSISessionsStatisticsManager: session removed");
        ISCSISessionStatisticsNode sessionStatisticsNode = (ISCSISessionStatisticsNode)SystemRootNode.getInstance().getRefByStub(element);
        VSwitchNode sessionVswitch = sessionStatisticsNode.getVSwitch();
        sessionVswitch.removeISCSISessionStatisticsNode(sessionStatisticsNode);
        this.fireISCSISessionStatisticsRemovedEvent(sessionStatisticsNode);
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    public void clearISCSISessionStatisticNodeParamsList(VSwitchNode node) {
        Vector nodes = node.getISCSISessionsStatisticsTableNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                ISCSISessionStatisticsNode statisticsNode = (ISCSISessionStatisticsNode)nodes.get(i);
                statisticsNode.setChangedValues(null);
            }
        }
    }

    private void fireSessionStatisticsChanged(ISCSISessionStatisticsNode node) {
        StatisticsEvent event = new StatisticsEvent(this, node);
        this.m_listeners.fireEvent(ISCSISessionsStatisticsListener.class, event, this.statisticsElementChangedInformer);
    }

    protected void fireISCSISessionStatisticsCreatedEvent(ISCSISessionStatisticsNode node) {
        StatisticsEvent event = new StatisticsEvent(this, node);
        this.m_listeners.fireEvent(ISCSISessionsStatisticsListener.class, event, this.iscsiSessionStatisticsCreatedInformer);
    }

    protected void fireISCSISessionStatisticsRemovedEvent(ISCSISessionStatisticsNode sessionStatisticsNode) {
        StatisticsEvent event = new StatisticsEvent(this, sessionStatisticsNode);
        this.m_listeners.fireEvent(ISCSISessionsStatisticsListener.class, event, this.iscsiSessionStatisticsRemovedInformer);
    }
}

