/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.statistics;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.TableRowNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;

public class ISCSISessionStatisticsNode
extends TableRowNode<ISCSISessionStatistics> {
    private static SrLogger theLogger = SrLogger.getLogger();
    private ISCSISession m_sessionShowStub;
    private String m_initiatorAlias;
    private String m_initiatorName;
    private String m_isid;
    private String m_targetAlias;
    private String m_targetName;
    private Integer m_tsih;
    private BigInteger m_cmdPDUs;
    private BigInteger m_rspPDUs;
    private BigInteger m_txBytes;
    private BigInteger m_rxBytes;
    private BigInteger m_digestsErr;
    private BigInteger m_timeoutErr;
    private HashMap m_values;

    public ISCSISessionStatisticsNode(ISCSISessionStatistics stub, VSwitch parentStub, ISCSISession sessionStub) throws RemoteException {
        super(stub, parentStub);
        this.m_sessionShowStub = sessionStub;
        try {
            if (this.m_sessionShowStub != null) {
                this.m_initiatorAlias = this.m_sessionShowStub.getInitiatorAlias();
                this.m_initiatorName = this.m_sessionShowStub.getInitiatorName();
                this.m_isid = this.m_sessionShowStub.getISID();
                this.m_targetAlias = this.m_sessionShowStub.getTargetAlias();
                this.m_targetName = this.m_sessionShowStub.getTargetName();
                this.m_tsih = this.m_sessionShowStub.getTSIH();
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public String toString() {
        return this.type();
    }

    @Override
    public String type() {
        try {
            return "Session Statistics Node: " + this.m_sessionShowStub.getInitiatorName() + " <-> " + this.m_sessionShowStub.getTargetName();
        }
        catch (RemoteException re) {
            return "Session Statistics Node";
        }
    }

    public ISCSISession getSessionShowStub() {
        return this.m_sessionShowStub;
    }

    public String getInitiatorAlias() {
        return this.m_initiatorAlias;
    }

    public String getInitiatorName() {
        return this.m_initiatorName;
    }

    public void setInitiatorName(String name) {
        this.m_initiatorName = name;
    }

    public void setChangedValues(HashMap values) {
        this.m_values = values;
    }

    public HashMap getChangedValues() {
        return this.m_values;
    }

    public VSwitchNode getVSwitch() {
        VSwitchNode vswitch = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(this.getParentStub());
        return vswitch;
    }

    public String getTargetAlias() {
        return this.m_targetAlias;
    }

    public void setTargetAlias(String alias) {
        this.m_targetAlias = alias;
    }

    public String getTargetName() {
        return this.m_targetName;
    }

    public void setTargetName(String name) {
        this.m_targetName = name;
    }

    public void setCmdPDUs(BigInteger cmdPDUs) {
        this.m_cmdPDUs = cmdPDUs;
    }

    public BigInteger getCmdPDUs() {
        return this.m_cmdPDUs;
    }

    public void setRspPDUs(BigInteger rspPDUs) {
        this.m_rspPDUs = rspPDUs;
    }

    public BigInteger getRspPDUs() {
        return this.m_rspPDUs;
    }

    public void setTxBytes(BigInteger txBytes) {
        this.m_txBytes = txBytes;
    }

    public BigInteger getTxBytes() {
        return this.m_txBytes;
    }

    public void setRxBytes(BigInteger rxBytes) {
        this.m_rxBytes = rxBytes;
    }

    public BigInteger getRxBytes() {
        return this.m_rxBytes;
    }

    public void setDigestsErr(BigInteger digestsErr) {
        this.m_digestsErr = digestsErr;
    }

    public BigInteger getDigestsErr() {
        return this.m_digestsErr;
    }

    public void setTimeoutErr(BigInteger timeoutErr) {
        this.m_timeoutErr = timeoutErr;
    }

    public BigInteger getTimeoutErr() {
        return this.m_timeoutErr;
    }

    public String getISID() {
        return this.m_isid;
    }

    public Integer getTSIH() {
        return this.m_tsih;
    }
}

