/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.show;

import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.show.SrISCSISessionsTableModel;
import com.sanrad.nms.client.data.target.TargetNode;
import java.util.ArrayList;
import java.util.Vector;

public class SrISCSISessionsTargetViewTableModel
extends SrISCSISessionsTableModel {
    public SrISCSISessionsTargetViewTableModel(TargetNode targetNode) {
        this.initModel(targetNode);
    }

    protected void initModel(TargetNode targetNode) {
        this.removeAllRows();
        ArrayList targetSessions = targetNode.getISCSISessions();
        for (int index = 0; index < targetSessions.size(); ++index) {
            ISCSISessionNode sessionNode = (ISCSISessionNode)targetSessions.get(index);
            this.addSessionNodeToTable(sessionNode);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    protected void addSessionNodeToTable(ISCSISessionNode iscsiSessionNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(iscsiSessionNode.getStub());
        rowData.addElement(iscsiSessionNode.getParentStub());
        rowData.addElement(iscsiSessionNode.getVswitch());
        rowData.addElement(iscsiSessionNode.getInitiatorAlias());
        rowData.addElement(iscsiSessionNode.getInitiatorName());
        rowData.addElement(iscsiSessionNode.getISID());
        rowData.addElement(iscsiSessionNode.getTargetAlias());
        rowData.addElement(iscsiSessionNode.getTargetName());
        rowData.addElement(iscsiSessionNode.getTSIH());
        rowData.addElement(iscsiSessionNode.getType());
        String identityAlias = iscsiSessionNode.getIdentityAlias();
        if (identityAlias.startsWith("RemoteInitiatorDR")) {
            rowData.addElement("RemoteInitiatorDR");
        } else {
            rowData.addElement(iscsiSessionNode.getIdentityAlias());
        }
        rowData.addElement(null);
        rowData.addElement(null);
        this.m_allISCSISessionsNodes.add(iscsiSessionNode);
        this.addRowQuetly(rowData.toArray(), -1);
    }

    @Override
    public void iscsiSessionCreated(ISCSISessionNode iscsiSessionNode) {
        if (!iscsiSessionNode.isDiscovery()) {
            super.iscsiSessionCreated(iscsiSessionNode);
        }
    }
}

