/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.show;

import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.iscsi.session.show.ISCSISessionsTableHeader;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.util.types.constants.SessionTypeConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.HashMap;
import java.util.Vector;

public abstract class SrISCSISessionsTableModel
extends SrTableModel
implements ISCSISessionsListener,
VSwitchListener {
    protected Vector m_allISCSISessionsNodes = new Vector();

    protected SrISCSISessionsTableModel() {
        super(new SrDefaultTableColumns(ISCSISessionsTableHeader.getColumnNames()));
    }

    @Override
    public void removeListeners() {
        ISCSISessionsManager.getInstance().removeISCSISessionsListener(this);
        VSwitchManager.getInstance().removeVSwitchListener(this);
    }

    @Override
    public void addListeners() {
        ISCSISessionsManager.getInstance().addISCSISessionsListener(this);
        VSwitchManager.getInstance().addVSwitchListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int initiatorNameIndex = this.getColumnIndex(ISCSISessionsTableHeader.INITIATOR_NAME.getColumnName());
        if (col == initiatorNameIndex) {
            return true;
        }
        return super.isCellEditable(row, col);
    }

    public Vector getISCSISessionsTableNodes() {
        return this.m_allISCSISessionsNodes;
    }

    public void iscsiSessionCreated(ISCSISessionNode iscsiSessionNode) {
        if (!this.alreadyExistedInTable(iscsiSessionNode)) {
            this.addSessionNodeToTable(iscsiSessionNode);
            this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
        }
    }

    protected void addSessionNodeToTable(ISCSISessionNode iscsiSessionNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(iscsiSessionNode.getStub());
        rowData.addElement(iscsiSessionNode.getParentStub());
        rowData.addElement(iscsiSessionNode.getVswitch());
        rowData.addElement(iscsiSessionNode.getInitiatorAlias());
        rowData.addElement(iscsiSessionNode.getInitiatorName());
        rowData.addElement(iscsiSessionNode.getISID());
        rowData.addElement(iscsiSessionNode.getTargetAlias());
        rowData.addElement(iscsiSessionNode.getTargetName());
        rowData.addElement(iscsiSessionNode.getTSIH());
        rowData.addElement(iscsiSessionNode.getType());
        rowData.addElement(iscsiSessionNode.getIdentityAlias());
        rowData.addElement(null);
        rowData.addElement(null);
        this.m_allISCSISessionsNodes.add(iscsiSessionNode);
        this.addRowQuetly(rowData.toArray(), -1);
    }

    protected void removeFromTable(ISCSISessionNode iscsiSessionNode) {
        int size = this.getRowCount();
        int stubCol = this.getColumnIndex(ISCSISessionsTableHeader.SESSION_STUB.getColumnName());
        for (int i = size - 1; i >= 0; --i) {
            Object stub = this.getValueAt(i, stubCol);
            if (!((ISCSISession)iscsiSessionNode.getStub()).equals(stub)) continue;
            this.removeRow(i);
            this.m_allISCSISessionsNodes.remove(iscsiSessionNode);
            break;
        }
    }

    private void refreshTableData(ISCSISessionNode iscsiSessionNode, HashMap nodeValues) {
        int size = this.getRowCount();
        int stubCol = this.getColumnIndex(ISCSISessionsTableHeader.SESSION_STUB.getColumnName());
        int initiatorAliasCol = this.getColumnIndex(ISCSISessionsTableHeader.INITIATOR_ALIAS.getColumnName());
        int targetAliasCol = this.getColumnIndex(ISCSISessionsTableHeader.TARGET_ALIAS.getColumnName());
        int typeCol = this.getColumnIndex(ISCSISessionsTableHeader.TYPE.getColumnName());
        int authenticationCol = this.getColumnIndex(ISCSISessionsTableHeader.AUTHENTICATION.getColumnName());
        for (int i = 0; i < size; ++i) {
            Object stub = this.getValueAt(i, stubCol);
            if (!((ISCSISession)iscsiSessionNode.getStub()).equals(stub)) continue;
            Object val = nodeValues.get(ClientParameterCode.ISCSI_SESSION_INITIATOR_ALIAS);
            if (val != null) {
                String initiatorAlias = (String)val;
                this.setValueAt(initiatorAlias, i, initiatorAliasCol);
            }
            if ((val = nodeValues.get(ClientParameterCode.ISCSI_SESSION_TARGET_ALIAS)) != null) {
                String targetAlias = (String)val;
                this.setValueAt(targetAlias, i, targetAliasCol);
            }
            if ((val = nodeValues.get(ClientParameterCode.ISCSI_SESSION_TYPE)) != null) {
                SessionTypeConstant type = (SessionTypeConstant)val;
                this.setValueAt(type, i, typeCol);
            }
            if ((val = nodeValues.get(ClientParameterCode.ISCSI_SESSION_AUTHENTICATION)) == null) break;
            Credentials authentication = (Credentials)val;
            this.setValueAt(authentication, i, authenticationCol);
            break;
        }
    }

    public Object getSelectedSessionStub(int selectedRow) {
        int stubCol = this.getColumnIndex(ISCSISessionsTableHeader.SESSION_STUB.getColumnName());
        Object selectedSessionStub = this.getValueAt(selectedRow, stubCol);
        return selectedSessionStub;
    }

    private boolean alreadyExistedInTable(ISCSISessionNode iscsiSessionNode) {
        boolean reply = false;
        int size = this.getRowCount();
        int stubCol = this.getColumnIndex(ISCSISessionsTableHeader.SESSION_STUB.getColumnName());
        for (int i = 0; i < size; ++i) {
            Object stub = this.getValueAt(i, stubCol);
            if (!((ISCSISession)iscsiSessionNode.getStub()).equals(stub)) continue;
            reply = true;
            break;
        }
        return reply;
    }

    @Override
    public void iscsiSessionCreated(ISCSISessionEvent e) {
    }

    @Override
    public void iscsiSessionRemoved(ISCSISessionEvent e) {
        this.removeFromTable(e.getISCSISessionNode());
    }

    @Override
    public void iscsiSessionChanged(ISCSISessionEvent e) {
        this.refreshTableData(e.getISCSISessionNode(), e.getValuesMap());
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        int rows = this.getRowCount();
        int vswitchCol = this.getColumnIndex(ISCSISessionsTableHeader.VSWITCH_STUB.getColumnName());
        int vswitchNameCol = this.getColumnIndex(ISCSISessionsTableHeader.VSWITCH.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object vswitchRowStub = this.getValueAt(i, vswitchCol);
            VSwitchNode vswitchNode = (VSwitchNode)this.getValueAt(i, vswitchNameCol);
            if (!vswitchRowStub.equals(e.getStub())) continue;
            String name = e.getName();
            if (name == null || name.equalsIgnoreCase(vswitchNode.getName())) break;
            this.setValueAt(name, i, vswitchNameCol);
            break;
        }
    }
}

