/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.show;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.show.SrISCSISessionsTableModel;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsListener;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionEvent;
import com.sanrad.nms.client.gui.iscsi.session.show.ISCSISessionsTableHeader;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.RemoteTargetFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.RemoteTargetLoginStatusConstant;
import java.util.ArrayList;
import java.util.Vector;

public class SrISCSISessionsRemoteTargetViewTableModel
extends SrISCSISessionsTableModel
implements SrISCSIRemoteTargetsListener {
    private SrISCSIRemoteTargetNode m_remoteTargetNode;

    public SrISCSISessionsRemoteTargetViewTableModel(SrISCSIRemoteTargetNode remoteTargetNode) {
        this.m_remoteTargetNode = remoteTargetNode;
        this.initModel();
    }

    protected void initModel() {
        this.removeAllRows();
        ArrayList remoteTargetSessions = this.m_remoteTargetNode.getISCSISessions();
        for (int index = 0; index < remoteTargetSessions.size(); ++index) {
            ISCSISessionNode sessionNode = (ISCSISessionNode)remoteTargetSessions.get(index);
            this.addSessionNodeToTable(sessionNode);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    @Override
    protected void addSessionNodeToTable(ISCSISessionNode iscsiSessionNode) {
        Vector<Object> rowData = new Vector<Object>();
        VSwitch vswitch = iscsiSessionNode.getParentStub();
        VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitch);
        RemoteTargetLoginStatusConstant loginStatus = this.m_remoteTargetNode.getLoginStatus(vswitchNode);
        RemoteTargetFailureTypeConstant failureType = this.m_remoteTargetNode.getFailureType(vswitchNode);
        rowData.addElement(iscsiSessionNode.getStub());
        rowData.addElement(iscsiSessionNode.getParentStub());
        rowData.addElement(iscsiSessionNode.getVswitch());
        rowData.addElement(iscsiSessionNode.getInitiatorAlias());
        rowData.addElement(iscsiSessionNode.getInitiatorName());
        rowData.addElement(iscsiSessionNode.getISID());
        rowData.addElement(iscsiSessionNode.getTargetAlias());
        rowData.addElement(iscsiSessionNode.getTargetName());
        rowData.addElement(iscsiSessionNode.getTSIH());
        rowData.addElement(iscsiSessionNode.getType());
        rowData.addElement(iscsiSessionNode.getIdentityAlias());
        rowData.addElement(iscsiSessionNode.getType());
        rowData.addElement(iscsiSessionNode.getIdentityAlias());
        rowData.addElement(loginStatus);
        rowData.addElement(failureType);
        this.m_allISCSISessionsNodes.add(iscsiSessionNode);
        this.addRowQuetly(rowData.toArray(), -1);
    }

    @Override
    public void iscsiSessionCreated(ISCSISessionEvent e) {
        e.getISCSISessionNode();
    }

    @Override
    public void iscsiRemoteTargetCreated(SrISCSIRemoteTargetEvent e) {
    }

    @Override
    public void iscsiRemoteTargetRemoved(SrISCSIRemoteTargetEvent e) {
    }

    @Override
    public void iscsiRemoteTargetChanged(SrISCSIRemoteTargetEvent e) {
        SrISCSIRemoteTargetNode eventNode = e.getISCSIRemoteTargetNode();
        if (eventNode.equals(this.m_remoteTargetNode)) {
            int size = this.getRowCount();
            int vswitchStubCol = this.getColumnIndex(ISCSISessionsTableHeader.VSWITCH_STUB.getColumnName());
            int loginStatusCol = this.getColumnIndex(ISCSISessionsTableHeader.STATUS.getColumnName());
            int failureReasonTypeCol = this.getColumnIndex(ISCSISessionsTableHeader.REASON.getColumnName());
            for (int i = 0; i < size; ++i) {
                VSwitch vswitch = (VSwitch)this.getValueAt(i, vswitchStubCol);
                VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitch);
                RemoteTargetLoginStatusConstant eventLoginStatus = eventNode.getLoginStatus(vswitchNode);
                RemoteTargetLoginStatusConstant currLoginStatus = (RemoteTargetLoginStatusConstant)this.getValueAt(i, loginStatusCol);
                RemoteTargetFailureTypeConstant eventFailureType = eventNode.getFailureType(vswitchNode);
                RemoteTargetFailureTypeConstant currFailureType = (RemoteTargetFailureTypeConstant)this.getValueAt(i, failureReasonTypeCol);
                if (!eventLoginStatus.equals(currLoginStatus)) {
                    this.setValueAt(currLoginStatus, i, loginStatusCol);
                }
                if (eventFailureType.equals(currFailureType)) continue;
                this.setValueAt(currFailureType, i, failureReasonTypeCol);
            }
        }
    }
}

