/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.show;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionsManager;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsManager;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.scsi.SrDeviceNode;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SessionTypeConstant;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ISCSISessionsManager
extends ElementManager {
    private static ISCSISessionsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiSessionCreatedInformer = new SrEventListenerManager.Informer<ISCSISessionsListener, ISCSISessionEvent>(){

        @Override
        public void inform(ISCSISessionsListener listener, ISCSISessionEvent event) {
            listener.iscsiSessionCreated(event);
        }
    };
    SrEventListenerManager.Informer iscsiSessionRemovedInformer = new SrEventListenerManager.Informer<ISCSISessionsListener, ISCSISessionEvent>(){

        @Override
        public void inform(ISCSISessionsListener listener, ISCSISessionEvent event) {
            listener.iscsiSessionRemoved(event);
        }
    };
    SrEventListenerManager.Informer iscsiSessionChangedInformer = new SrEventListenerManager.Informer<ISCSISessionsListener, ISCSISessionEvent>(){

        @Override
        public void inform(ISCSISessionsListener listener, ISCSISessionEvent event) {
            listener.iscsiSessionChanged(event);
        }
    };

    private ISCSISessionsManager() {
        ISCSIConnectionsManager.getInstance();
    }

    public static synchronized ISCSISessionsManager getInstance() {
        if (m_instance == null) {
            m_instance = new ISCSISessionsManager();
        }
        return m_instance;
    }

    public void addISCSISessionsListener(ISCSISessionsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSISessionsListener(ISCSISessionsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public Vector readAllISCSISessions(VSwitch vSwitch) {
        Vector<ISCSISessionNode> iscsiSessionsNodes = new Vector<ISCSISessionNode>();
        try {
            Vector<? extends ISCSISession> iscsiSessionsTable = vSwitch.getISCSISessionsTable();
            if (iscsiSessionsTable != null && !iscsiSessionsTable.isEmpty()) {
                for (int index = 0; index < iscsiSessionsTable.size(); ++index) {
                    ISCSISession row = iscsiSessionsTable.get(index);
                    ISCSISessionNode iscsiSessionNode = this.discoverSession(row);
                    iscsiSessionsNodes.addElement(iscsiSessionNode);
                }
            }
            ISCSIConnectionsManager.getInstance().readAllSessionsConnections(iscsiSessionsNodes);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSISessionsManager.onConnectionError("Failed to get ISCSI Sessions Table from the Server.");
        }
        return iscsiSessionsNodes;
    }

    private ISCSISessionNode initSessionNode(ISCSISession session) {
        ISCSISessionNode sessionNode = null;
        try {
            SessionDirectionConstant sessionDirection = session.getDirection();
            SessionTypeConstant sessionType = session.getType();
            sessionNode = sessionDirection.equals(SessionDirectionConstant.IN_BOUND) ? (sessionType.equals(SessionTypeConstant.DISCOVER) ? new ISCSISessionNode(session, session.getParentVSwitch(), session.getRemoteInitiator()) : new ISCSISessionNode(session, session.getParentVSwitch(), session.getRemoteInitiator(), session.getLocalTarget())) : new ISCSISessionNode(session, session.getParentVSwitch(), session.getLocalInitiator(), session.getRemoteTarget());
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSISessionsManager.onConnectionError("Failed to init session node.");
        }
        return sessionNode;
    }

    public ISCSISessionNode discoverSession(ISCSISession session) {
        ISCSISessionNode sessionNode = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(session);
        if (sessionNode == null) {
            try {
                sessionNode = this.initSessionNode(session);
                sessionNode.setInitiatorAlias(session.getInitiatorAlias());
                sessionNode.setInitiatorName(session.getInitiatorName());
                sessionNode.setISID(session.getISID());
                sessionNode.setTargetAlias(session.getTargetAlias());
                sessionNode.setTargetName(session.getTargetName());
                sessionNode.setTSIH(session.getTSIH());
                sessionNode.setType(session.getType());
                sessionNode.setIdentityAlias(session.getIdentityAlias());
                sessionNode.setDirection(session.getDirection());
                SystemRootNode.getInstance().putRefAndStub(session, sessionNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                ISCSISessionsManager.onConnectionError("Failed to discover session.");
            }
        }
        if (!sessionNode.isDiscovery() && !sessionNode.isInbound()) {
            LogicObject remoteTargetStub = sessionNode.getTargetStub();
            SrISCSIRemoteTargetNode remoteTargetNode = (SrISCSIRemoteTargetNode)SystemRootNode.getInstance().getRefByStub(remoteTargetStub);
            if (remoteTargetNode != null) {
                remoteTargetNode.addISCSISession(sessionNode);
            }
        }
        return sessionNode;
    }

    protected ISCSISessionNode initializeSessionNode(ISCSISession element, HashMap values, boolean isCreate) {
        Object initiatorAlias = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_INITIATOR_ALIAS, isCreate);
        Object initiatorName = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_INITIATOR_NAME, isCreate);
        Object isid = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_ISID, isCreate);
        Object targetAlias = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_TARGET_ALIAS, isCreate);
        Object targetName = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_TARGET_NAME, isCreate);
        Object tsih = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_TSIH, isCreate);
        Object type = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_TYPE, isCreate);
        Object identityAlias = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_AUTHENTICATION, isCreate);
        Object direction = this.getObjectForParam(values, ClientParameterCode.ISCSI_SESSION_DIRECTION, isCreate);
        ISCSISession session = null;
        try {
            session = element;
            if (direction == null && (direction = session.getDirection()) == null) {
                return null;
            }
            if (type == null) {
                type = session.getType();
            }
            ISCSISessionNode sessionNode = isCreate ? this.initSessionNode(session) : (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(session);
            sessionNode.setInitiatorAlias(initiatorAlias == null ? session.getInitiatorAlias() : (String)initiatorAlias);
            sessionNode.setInitiatorName(initiatorName == null ? session.getInitiatorName() : (String)initiatorName);
            sessionNode.setISID(isid == null ? session.getISID() : (String)isid);
            sessionNode.setTargetAlias(targetAlias == null ? session.getTargetAlias() : (String)targetAlias);
            sessionNode.setTargetName(targetName == null ? session.getTargetName() : (String)targetName);
            sessionNode.setTSIH(tsih == null ? session.getTSIH() : (Integer)tsih);
            sessionNode.setType((SessionTypeConstant)type);
            sessionNode.setIdentityAlias(identityAlias == null ? session.getIdentityAlias() : (String)identityAlias);
            sessionNode.setDirection((SessionDirectionConstant)direction);
            if (isCreate) {
                SystemRootNode.getInstance().putRefAndStub(element, sessionNode);
            }
            return sessionNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSISessionsManager.onConnectionError("Failed to create the session.");
            return null;
        }
    }

    public ArrayList readAllInitiatorSessions(ISCSIInitiator initiator) {
        ArrayList<ISCSISessionNode> sessionsNodes = new ArrayList<ISCSISessionNode>();
        try {
            ISCSISession[] sessions = initiator.getISCSISessions();
            if (sessions != null && sessions.length > 0) {
                for (int index = 0; index < sessions.length; ++index) {
                    ISCSISession session = sessions[index];
                    ISCSISessionNode sessionNode = this.discoverSession(session);
                    sessionsNodes.add(sessionNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSISessionsManager.onConnectionError("Failed to get initiator session from the Server.");
        }
        return sessionsNodes;
    }

    public ArrayList readAllRemoteTargetSessions(ISCSIRemoteTarget remoteTarget) {
        ArrayList<ISCSISessionNode> sessionsNodes = new ArrayList<ISCSISessionNode>();
        try {
            ISCSISession[] sessions = remoteTarget.getISCSISessions();
            if (sessions != null && sessions.length > 0) {
                for (int index = 0; index < sessions.length; ++index) {
                    ISCSISession session = sessions[index];
                    ISCSISessionNode sessionNode = this.discoverSession(session);
                    sessionsNodes.add(sessionNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSISessionsManager.onConnectionError("Failed to get remote target session from the Server.");
        }
        return sessionsNodes;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSISessionsManager: Session created");
        HashMap params = this.getParameterList(e);
        ISCSISession session = (ISCSISession)element;
        ISCSISessionNode sessionNode = this.initializeSessionNode(session, params, true);
        if (sessionNode != null) {
            LogicObject targetDeviceStub;
            VSwitchNode sessionVswitch = sessionNode.getVswitch();
            sessionVswitch.addISCSISessionNode(sessionNode);
            boolean isDiscoverySession = sessionNode.isDiscovery();
            if (!isDiscoverySession && (targetDeviceStub = sessionNode.getTargetStub()) != null) {
                SrDeviceNode targetDeviceNode = (SrDeviceNode)SystemRootNode.getInstance().getRefByStub(targetDeviceStub);
                if (targetDeviceNode == null) {
                    targetDeviceNode = sessionNode.isInbound() ? TargetManager.getInstance().discoverTarget((ISCSITarget)targetDeviceStub) : SrISCSIRemoteTargetsManager.getInstance().discoverRemoteTarget(null, (ISCSIRemoteTarget)targetDeviceStub);
                }
                targetDeviceNode.addISCSISession(sessionNode);
            }
            this.fireISCSISessionCreatedEvent(sessionNode);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSISessionsManager: session removed");
        ISCSISessionNode sessionNode = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(element);
        if (sessionNode != null) {
            VSwitchNode sessionVswitch = sessionNode.getVswitch();
            sessionVswitch.removeISCSISessionNode(sessionNode);
            boolean isDiscoverySession = sessionNode.isDiscovery();
            if (!isDiscoverySession) {
                SrDeviceNode targetDeviceNode = (SrDeviceNode)SystemRootNode.getInstance().getRefByStub(sessionNode.getTargetStub());
                if (targetDeviceNode != null) {
                    targetDeviceNode.removeISCSISession(sessionNode);
                }
                if (sessionNode.isInbound()) {
                    ISCSIRemoteInitiatorNode remoteInitiatorNode = (ISCSIRemoteInitiatorNode)SystemRootNode.getInstance().getRefByStub(sessionNode.getInitiatorStub());
                    if (remoteInitiatorNode != null) {
                        remoteInitiatorNode.removeInitiatorSessions(sessionNode);
                    }
                } else {
                    SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(sessionNode.getInitiatorStub());
                    initiatorNode.removeISCSISession(sessionNode);
                }
            }
            this.fireISCSISessionRemovedEvent(sessionNode);
            if (sessionNode.getConnections().size() == 0) {
                SystemRootNode.getInstance().removeRefAndIdByStub((RemoteObject)sessionNode.getStub());
            }
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSISessionsManager: session changed");
        HashMap params = this.getParameterList(e);
        ISCSISession session = (ISCSISession)element;
        ISCSISessionNode sessionNode = this.initializeSessionNode(session, params, false);
        this.fireISCSISessionChanged(sessionNode, params);
    }

    protected void fireISCSISessionCreatedEvent(ISCSISessionNode iscsiSessionNode) {
        ISCSISessionEvent event = new ISCSISessionEvent((Object)this, iscsiSessionNode, iscsiSessionNode.getValues());
        this.m_listeners.fireEvent(ISCSISessionsListener.class, event, this.iscsiSessionCreatedInformer);
    }

    protected void fireISCSISessionRemovedEvent(ISCSISessionNode iscsiSessionNode) {
        ISCSISessionEvent event = new ISCSISessionEvent((Object)this, iscsiSessionNode);
        this.m_listeners.fireEvent(ISCSISessionsListener.class, event, this.iscsiSessionRemovedInformer);
    }

    protected void fireISCSISessionChanged(ISCSISessionNode iscsiSessionNode, HashMap map) {
        ISCSISessionEvent event = new ISCSISessionEvent((Object)this, iscsiSessionNode, map);
        this.m_listeners.fireEvent(ISCSISessionsListener.class, event, this.iscsiSessionChangedInformer);
    }
}

