/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.session.show;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionNode;
import com.sanrad.nms.client.data.vswitch.TableRowNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SessionTypeConstant;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class ISCSISessionNode
extends TableRowNode<ISCSISession> {
    private HashMap m_values;
    private LogicObject m_targetStub;
    private LogicObject m_initiatorStub;
    private String m_initiatorAlias;
    private String m_initiatorName;
    private String m_isid;
    private String m_targetAlias;
    private String m_targetName;
    private Integer m_tsih;
    private SessionTypeConstant m_type;
    private String m_identityAlias;
    private SessionDirectionConstant m_direction;
    private Vector m_connections = new Vector();

    public ISCSISessionNode(ISCSISession stub, VSwitch parentStub, LogicObject initiatorStub) throws RemoteException {
        super(stub, parentStub);
        this.m_initiatorStub = initiatorStub;
    }

    public ISCSISessionNode(ISCSISession stub, VSwitch parentStub, LogicObject initiatorStub, LogicObject targetStub) throws RemoteException {
        this(stub, parentStub, initiatorStub);
        this.m_targetStub = targetStub;
    }

    @Override
    public String type() {
        return "ISCSI Session Node";
    }

    public void setInitiatorAlias(String initiatorAlias) {
        this.m_initiatorAlias = initiatorAlias;
    }

    public String getInitiatorAlias() {
        return this.m_initiatorAlias;
    }

    public void setInitiatorName(String initiatorName) {
        this.m_initiatorName = initiatorName;
    }

    public String getInitiatorName() {
        return this.m_initiatorName;
    }

    public void setISID(String isid) {
        this.m_isid = isid;
    }

    public String getISID() {
        return this.m_isid;
    }

    public void setTargetAlias(String targetAlias) {
        this.m_targetAlias = targetAlias;
    }

    public String getTargetAlias() {
        return this.m_targetAlias;
    }

    public void setTargetName(String targetName) {
        this.m_targetName = targetName;
    }

    public String getTargetName() {
        return this.m_targetName;
    }

    public void setTSIH(Integer tsih) {
        this.m_tsih = tsih;
    }

    public Integer getTSIH() {
        return this.m_tsih;
    }

    public void setType(SessionTypeConstant type) {
        this.m_type = type;
    }

    public SessionTypeConstant getType() {
        return this.m_type;
    }

    public void setIdentityAlias(String identityAlias) {
        this.m_identityAlias = identityAlias;
    }

    public String getIdentityAlias() {
        return this.m_identityAlias;
    }

    public void setDirection(SessionDirectionConstant direction) {
        this.m_direction = direction;
    }

    public boolean isInbound() {
        return this.getDirection().equals(SessionDirectionConstant.IN_BOUND);
    }

    public SessionDirectionConstant getDirection() {
        return this.m_direction;
    }

    public HashMap getValues() {
        return this.m_values;
    }

    public Vector getConnections() {
        return this.m_connections;
    }

    public void setConnections(Vector connections) {
        this.m_connections = connections;
    }

    public void addConnection(ISCSIConnectionNode connection) {
        if (!this.m_connections.contains(connection)) {
            this.m_connections.addElement(connection);
        }
    }

    public void removeConnection(ISCSIConnectionNode connection) {
        this.m_connections.remove(connection);
    }

    public VSwitchNode getVswitch() {
        VSwitchNode vswitch = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(this.getParentStub());
        return vswitch;
    }

    public LogicObject getTargetStub() {
        return this.m_targetStub;
    }

    public LogicObject getInitiatorStub() {
        return this.m_initiatorStub;
    }

    @Override
    public String toString() {
        return this.type();
    }

    public boolean isDiscovery() {
        SessionTypeConstant type = this.getType();
        return type.equals(SessionTypeConstant.DISCOVER);
    }
}

