/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsListener;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetsTableHeader;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public abstract class SrISCSIRemoteTargetsTableModel
extends SrTableModel
implements SrISCSIRemoteTargetsListener {
    protected SrISCSIRemoteTargetsTableModel(SrDefaultTableColumns columns) {
        super(columns);
    }

    @Override
    public void addListeners() {
        SrISCSIRemoteTargetsManager.getInstance().addISCSIRemoteTargetsListener(this);
    }

    @Override
    public void removeListeners() {
        SrISCSIRemoteTargetsManager.getInstance().removeISCSIRemoteTargetsListener(this);
    }

    @Override
    public void iscsiRemoteTargetCreated(SrISCSIRemoteTargetEvent e) {
        this.addRemoteTargetEntryToTable(e.getISCSIRemoteTargetNode());
    }

    @Override
    public void iscsiRemoteTargetChanged(SrISCSIRemoteTargetEvent e) {
        SrISCSIRemoteTargetNode remoteTargetNode = e.getISCSIRemoteTargetNode();
        if (!this.isRemoteTargetExistedInModel(remoteTargetNode) && this.canBeAddedToModel(remoteTargetNode)) {
            this.iscsiRemoteTargetCreated(e);
        } else {
            this.updateRemoteTargetEntry(remoteTargetNode);
        }
    }

    @Override
    public void iscsiRemoteTargetRemoved(SrISCSIRemoteTargetEvent e) {
        this.removeRemoteTargetEntryFromTable(e.getISCSIRemoteTargetNode());
    }

    protected abstract boolean canBeAddedToModel(SrISCSIRemoteTargetNode var1);

    protected void addRemoteTargetEntryToTable(SrISCSIRemoteTargetNode remoteTargetNode, String vswitchName) {
        this.addRow(this.buildRTargetRow(remoteTargetNode, vswitchName));
    }

    private Object[] buildRTargetRow(SrISCSIRemoteTargetNode remoteTargetNode, String vswitchName) {
        Object[] rowData = new Object[SrISCSIRemoteTargetsTableHeader.getColumnNames().size()];
        rowData[SrISCSIRemoteTargetsTableHeader.REMOTE_TARGET_NODE.getIndexInModel()] = remoteTargetNode;
        rowData[SrISCSIRemoteTargetsTableHeader.REMOTE_TARGET_ALIAS.getIndexInModel()] = remoteTargetNode.getAlias();
        rowData[SrISCSIRemoteTargetsTableHeader.REMOTE_TARGET_IS_DISCOVERED.getIndexInModel()] = remoteTargetNode.getIsDiscovered();
        rowData[SrISCSIRemoteTargetsTableHeader.REMOTE_TARGET_IS_CONFIGURED.getIndexInModel()] = remoteTargetNode.getIsConfigured();
        rowData[SrISCSIRemoteTargetsTableHeader.REMOTE_TARGET_NUM_OF_PORTALS.getIndexInModel()] = remoteTargetNode.getNumberOfPortals(vswitchName);
        rowData[SrISCSIRemoteTargetsTableHeader.REMOTE_TARGET_LOGIN_STATUS.getIndexInModel()] = remoteTargetNode.getLoginStatus(vswitchName);
        return rowData;
    }

    protected void addRemoteTargetEntryToTable(SrISCSIRemoteTargetNode remoteTargetNode) {
        this.addRemoteTargetEntryToTable(remoteTargetNode, null);
    }

    protected void updateRemoteTargetEntry(SrISCSIRemoteTargetNode remoteTargetNode, String vswitchName) {
        int row = this.findRow(remoteTargetNode);
        if (row > -1) {
            this.editRow(row, this.buildRTargetRow(remoteTargetNode, vswitchName));
        }
    }

    protected void updateRemoteTargetEntry(SrISCSIRemoteTargetNode remoteTargetNode) {
        this.updateRemoteTargetEntry(remoteTargetNode, null);
    }

    protected void removeRemoteTargetEntryFromTable(SrISCSIRemoteTargetNode remoteTargetNode) {
        int row = this.findRow(remoteTargetNode);
        if (row > -1) {
            this.removeRow(row);
        }
    }

    protected boolean isRemoteTargetExistedInModel(SrISCSIRemoteTargetNode remoteTargetNode) {
        return this.findRow(remoteTargetNode) > -1;
    }

    protected void initModel(ClusterNode clusterNode) {
        this.removeAllRows();
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index);
            this.initModel(true, vswitchNode, false);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    protected void initModel(VSwitchNode vswitchNode) {
        this.removeAllRows();
        this.initModel(false, vswitchNode, true);
    }

    protected void initModel(boolean isClusterView, VSwitchNode vswitchNode, boolean fireRowsInserted) {
        SrInitiatorNode[] vswitchInitiators = vswitchNode.getISCSIInitiators();
        for (int index1 = 0; index1 < vswitchInitiators.length; ++index1) {
            SrInitiatorNode initiatorNode = vswitchInitiators[index1];
            SrISCSIRemoteTargetNode[] initiatorRemoteTargets = initiatorNode.getConnectedTargets();
            for (int index2 = 0; index2 < initiatorRemoteTargets.length; ++index2) {
                SrISCSIRemoteTargetNode remoteTargetNode = initiatorRemoteTargets[index2];
                if (this.isRemoteTargetExistedInModel(remoteTargetNode)) continue;
                this.addRemoteTargetEntryToTable(remoteTargetNode, isClusterView ? null : vswitchNode.getName());
            }
        }
        if (fireRowsInserted) {
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    public void updateRemoteTargetNumOfPortals(SrISCSIRemoteTargetNode remoteTargetNode) {
        this.updateRemoteTargetEntry(remoteTargetNode);
    }
}

