/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalsManager;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsListener;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrEventListenerManager;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SrISCSIRemoteTargetsManager
extends ElementManager {
    private static SrISCSIRemoteTargetsManager s_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiRemoteTargetCreatedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteTargetsListener, SrISCSIRemoteTargetEvent>(){

        @Override
        public void inform(SrISCSIRemoteTargetsListener listener, SrISCSIRemoteTargetEvent event) {
            listener.iscsiRemoteTargetCreated(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteTargetChangedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteTargetsListener, SrISCSIRemoteTargetEvent>(){

        @Override
        public void inform(SrISCSIRemoteTargetsListener listener, SrISCSIRemoteTargetEvent event) {
            listener.iscsiRemoteTargetChanged(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteTargetRemovedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteTargetsListener, SrISCSIRemoteTargetEvent>(){

        @Override
        public void inform(SrISCSIRemoteTargetsListener listener, SrISCSIRemoteTargetEvent event) {
            listener.iscsiRemoteTargetRemoved(event);
        }
    };

    private SrISCSIRemoteTargetsManager() {
    }

    public static synchronized SrISCSIRemoteTargetsManager getInstance() {
        if (s_instance == null) {
            s_instance = new SrISCSIRemoteTargetsManager();
        }
        return s_instance;
    }

    public void addISCSIRemoteTargetsListener(SrISCSIRemoteTargetsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSIRemoteTargetsListener(SrISCSIRemoteTargetsListener listener) {
        this.m_listeners.remove(listener);
    }

    public ArrayList getRemoteTargetsNodes(ISCSIInitiator initiator, ISCSIRemoteTarget[] remoteTargets) {
        ArrayList<SrISCSIRemoteTargetNode> remoteTargetNodes = new ArrayList<SrISCSIRemoteTargetNode>();
        for (int index = 0; index < remoteTargets.length; ++index) {
            ISCSIRemoteTarget remoteTarget = remoteTargets[index];
            SrISCSIRemoteTargetNode remoteTargetNode = (SrISCSIRemoteTargetNode)SystemRootNode.getInstance().getRefByStub(remoteTarget);
            if (remoteTargetNode == null) {
                remoteTargetNode = this.discoverRemoteTarget(initiator, remoteTarget);
            }
            remoteTargetNodes.add(remoteTargetNode);
        }
        return remoteTargetNodes;
    }

    public ArrayList readAllInitiatorRemoteTargets(ISCSIInitiator initiator) {
        ArrayList<SrISCSIRemoteTargetNode> remoteTargetNodes = new ArrayList<SrISCSIRemoteTargetNode>();
        try {
            ISCSIRemoteTarget[] remoteTargets = initiator.getISCSIRemoteTargets();
            if (remoteTargets != null && remoteTargets.length > 0) {
                for (int index = 0; index < remoteTargets.length; ++index) {
                    ISCSIRemoteTarget remoteTarget = remoteTargets[index];
                    SrISCSIRemoteTargetNode remoteTargetNode = this.discoverRemoteTarget(initiator, remoteTarget);
                    remoteTargetNodes.add(remoteTargetNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            SrISCSIRemoteTargetsManager.onConnectionError("Failed to get initiator remote targets table from the Server.");
        }
        return remoteTargetNodes;
    }

    public SrISCSIRemoteTargetNode discoverRemoteTarget(ISCSIInitiator initiator, ISCSIRemoteTarget remoteTarget) {
        SrISCSIRemoteTargetNode remoteTargetNode = (SrISCSIRemoteTargetNode)SystemRootNode.getInstance().getRefByStub(remoteTarget);
        if (remoteTargetNode == null) {
            try {
                remoteTargetNode = new SrISCSIRemoteTargetNode(remoteTarget, remoteTarget.getAlias());
                remoteTargetNode.setName(remoteTarget.getName());
                remoteTargetNode.setIsConfigured(remoteTarget.isConfigured());
                remoteTargetNode.setIsDiscovered(remoteTarget.isDiscovered());
                remoteTargetNode.setCHAPUserName(remoteTarget.getCHAPUserName());
                remoteTargetNode.setLoginStatus(remoteTarget.getLoginStatus());
                remoteTargetNode.setFailureType(remoteTarget.getFailureType());
                remoteTargetNode.setNumberOfPortals(remoteTarget.getNumberOfPortals());
                remoteTargetNode.setStatus(SrISCSIRemoteTargetsManager.getSeverity(remoteTarget.getPropagatedState()));
                if (initiator == null) {
                    Object[] connectedInitiators = remoteTarget.getAllConnectedInitiators();
                    remoteTargetNode.setConnectedInititors(connectedInitiators);
                }
                SystemRootNode.getInstance().putRefAndStub(remoteTarget, remoteTargetNode);
                List<SrISCSIRemoteTargetPortalNode> portalsNodes = SrISCSIRemoteTargetPortalsManager.getInstance().readAllRemoteTargetPortals(remoteTarget);
                remoteTargetNode.setPortals(portalsNodes);
                ArrayList sessionsNodes = ISCSISessionsManager.getInstance().readAllRemoteTargetSessions(remoteTarget);
                remoteTargetNode.setISCSISessions(sessionsNodes);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                SrISCSIRemoteTargetsManager.onConnectionError("Failed to discover initiator remote target.");
            }
        }
        if (initiator != null) {
            remoteTargetNode.addConnectedInititor(initiator);
        } else {
            this.setInitiatorsWithCreatedRemoteTarget(remoteTargetNode);
        }
        return remoteTargetNode;
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    protected SrISCSIRemoteTargetNode initializeRemoteTargetNode(ISCSIRemoteTarget element, HashMap values, boolean isCreate) {
        try {
            Object nameObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_NAME, isCreate);
            Object aliasObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_ALIAS, isCreate);
            Object isConfiguredObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_IS_CONFIGURED, isCreate);
            Object isDiscoveredObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_IS_DISCOVERED, isCreate);
            Object loginStatusObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_LOGIN_STATUS, isCreate);
            Object failureTypeObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_FAILURE_TYPE, isCreate);
            Object numOfPortalsObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, isCreate);
            Object chapUserNameObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, isCreate);
            Object[] connectedInitiatorsObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_CONNECTED_INITIATORS, isCreate);
            Object propagatedState = this.getObjectForParam(values, "Missing code - ClientParameterCode.PROPAGATED_STATE", isCreate);
            ISCSIRemoteTarget remoteTarget = element;
            if (connectedInitiatorsObj == null) {
                connectedInitiatorsObj = remoteTarget.getAllConnectedInitiators();
            }
            if (propagatedState == null) {
                propagatedState = remoteTarget.getPropagatedState();
            }
            Object[] connectedInitiators = connectedInitiatorsObj;
            SrISCSIRemoteTargetNode remoteTargetNode = isCreate ? new SrISCSIRemoteTargetNode(remoteTarget, remoteTarget.getAlias()) : (SrISCSIRemoteTargetNode)SystemRootNode.getInstance().getRefByStub(element);
            if (remoteTargetNode != null) {
                remoteTargetNode.setConnectedInititors(connectedInitiators);
                remoteTargetNode.setName(nameObj == null ? remoteTarget.getName() : (String)nameObj);
                remoteTargetNode.setAlias(aliasObj == null ? remoteTarget.getAlias() : (String)aliasObj);
                remoteTargetNode.setIsConfigured(isConfiguredObj == null ? remoteTarget.isConfigured() : (Boolean)isConfiguredObj);
                remoteTargetNode.setIsDiscovered(isDiscoveredObj == null ? remoteTarget.isDiscovered() : (Boolean)isDiscoveredObj);
                remoteTargetNode.setLoginStatus(loginStatusObj == null ? remoteTarget.getLoginStatus() : (HashMap)loginStatusObj);
                remoteTargetNode.setFailureType(failureTypeObj == null ? remoteTarget.getFailureType() : (HashMap)failureTypeObj);
                remoteTargetNode.setNumberOfPortals(numOfPortalsObj == null ? remoteTarget.getNumberOfPortals() : (BigInteger)numOfPortalsObj);
                remoteTargetNode.setCHAPUserName(chapUserNameObj == null ? remoteTarget.getCHAPUserName() : (String)chapUserNameObj);
                remoteTargetNode.setStatus(SrISCSIRemoteTargetsManager.getSeverity((AlarmSeverity)propagatedState));
                this.setInitiatorsWithCreatedRemoteTarget(remoteTargetNode);
            }
            if (isCreate) {
                SystemRootNode.getInstance().putRefAndStub(element, remoteTargetNode);
            }
            return remoteTargetNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "ISCSISessionsManager: failed to create an ISCSI remote target.");
            SrISCSIRemoteTargetsManager.onConnectionError();
            return null;
        }
    }

    private void setInitiatorsWithCreatedRemoteTarget(SrISCSIRemoteTargetNode remoteTargetNode) {
        SrInitiatorNode[] connectedInititors = remoteTargetNode.getConnectedInititors();
        for (int index = 0; index < connectedInititors.length; ++index) {
            SrInitiatorNode initiatorNode = connectedInititors[index];
            initiatorNode.addConnectedTarget(remoteTargetNode);
        }
    }

    public boolean canBeDeleted(SrISCSIRemoteTargetNode remoteTargetNode, StringBuffer reason) {
        boolean isDisconnected = remoteTargetNode.isDisconnected();
        boolean isConfigured = remoteTargetNode.isConfigured();
        String name = remoteTargetNode.getName();
        if (!isDisconnected) {
            if (reason != null) {
                reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.ISCSI_REMOTE_TARGET_POPUP_CANNOT_DELETE_TARGET_CONNECTED, name));
            }
        } else if (!isConfigured && reason != null) {
            reason.append(ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.ISCSI_REMOTE_TARGET_POPUP_CANNOT_DELETE_TARGET_NOT_CONFIGURED, name));
        }
        return isDisconnected && isConfigured;
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteTargetsManager: remote target created");
        HashMap params = this.getParameterList(e);
        ISCSIRemoteTarget remoteTarget = (ISCSIRemoteTarget)element;
        SrISCSIRemoteTargetNode remoteTargetNode = this.initializeRemoteTargetNode(remoteTarget, params, true);
        this.fireISCSIRemoteTargetCreated(remoteTargetNode);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteTargetsManager: remote target changed");
        HashMap params = this.getParameterList(e);
        ISCSIRemoteTarget remoteTarget = (ISCSIRemoteTarget)element;
        SrISCSIRemoteTargetNode remoteTargetNode = this.initializeRemoteTargetNode(remoteTarget, params, false);
        this.fireISCSIRemoteTargetChanged(remoteTargetNode, params);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        ISCSIRemoteTarget remoteTarget = (ISCSIRemoteTarget)e.getElement();
        if (this.isClusterInDiscovery(remoteTarget)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteTargetsManager: remote target removed");
        SrISCSIRemoteTargetNode remoteTargetNode = (SrISCSIRemoteTargetNode)SystemRootNode.getInstance().getRefByStub(remoteTarget);
        this.removeFromInitiators(remoteTargetNode);
        this.fireISCSIRemoteTargetRemoved(remoteTargetNode);
        SystemRootNode.getInstance().removeRefAndIdByStub(remoteTarget);
    }

    private void removeFromInitiators(SrISCSIRemoteTargetNode remoteTargetNode) {
        SrInitiatorNode[] initiatorNodes = remoteTargetNode.getConnectedInititors();
        for (int index = 0; index < initiatorNodes.length; ++index) {
            SrInitiatorNode initiatorNode = initiatorNodes[index];
            if (initiatorNode == null) continue;
            initiatorNode.removeConnectedTarget(remoteTargetNode);
        }
    }

    protected void fireISCSIRemoteTargetCreated(SrISCSIRemoteTargetNode remoteTargetNode) {
        SrISCSIRemoteTargetEvent event = new SrISCSIRemoteTargetEvent((Object)this, remoteTargetNode);
        this.m_listeners.fireEvent(SrISCSIRemoteTargetsListener.class, event, this.iscsiRemoteTargetCreatedInformer);
    }

    protected void fireISCSIRemoteTargetChanged(SrISCSIRemoteTargetNode remoteTargetNode, HashMap params) {
        SrISCSIRemoteTargetEvent event = new SrISCSIRemoteTargetEvent((Object)this, remoteTargetNode, params);
        this.m_listeners.fireEvent(SrISCSIRemoteTargetsListener.class, event, this.iscsiRemoteTargetChangedInformer);
    }

    protected void fireISCSIRemoteTargetRemoved(SrISCSIRemoteTargetNode remoteTargetNode) {
        SrISCSIRemoteTargetEvent event = new SrISCSIRemoteTargetEvent((Object)this, remoteTargetNode);
        this.m_listeners.fireEvent(SrISCSIRemoteTargetsListener.class, event, this.iscsiRemoteTargetRemovedInformer);
    }

    public List<SrISCSIRemoteTargetNode> getAllRemoteTargetNodes() {
        ArrayList<SrISCSIRemoteTargetNode> allSystemRemoteTargets = new ArrayList<SrISCSIRemoteTargetNode>();
        List<VSwitchNode> allVswitches = SystemRootNode.getInstance().findAllInSubTree(VSwitchNode.class);
        for (VSwitchNode vs : allVswitches) {
            SrInitiatorNode[] vswitchInitiators;
            for (SrInitiatorNode initiator : vswitchInitiators = vs.getISCSIInitiators()) {
                SrISCSIRemoteTargetNode[] remoteTargets = initiator.getConnectedTargets();
                allSystemRemoteTargets.addAll(Arrays.asList(remoteTargets));
            }
        }
        return allSystemRemoteTargets;
    }
}

