/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetPortalEvent;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetPortalsTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrISCSIRemoteTargetPortalsTableModel
extends SrTableModel {
    private SrISCSIRemoteTargetNode m_remoteTargetNode;
    private VSwitchNode m_byVswitchNode;

    public SrISCSIRemoteTargetPortalsTableModel(SrTableColumns columns) {
        super(columns);
    }

    public SrISCSIRemoteTargetPortalsTableModel(SrTableColumns columns, SrISCSIRemoteTargetNode remoteTargetNode, VSwitchNode vswitchNode) {
        super(columns);
        this.m_remoteTargetNode = remoteTargetNode;
        this.m_byVswitchNode = vswitchNode;
        if (this.m_byVswitchNode != null) {
            this.initModel(this.m_byVswitchNode.getName());
        } else {
            this.initModel(null);
        }
    }

    public void iscsiRemoteTargetPortalCreated(SrISCSIRemoteTargetPortalEvent e) {
        SrISCSIRemoteTargetPortalNode remoteTargetPortalNode = e.getISCSIRemoteTargetPortalNode();
        if (!this.isRemoteTargetPortalExistedInModel(remoteTargetPortalNode)) {
            if (this.m_byVswitchNode != null) {
                if (remoteTargetPortalNode.isConnectedToVSwitch(this.m_byVswitchNode.getName())) {
                    this.addRemoteTargetPortalEntryToTable(remoteTargetPortalNode);
                    this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
                }
            } else {
                this.addRemoteTargetPortalEntryToTable(remoteTargetPortalNode);
                this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
            }
        }
    }

    public void iscsiRemoteTargetPortalChanged(SrISCSIRemoteTargetPortalEvent e) {
        SrISCSIRemoteTargetPortalNode remoteTargetPortalNode = e.getISCSIRemoteTargetPortalNode();
        if (!this.isRemoteTargetPortalExistedInModel(remoteTargetPortalNode)) {
            if (this.m_byVswitchNode != null && remoteTargetPortalNode.isConnectedToVSwitch(this.m_byVswitchNode.getName())) {
                this.iscsiRemoteTargetPortalCreated(e);
            }
        } else if (this.m_byVswitchNode != null) {
            if (remoteTargetPortalNode.isConnectedToVSwitch(this.m_byVswitchNode.getName())) {
                this.updateRemoteTargetPortalEntry(remoteTargetPortalNode);
            } else {
                this.iscsiRemoteTargetPortalRemoved(e);
            }
        } else {
            this.updateRemoteTargetPortalEntry(remoteTargetPortalNode);
        }
    }

    public void iscsiRemoteTargetPortalRemoved(SrISCSIRemoteTargetPortalEvent e) {
        SrISCSIRemoteTargetPortalNode remoteTargetPortalNode = e.getISCSIRemoteTargetPortalNode();
        this.removeRemoteTargetPortalEntryFromTable(remoteTargetPortalNode);
    }

    private void initModel(String vswitchName) {
        this.removeAllRows();
        SrISCSIRemoteTargetPortalNode[] portals = this.m_remoteTargetNode.getPortals(vswitchName);
        for (int index = 0; index < portals.length; ++index) {
            SrISCSIRemoteTargetPortalNode remoteTargetPortalNode = portals[index];
            this.addRemoteTargetPortalEntryToTable(remoteTargetPortalNode);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    protected void addRemoteTargetPortalEntryToTable(SrISCSIRemoteTargetPortalNode remoteTargetPortalNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(remoteTargetPortalNode.getStub());
        rowData.addElement(remoteTargetPortalNode.getRemoteTarget().getStub());
        rowData.addElement(remoteTargetPortalNode.getIP());
        rowData.addElement(remoteTargetPortalNode.getPort());
        rowData.addElement(remoteTargetPortalNode.getGroupTag());
        this.addRow(rowData.toArray());
    }

    private void updateRemoteTargetPortalEntry(SrISCSIRemoteTargetPortalNode remoteTargetPortalNode) {
        int rowCount = this.getRowCount();
        int portalStubCol = this.getColumnIndex(SrISCSIRemoteTargetPortalsTableHeader.PORTAL_STUB.getColumnName());
        int ipCol = this.getColumnIndex(SrISCSIRemoteTargetPortalsTableHeader.PORTAL_IP.getColumnName());
        int portCol = this.getColumnIndex(SrISCSIRemoteTargetPortalsTableHeader.PORTAL_PORT.getColumnName());
        int groupTagCol = this.getColumnIndex(SrISCSIRemoteTargetPortalsTableHeader.PORTAL_GROUP_TAG.getColumnName());
        for (int index = 0; index < rowCount; ++index) {
            ISCSIRemoteTargetPortal portalStub = (ISCSIRemoteTargetPortal)this.getValueAt(index, portalStubCol);
            if (!((ISCSIRemoteTargetPortal)remoteTargetPortalNode.getStub()).equals(portalStub)) continue;
            this.setValueAt(remoteTargetPortalNode.getIP(), index, ipCol);
            this.setValueAt(remoteTargetPortalNode.getPort(), index, portCol);
            this.setValueAt(remoteTargetPortalNode.getGroupTag(), index, groupTagCol);
            break;
        }
    }

    private void removeRemoteTargetPortalEntryFromTable(SrISCSIRemoteTargetPortalNode remoteTargetPortalNode) {
        int rowCount = this.getRowCount();
        int portalStubCol = this.getColumnIndex(SrISCSIRemoteTargetPortalsTableHeader.PORTAL_STUB.getColumnName());
        for (int index = rowCount - 1; index >= 0; --index) {
            ISCSIRemoteTargetPortal portalStub = (ISCSIRemoteTargetPortal)this.getValueAt(index, portalStubCol);
            if (!((ISCSIRemoteTargetPortal)remoteTargetPortalNode.getStub()).equals(portalStub)) continue;
            this.removeRow(index);
        }
    }

    protected boolean isRemoteTargetPortalExistedInModel(SrISCSIRemoteTargetPortalNode remoteTargetPortalNode) {
        int size = this.getRowCount();
        int portalStubCol = this.getColumnIndex(SrISCSIRemoteTargetPortalsTableHeader.PORTAL_STUB.getColumnName());
        for (int index = 0; index < size; ++index) {
            ISCSIRemoteTargetPortal portalStub = (ISCSIRemoteTargetPortal)this.getValueAt(index, portalStubCol);
            if (!((ISCSIRemoteTargetPortal)remoteTargetPortalNode.getStub()).equals(portalStub)) continue;
            return true;
        }
        return false;
    }

    public RemoteObject getSelectedPortalStub(int selectedRow) {
        int stubCol = this.getColumnIndex(SrISCSIRemoteTargetPortalsTableHeader.PORTAL_STUB.getColumnName());
        RemoteObject selectedPortalStub = (RemoteObject)this.getValueAt(selectedRow, stubCol);
        return selectedPortalStub;
    }

    public SrISCSIRemoteTargetPortalNode getSelectedPortalNode(int selectedRow) {
        RemoteObject portalStub = this.getSelectedPortalStub(selectedRow);
        SrISCSIRemoteTargetPortalNode selectedPortalNode = (SrISCSIRemoteTargetPortalNode)SystemRootNode.getInstance().getRefByStub(portalStub);
        return selectedPortalNode;
    }

    @Override
    public void removeListeners() {
    }

    @Override
    public void addListeners() {
    }
}

