/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalsManager;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalsTableModel;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetPortalEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetPortalsListener;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetsListener;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetPortalsTableHeader;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteTargetsTablePanel;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.swing.SrDefaultTableColumns;
import java.util.HashMap;
import java.util.Vector;

public class SrISCSIRemoteTargetPortalsModelsManager
implements SrISCSIRemoteTargetsListener,
SrISCSIRemoteTargetPortalsListener {
    private HashMap m_allPortalsModels = new HashMap();
    private int m_dialogView;
    private SrTreeNode m_treeNode;
    private SrISCSIRemoteTargetsTablePanel m_remoteTargetsTablePanel;
    private SrISCSIRemoteTargetNode m_currRemoteTargetDisplayed;

    public SrISCSIRemoteTargetPortalsModelsManager(int dialogView, SrTreeNode treeNode, SrISCSIRemoteTargetsTablePanel remoteTargetsTablePanel) {
        this.m_dialogView = dialogView;
        this.m_treeNode = treeNode;
        this.m_remoteTargetsTablePanel = remoteTargetsTablePanel;
    }

    public void selectFirstRowInTable() {
        if (this.m_remoteTargetsTablePanel.getRowCount() > 0) {
            this.m_remoteTargetsTablePanel.getTable().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void addListeners() {
        SrISCSIRemoteTargetsManager.getInstance().addISCSIRemoteTargetsListener(this);
        SrISCSIRemoteTargetPortalsManager.getInstance().addRemoteTargetPortalsListener(this);
    }

    public void removeListeners() {
        SrISCSIRemoteTargetsManager.getInstance().removeISCSIRemoteTargetsListener(this);
        SrISCSIRemoteTargetPortalsManager.getInstance().removeRemoteTargetPortalsListener(this);
    }

    public void createAllPortalsModels() {
        switch (this.m_dialogView) {
            case 0: {
                this.createAllPortalsModelsByCluster((ClusterNode)this.m_treeNode);
                break;
            }
            case 1: {
                this.createAllPortalsModelsByVswitch(false, (VSwitchNode)this.m_treeNode);
            }
        }
    }

    private void createAllPortalsModelsByCluster(ClusterNode clusterNode) {
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        for (int index0 = 0; index0 < clusterVswitches.size(); ++index0) {
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index0);
            this.createAllPortalsModelsByVswitch(true, vswitchNode);
        }
    }

    private void createAllPortalsModelsByVswitch(boolean isClusterView, VSwitchNode vswitchNode) {
        SrInitiatorNode[] vswitchInitiators = vswitchNode.getISCSIInitiators();
        for (int index1 = 0; index1 < vswitchInitiators.length; ++index1) {
            SrInitiatorNode initiatorNode = vswitchInitiators[index1];
            SrISCSIRemoteTargetNode[] initiatorRemoteTargets = initiatorNode.getConnectedTargets();
            for (int index2 = 0; index2 < initiatorRemoteTargets.length; ++index2) {
                SrISCSIRemoteTargetNode remoteTargetNode = initiatorRemoteTargets[index2];
                if (this.isRemoteTargetExistedInModelManager(remoteTargetNode)) continue;
                SrISCSIRemoteTargetPortalsTableModel tableModel = new SrISCSIRemoteTargetPortalsTableModel(new SrDefaultTableColumns(SrISCSIRemoteTargetPortalsTableHeader.getColumnNames()), remoteTargetNode, isClusterView ? null : vswitchNode);
                this.addRemoteTargetPortalsTableModel(remoteTargetNode, tableModel);
            }
        }
    }

    private boolean isRemoteTargetExistedInModelManager(SrISCSIRemoteTargetNode remoteTargetNode) {
        return this.m_allPortalsModels.get(remoteTargetNode.getStub()) != null;
    }

    public SrISCSIRemoteTargetPortalsTableModel getModelOfRemoteTarget(Object remoteTarget) {
        if (remoteTarget != null) {
            return (SrISCSIRemoteTargetPortalsTableModel)this.m_allPortalsModels.get(remoteTarget);
        }
        return null;
    }

    public void addRemoteTargetPortalsTableModel(SrISCSIRemoteTargetNode remoteTargetNode, SrISCSIRemoteTargetPortalsTableModel model) {
        this.m_allPortalsModels.put(remoteTargetNode.getStub(), model);
    }

    public void removeRemoteTargetPortalsTableModel(SrISCSIRemoteTargetNode remoteTargetNode) {
        this.m_allPortalsModels.remove(remoteTargetNode.getStub());
    }

    public SrISCSIRemoteTargetPortalsTableModel getSelectedRemoteTargetPortalsModel(SrISCSIRemoteTargetNode remoteTargetNode) {
        SrISCSIRemoteTargetPortalsTableModel model = (SrISCSIRemoteTargetPortalsTableModel)this.m_allPortalsModels.get(remoteTargetNode.getStub());
        return model;
    }

    @Override
    public void iscsiRemoteTargetCreated(SrISCSIRemoteTargetEvent e) {
        SrISCSIRemoteTargetNode remoteTargetNode = e.getISCSIRemoteTargetNode();
        SrISCSIRemoteTargetPortalsTableModel model = new SrISCSIRemoteTargetPortalsTableModel(new SrDefaultTableColumns(SrISCSIRemoteTargetPortalsTableHeader.getColumnNames()));
        switch (this.m_dialogView) {
            case 0: {
                model = new SrISCSIRemoteTargetPortalsTableModel(new SrDefaultTableColumns(SrISCSIRemoteTargetPortalsTableHeader.getColumnNames()), remoteTargetNode, null);
                break;
            }
            case 1: {
                model = new SrISCSIRemoteTargetPortalsTableModel(new SrDefaultTableColumns(SrISCSIRemoteTargetPortalsTableHeader.getColumnNames()), remoteTargetNode, (VSwitchNode)this.m_treeNode);
            }
        }
        this.addRemoteTargetPortalsTableModel(remoteTargetNode, model);
    }

    @Override
    public void iscsiRemoteTargetChanged(SrISCSIRemoteTargetEvent e) {
        SrISCSIRemoteTargetNode remoteTargetNode = e.getISCSIRemoteTargetNode();
        SrISCSIRemoteTargetPortalsTableModel mode = this.getSelectedRemoteTargetPortalsModel(remoteTargetNode);
        if (mode == null && this.canBeAddedToModelsManager(remoteTargetNode)) {
            this.iscsiRemoteTargetCreated(e);
        }
    }

    @Override
    public void iscsiRemoteTargetRemoved(SrISCSIRemoteTargetEvent e) {
        SrISCSIRemoteTargetNode remoteTargetNode = e.getISCSIRemoteTargetNode();
        if (this.isRemoteTargetExistedInModelManager(remoteTargetNode)) {
            this.removeRemoteTargetPortalsTableModel(remoteTargetNode);
        }
    }

    protected boolean canBeAddedToModelsManager(SrISCSIRemoteTargetNode remoteTargetNode) {
        switch (this.m_dialogView) {
            case 0: {
                this.canBeAddedToClusterModelsManager(remoteTargetNode);
                break;
            }
            case 1: {
                this.canBeAddedToVSwitchModelsManager(remoteTargetNode, (VSwitchNode)this.m_treeNode);
            }
        }
        return false;
    }

    private boolean canBeAddedToClusterModelsManager(SrISCSIRemoteTargetNode remoteTargetNode) {
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches((ClusterNode)this.m_treeNode);
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index);
            if (!this.canBeAddedToVSwitchModelsManager(remoteTargetNode, vswitchNode)) continue;
            return true;
        }
        return false;
    }

    private boolean canBeAddedToVSwitchModelsManager(SrISCSIRemoteTargetNode remoteTargetNode, VSwitchNode vswitchNode) {
        SrInitiatorNode[] vswitchInitiators = vswitchNode.getISCSIInitiators();
        for (int index1 = 0; index1 < vswitchInitiators.length; ++index1) {
            SrInitiatorNode initiatorNode = vswitchInitiators[index1];
            SrISCSIRemoteTargetNode[] initiatorRemoteTargets = initiatorNode.getConnectedTargets();
            for (int index2 = 0; index2 < initiatorRemoteTargets.length; ++index2) {
                SrISCSIRemoteTargetNode currentRemoteTargetNode = initiatorRemoteTargets[index2];
                if (!((ISCSIRemoteTarget)currentRemoteTargetNode.getStub()).equals(remoteTargetNode.getStub())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void iscsiRemoteTargetPortalCreated(SrISCSIRemoteTargetPortalEvent e) {
        SrISCSIRemoteTargetPortalNode portalNode = e.getISCSIRemoteTargetPortalNode();
        SrISCSIRemoteTargetNode remoteTargetNode = portalNode.getRemoteTarget();
        SrISCSIRemoteTargetPortalsTableModel model = this.getSelectedRemoteTargetPortalsModel(remoteTargetNode);
        if (model != null) {
            this.m_remoteTargetsTablePanel.iscsiRemoteTargetPortalCreated(remoteTargetNode);
            model.iscsiRemoteTargetPortalCreated(e);
        }
    }

    @Override
    public void iscsiRemoteTargetPortalRemoved(SrISCSIRemoteTargetPortalEvent e) {
        SrISCSIRemoteTargetPortalNode portalNode = e.getISCSIRemoteTargetPortalNode();
        SrISCSIRemoteTargetNode remoteTargetNode = portalNode.getRemoteTarget();
        SrISCSIRemoteTargetPortalsTableModel model = this.getSelectedRemoteTargetPortalsModel(remoteTargetNode);
        if (model != null) {
            this.m_remoteTargetsTablePanel.iscsiRemoteTargetPortalRemoved(remoteTargetNode);
            model.iscsiRemoteTargetPortalRemoved(e);
        }
    }

    @Override
    public void iscsiRemoteTargetPortalChanged(SrISCSIRemoteTargetPortalEvent e) {
        SrISCSIRemoteTargetPortalNode portalNode = e.getISCSIRemoteTargetPortalNode();
        SrISCSIRemoteTargetNode remoteTargetNode = portalNode.getRemoteTarget();
        SrISCSIRemoteTargetPortalsTableModel model = this.getSelectedRemoteTargetPortalsModel(remoteTargetNode);
        if (model != null) {
            model.iscsiRemoteTargetPortalChanged(e);
        }
    }

    public SrISCSIRemoteTargetPortalsTableModel getFirstModel() {
        if (this.m_currRemoteTargetDisplayed != null) {
            return this.getModelOfRemoteTarget(this.m_currRemoteTargetDisplayed.getStub());
        }
        return new SrISCSIRemoteTargetPortalsTableModel(new SrDefaultTableColumns(SrISCSIRemoteTargetPortalsTableHeader.getColumnNames()));
    }
}

