/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.Manager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetPortalEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteTargetPortalsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class SrISCSIRemoteTargetPortalsManager
extends ElementManager {
    private static SrISCSIRemoteTargetPortalsManager s_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiRemoteTargetPortalCreatedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteTargetPortalsListener, SrISCSIRemoteTargetPortalEvent>(){

        @Override
        public void inform(SrISCSIRemoteTargetPortalsListener listener, SrISCSIRemoteTargetPortalEvent event) {
            listener.iscsiRemoteTargetPortalCreated(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteTargetPortalChangedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteTargetPortalsListener, SrISCSIRemoteTargetPortalEvent>(){

        @Override
        public void inform(SrISCSIRemoteTargetPortalsListener listener, SrISCSIRemoteTargetPortalEvent event) {
            listener.iscsiRemoteTargetPortalChanged(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteTargetPortalRemovedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteTargetPortalsListener, SrISCSIRemoteTargetPortalEvent>(){

        @Override
        public void inform(SrISCSIRemoteTargetPortalsListener listener, SrISCSIRemoteTargetPortalEvent event) {
            listener.iscsiRemoteTargetPortalRemoved(event);
        }
    };

    private SrISCSIRemoteTargetPortalsManager() {
    }

    public static synchronized SrISCSIRemoteTargetPortalsManager getInstance() {
        if (s_instance == null) {
            s_instance = new SrISCSIRemoteTargetPortalsManager();
        }
        return s_instance;
    }

    public void addRemoteTargetPortalsListener(SrISCSIRemoteTargetPortalsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeRemoteTargetPortalsListener(SrISCSIRemoteTargetPortalsListener listener) {
        this.m_listeners.remove(listener);
    }

    public List<SrISCSIRemoteTargetPortalNode> readAllRemoteTargetPortals(ISCSIRemoteTarget remoteTarget) {
        ArrayList<SrISCSIRemoteTargetPortalNode> portalNodes = new ArrayList<SrISCSIRemoteTargetPortalNode>();
        try {
            ISCSIRemoteTargetPortal[] portals = remoteTarget.getISCSIPortals();
            if (portals != null && portals.length > 0) {
                for (int index = 0; index < portals.length; ++index) {
                    ISCSIRemoteTargetPortal portal = portals[index];
                    SrISCSIRemoteTargetPortalNode portalNode = this.discoverPortal(remoteTarget, portal);
                    portalNodes.add(portalNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            SrISCSIRemoteTargetPortalsManager.onConnectionError("Failed to get remote target portals table from the Server.");
        }
        return portalNodes;
    }

    protected SrISCSIRemoteTargetPortalNode discoverPortal(ISCSIRemoteTarget remoteTarget, ISCSIRemoteTargetPortal portal) {
        SrISCSIRemoteTargetPortalNode portalNode = (SrISCSIRemoteTargetPortalNode)SystemRootNode.getInstance().getRefByStub(portal);
        if (portalNode == null) {
            try {
                portalNode = new SrISCSIRemoteTargetPortalNode(portal, remoteTarget);
                portalNode.setIP(portal.getIPAddress());
                portalNode.setPort(portal.getPort());
                portalNode.setGroupTag(portal.getPortalGroupTag());
                VSwitch[] connectedVSwitchesStubs = portal.getConnectedVSwitchesList();
                portalNode.setConnectedOnVSwitches(connectedVSwitchesStubs);
                SystemRootNode.getInstance().putRefAndStub(portal, portalNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                SrISCSIRemoteTargetPortalsManager.onConnectionError("Failed to discover remote target portal.");
            }
        }
        return portalNode;
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    protected SrISCSIRemoteTargetPortalNode initializeRemoteTargetPortalNode(ISCSIRemoteTargetPortal portal, HashMap values, boolean isCreate) {
        block10: {
            try {
                String ipObj = (String)this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, isCreate);
                Object portObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, isCreate);
                Object groupTagObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, isCreate);
                Object connetcedVSwitchesObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_TARGET_PORTAL_CONNECTED_VSWITCHES, isCreate);
                ISCSIRemoteTarget parentStub = portal.getRemoteTarget();
                SrISCSIRemoteTargetPortalNode portalNode = isCreate ? new SrISCSIRemoteTargetPortalNode(portal, parentStub) : (SrISCSIRemoteTargetPortalNode)SystemRootNode.getInstance().getRefByStub(portal);
                if (portalNode == null) break block10;
                if (connetcedVSwitchesObj != null) {
                    VSwitch[] connectedVSwitchesStubs = (VSwitch[])connetcedVSwitchesObj;
                    portalNode.setConnectedOnVSwitches(connectedVSwitchesStubs);
                } else {
                    portalNode.setConnectedOnVSwitches(portal.getConnectedVSwitchesList());
                }
                try {
                    portalNode.setIP(ipObj == null ? portal.getIPAddress() : ipObj);
                }
                catch (ClassCastException e) {
                    System.err.println("IP casting: ipObj: " + ipObj);
                    System.err.println("IP casting: portal: " + portal);
                    if (ipObj == null) {
                        System.err.println("IP casting: portal.getIPAddress().getClass(): " + portal.getIPAddress().getClass());
                    } else {
                        System.err.println("IP casting: ipObj.getClass(): " + ipObj.getClass());
                    }
                    throw e;
                }
                portalNode.setPort(portObj == null ? portal.getPort() : (BigInteger)portObj);
                portalNode.setGroupTag(groupTagObj == null ? portal.getPortalGroupTag() : (Integer)groupTagObj);
                if (isCreate) {
                    SystemRootNode.getInstance().putRefAndStub(portal, portalNode);
                    SrTreeNode remoteTargetParent = SystemRootNode.getInstance().getRefByStub(parentStub);
                    if (remoteTargetParent != null) {
                        ((SrISCSIRemoteTargetNode)remoteTargetParent).addPortal(portalNode);
                    }
                }
                return portalNode;
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, "ISCSISessionsManager: failed to create an ISCSI remote target portal.");
                SrISCSIRemoteTargetPortalsManager.onConnectionError();
            }
        }
        return null;
    }

    public SrFuture<Void> createISCSIRemoteTargetPortal(String ip, Integer port, Integer groupTag, SrISCSIRemoteTargetNode remoteTargetNode) {
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteTargetPortalsManager: trying to create new Remote Target portal:  ", ip, ":", port);
        return ClientAOImpl.getInstance().createISCSIRemoteTargetPortal((CommKeyClassId)remoteTargetNode.getIdentifier(), ip, port, groupTag);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteTargetPortalsManager: remote target portal created");
        HashMap params = this.getParameterList(e);
        ISCSIRemoteTargetPortal remoteTargetPortal = (ISCSIRemoteTargetPortal)element;
        SrISCSIRemoteTargetPortalNode remoteTargetPortalNode = this.initializeRemoteTargetPortalNode(remoteTargetPortal, params, true);
        if (remoteTargetPortalNode != null) {
            this.fireRemoteTargetPortalCreated(remoteTargetPortalNode);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteTargetPortalsManager: remote target portal changed");
        HashMap params = this.getParameterList(e);
        ISCSIRemoteTargetPortal remoteTargetPortal = (ISCSIRemoteTargetPortal)element;
        SrISCSIRemoteTargetPortalNode remoteTargetPortalNode = this.initializeRemoteTargetPortalNode(remoteTargetPortal, params, false);
        if (remoteTargetPortalNode != null) {
            this.fireRemoteTargetPortalChanged(remoteTargetPortalNode, params);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        ISCSIRemoteTargetPortal remoteTargetPortal = (ISCSIRemoteTargetPortal)e.getElement();
        if (this.isClusterInDiscovery(remoteTargetPortal)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteTargetPortalsManager: remote target portal removed");
        SrISCSIRemoteTargetPortalNode remoteTargetPortalNode = (SrISCSIRemoteTargetPortalNode)SystemRootNode.getInstance().getRefByStub(remoteTargetPortal);
        if (remoteTargetPortalNode != null) {
            remoteTargetPortalNode.setConnectedOnVSwitches(null);
            this.removeFromRemoteTarget(remoteTargetPortalNode);
            this.fireRemoteTargetPortalRemoved(remoteTargetPortalNode);
            SystemRootNode.getInstance().removeRefAndIdByStub(remoteTargetPortal);
        }
    }

    private void removeFromRemoteTarget(SrISCSIRemoteTargetPortalNode remoteTargetPortalNode) {
        SrISCSIRemoteTargetNode remoteTargetNode = remoteTargetPortalNode.getRemoteTarget();
        if (remoteTargetNode != null) {
            remoteTargetNode.removePortal(remoteTargetPortalNode);
        }
    }

    protected void fireRemoteTargetPortalCreated(SrISCSIRemoteTargetPortalNode remoteTargetPortalNode) {
        SrISCSIRemoteTargetPortalEvent event = new SrISCSIRemoteTargetPortalEvent((Object)this, remoteTargetPortalNode);
        this.m_listeners.fireEvent(SrISCSIRemoteTargetPortalsListener.class, event, this.iscsiRemoteTargetPortalCreatedInformer);
    }

    protected void fireRemoteTargetPortalChanged(SrISCSIRemoteTargetPortalNode remoteTargetPortalNode, HashMap params) {
        SrISCSIRemoteTargetPortalEvent event = new SrISCSIRemoteTargetPortalEvent((Object)this, remoteTargetPortalNode, params);
        this.m_listeners.fireEvent(SrISCSIRemoteTargetPortalsListener.class, event, this.iscsiRemoteTargetPortalChangedInformer);
    }

    protected void fireRemoteTargetPortalRemoved(SrISCSIRemoteTargetPortalNode remoteTargetPortalNode) {
        SrISCSIRemoteTargetPortalEvent event = new SrISCSIRemoteTargetPortalEvent((Object)this, remoteTargetPortalNode);
        this.m_listeners.fireEvent(SrISCSIRemoteTargetPortalsListener.class, event, this.iscsiRemoteTargetPortalRemovedInformer);
    }

    public class ISCSIRemoteTargetPortalCreator
    implements Callable<Void> {
        private SrISCSIRemoteTargetNode m_remoteTargetNode;
        private String m_ip;
        private Integer m_port;
        private Integer m_groupTag;

        public ISCSIRemoteTargetPortalCreator(String ip, Integer port, Integer groupTag, SrISCSIRemoteTargetNode remoteTargetNode) {
            this.m_remoteTargetNode = remoteTargetNode;
            this.m_ip = ip;
            this.m_port = port;
            this.m_groupTag = groupTag;
        }

        @Override
        public Void call() throws Exception {
            try {
                theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteTargetPortalsManager: trying to create new Remote Target portal:  ", this.m_ip, ":", this.m_port);
                ISCSIRemoteTarget remoteTargetStub = (ISCSIRemoteTarget)this.m_remoteTargetNode.getStub();
                remoteTargetStub.createISCSIRemoteTargetPortal(this.m_ip, this.m_port, this.m_groupTag);
                return null;
            }
            catch (RemoteException re) {
                Manager.onConnectionError("Failed to create Remote Target Portal.");
                throw re;
            }
        }
    }
}

