/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.nms.client.ClientLoader;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteTargetPortalNode;
import com.sanrad.nms.client.data.scsi.SrDeviceNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.gui.ClientImageObject;
import com.sanrad.nms.client.gui.SrDataValidationResourceBundleKeys;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.RemoteTargetFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.RemoteTargetLoginStatusConstant;
import com.sanrad.util.BundleKeysInterface;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SrISCSIRemoteTargetNode
extends SrDeviceNode<ISCSIRemoteTarget, CommKeyClassId> {
    private String m_chapUserName;
    private Boolean m_isConfigured;
    private Boolean m_isDiscovered;
    private HashMap<String, RemoteTargetLoginStatusConstant> myVswitchNameToLoginStatusMap = new HashMap();
    private HashMap<String, RemoteTargetFailureTypeConstant> myVswitchNameToFailureTypeMap = new HashMap();
    private ArrayList<SrISCSIRemoteTargetPortalNode> m_portals;
    private ArrayList<SrInitiatorNode> m_connectedInitiators = new ArrayList();

    public SrISCSIRemoteTargetNode(ISCSIRemoteTarget stub, String alias) throws RemoteException {
        super(stub, stub.getCommKeyClassId(), alias, ClientImageObject.REMOTE_TARGET);
        this.m_portals = new ArrayList();
        this.m_iscsiSessions = new ArrayList();
    }

    @Override
    public String type() {
        return "Remote target " + this.getName();
    }

    @Override
    public String getToolTipText() {
        return this.getName();
    }

    public void setCHAPUserName(String chapUserName) {
        this.m_chapUserName = chapUserName;
    }

    public String getCHAPUserName() {
        return this.m_chapUserName;
    }

    public void setIsConfigured(Boolean isConfigured) {
        this.m_isConfigured = isConfigured;
    }

    public String getIsConfigured() {
        return this.m_isConfigured != false ? "Yes" : "No";
    }

    public boolean isConfigured() {
        return this.m_isConfigured;
    }

    public void setIsDiscovered(Boolean isDiscovered) {
        this.m_isDiscovered = isDiscovered;
    }

    public String getIsDiscovered() {
        return this.m_isDiscovered != false ? "Yes" : "No";
    }

    public void setLoginStatus(HashMap loginStatuses) {
        this.myVswitchNameToLoginStatusMap.clear();
        for (String vswitchName : loginStatuses.keySet()) {
            RemoteTargetLoginStatusConstant statusVal = (RemoteTargetLoginStatusConstant)loginStatuses.get(vswitchName);
            this.myVswitchNameToLoginStatusMap.put(vswitchName, statusVal);
        }
    }

    public RemoteTargetLoginStatusConstant getLoginStatus(String vswitchName) {
        if (vswitchName != null) {
            return this.myVswitchNameToLoginStatusMap.get(vswitchName);
        }
        RemoteTargetLoginStatusConstant status = RemoteTargetLoginStatusConstant.CONFIGURED;
        if (this.isConnectedToVSwitch()) {
            status = RemoteTargetLoginStatusConstant.CONNECTED;
        } else if (this.isLoggedOutFromAllVSwitches()) {
            status = RemoteTargetLoginStatusConstant.LOGOUT;
        } else if (this.isLoginFaliedAllVSwitches()) {
            status = RemoteTargetLoginStatusConstant.LOGIN_FAIL;
        }
        return status;
    }

    private boolean isConnectedToVSwitch() {
        Iterator<String> keys = this.myVswitchNameToLoginStatusMap.keySet().iterator();
        while (keys.hasNext()) {
            RemoteTargetLoginStatusConstant statusVal = this.myVswitchNameToLoginStatusMap.get(keys.next());
            if (!statusVal.equals(RemoteTargetLoginStatusConstant.CONNECTED)) continue;
            return true;
        }
        return false;
    }

    private boolean isLoggedOutFromAllVSwitches() {
        return this.isInLoginStatusInAllVSwitches(RemoteTargetLoginStatusConstant.LOGOUT);
    }

    private boolean isLoginFaliedAllVSwitches() {
        return this.isInLoginStatusInAllVSwitches(RemoteTargetLoginStatusConstant.LOGIN_FAIL);
    }

    private boolean isInLoginStatusInAllVSwitches(RemoteTargetLoginStatusConstant status) {
        int numOfConnectedInitiators = this.myVswitchNameToLoginStatusMap.size();
        int counter = 0;
        Iterator<String> keys = this.myVswitchNameToLoginStatusMap.keySet().iterator();
        while (keys.hasNext()) {
            RemoteTargetLoginStatusConstant statusVal = this.myVswitchNameToLoginStatusMap.get(keys.next());
            if (!statusVal.equals(status)) continue;
            ++counter;
        }
        return counter == numOfConnectedInitiators;
    }

    public RemoteTargetLoginStatusConstant getLoginStatus(VSwitchNode vswitchNode) {
        RemoteTargetLoginStatusConstant status = this.myVswitchNameToLoginStatusMap.get(vswitchNode.getName());
        return status;
    }

    public boolean isLoggedIn() {
        return this.isInLoginStatus(RemoteTargetLoginStatusConstant.CONNECTED);
    }

    public boolean isDisconnected() {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this);
        List<VSwitchNode> vswitches = clusterNode.getClusterVSwitches();
        boolean isConfiguredOnVSwitch1 = false;
        boolean isLogoutOnVSwitch1 = false;
        boolean isLoginFailedOnVSwitch1 = false;
        boolean isConfiguredOnVSwitch2 = false;
        boolean isLogoutOnVSwitch2 = false;
        boolean isLoginFailedOnVSwitch2 = false;
        if (vswitches.size() > 0) {
            RemoteTargetLoginStatusConstant statusByVswitch1 = this.getLoginStatus(vswitches.get(0));
            if (statusByVswitch1 != null) {
                isConfiguredOnVSwitch1 = statusByVswitch1.equals(RemoteTargetLoginStatusConstant.CONFIGURED);
                isLogoutOnVSwitch1 = statusByVswitch1.equals(RemoteTargetLoginStatusConstant.LOGOUT);
                isLoginFailedOnVSwitch1 = statusByVswitch1.equals(RemoteTargetLoginStatusConstant.LOGIN_FAIL);
            }
            if (vswitches.size() > 1) {
                RemoteTargetLoginStatusConstant statusByVswitch2 = this.getLoginStatus(vswitches.get(1));
                if (statusByVswitch2 != null) {
                    isConfiguredOnVSwitch2 = statusByVswitch2.equals(RemoteTargetLoginStatusConstant.CONFIGURED);
                    isLogoutOnVSwitch2 = statusByVswitch2.equals(RemoteTargetLoginStatusConstant.LOGOUT);
                    isLoginFailedOnVSwitch2 = statusByVswitch2.equals(RemoteTargetLoginStatusConstant.LOGIN_FAIL);
                }
                if (statusByVswitch1 != null && statusByVswitch2 != null) {
                    return isConfiguredOnVSwitch1 && isConfiguredOnVSwitch2 || isConfiguredOnVSwitch1 && isLogoutOnVSwitch2 || isConfiguredOnVSwitch1 && isLoginFailedOnVSwitch2 || isLogoutOnVSwitch1 && isConfiguredOnVSwitch2 || isLogoutOnVSwitch1 && isLogoutOnVSwitch2 || isLogoutOnVSwitch1 && isLoginFailedOnVSwitch2 || isLoginFailedOnVSwitch1 && isConfiguredOnVSwitch2 || isLoginFailedOnVSwitch1 && isLogoutOnVSwitch2 || isLoginFailedOnVSwitch1 && isLoginFailedOnVSwitch2;
                }
                if (statusByVswitch1 != null) {
                    return isConfiguredOnVSwitch1 || isLogoutOnVSwitch1 || isLoginFailedOnVSwitch1;
                }
                if (statusByVswitch2 != null) {
                    return isConfiguredOnVSwitch2 || isLogoutOnVSwitch2 || isLoginFailedOnVSwitch2;
                }
            }
        }
        return true;
    }

    private boolean isInLoginStatus(RemoteTargetLoginStatusConstant status) {
        ClusterNode clusterNode = SystemRootNode.getInstance().getClusterNodeOfSource(this);
        List<VSwitchNode> vswitches = clusterNode.getClusterVSwitches();
        for (int index = 0; index < vswitches.size(); ++index) {
            RemoteTargetLoginStatusConstant statusByVswitch = this.getLoginStatus(vswitches.get(index));
            if (statusByVswitch == null || statusByVswitch.equals(status)) continue;
            return false;
        }
        return true;
    }

    public void setFailureType(HashMap failureType) {
        this.myVswitchNameToFailureTypeMap.clear();
        for (String vswitchName : failureType.keySet()) {
            RemoteTargetFailureTypeConstant typeVal = (RemoteTargetFailureTypeConstant)failureType.get(vswitchName);
            this.myVswitchNameToFailureTypeMap.put(vswitchName, typeVal);
        }
    }

    public RemoteTargetFailureTypeConstant getFailureType(VSwitchNode vswitchNode) {
        RemoteTargetFailureTypeConstant type = this.myVswitchNameToFailureTypeMap.get(vswitchNode.getName());
        return type;
    }

    public void setNumberOfPortals(BigInteger numOfPortals) {
    }

    public BigInteger getNumberOfPortals(String vswitchName) {
        int numOfPortals = 0;
        if (vswitchName != null) {
            for (int index = 0; index < this.m_portals.size(); ++index) {
                SrISCSIRemoteTargetPortalNode portalNode = this.m_portals.get(index);
                if (!portalNode.isConnectedToVSwitch(vswitchName)) continue;
                ++numOfPortals;
            }
        } else {
            numOfPortals = this.m_portals.size();
        }
        String valInStr = String.valueOf(numOfPortals);
        return new BigInteger(valInStr, 10);
    }

    public boolean hasPortals() {
        return this.m_portals.size() > 0;
    }

    public boolean isConnectedToInitiator(String initiatorName) {
        for (int index = 0; index < this.m_connectedInitiators.size(); ++index) {
            SrInitiatorNode initiatorNode = this.m_connectedInitiators.get(index);
            if (!initiatorNode.getName().equals(initiatorName)) continue;
            return true;
        }
        return false;
    }

    public void setConnectedInititors(Object[] initiators) {
        ArrayList<ISCSIInitiator> initiatorsArr = new ArrayList<ISCSIInitiator>(initiators.length);
        for (int index = 0; index < initiators.length; ++index) {
            ISCSIInitiator initiator = (ISCSIInitiator)initiators[index];
            initiatorsArr.add(initiator);
        }
        this.setConnectedInititors(initiatorsArr);
    }

    public void setConnectedInititors(ArrayList initiators) {
        this.m_connectedInitiators.clear();
        for (int index = 0; index < initiators.size(); ++index) {
            ISCSIInitiator initiator = (ISCSIInitiator)initiators.get(index);
            SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
            if (initiatorNode == null) continue;
            this.m_connectedInitiators.add(initiatorNode);
        }
    }

    public SrInitiatorNode[] getConnectedInititors() {
        SrInitiatorNode[] array = new SrInitiatorNode[this.m_connectedInitiators.size()];
        return this.m_connectedInitiators.toArray(array);
    }

    public void addConnectedInititor(ISCSIInitiator initiator) {
        SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
        if (!this.m_connectedInitiators.contains(initiatorNode)) {
            this.m_connectedInitiators.add(initiatorNode);
        }
    }

    public void removeConnectedInititor(ISCSIInitiator initiator) {
        SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
        if (this.m_connectedInitiators.contains(initiatorNode)) {
            this.m_connectedInitiators.remove(initiatorNode);
        }
    }

    public void setPortals(List<SrISCSIRemoteTargetPortalNode> portals) {
        this.m_portals.clear();
        this.m_portals.addAll(portals);
    }

    public SrISCSIRemoteTargetPortalNode[] getPortals(String vswitchName) {
        if (vswitchName == null) {
            SrISCSIRemoteTargetPortalNode[] array = new SrISCSIRemoteTargetPortalNode[this.m_portals.size()];
            return this.m_portals.toArray(array);
        }
        ArrayList<SrISCSIRemoteTargetPortalNode> portalsConnectedToVSwitch = new ArrayList<SrISCSIRemoteTargetPortalNode>(this.m_portals.size());
        for (int index = 0; index < this.m_portals.size(); ++index) {
            SrISCSIRemoteTargetPortalNode portal = this.m_portals.get(index);
            if (!portal.isConnectedToVSwitch(vswitchName)) continue;
            portalsConnectedToVSwitch.add(portal);
        }
        SrISCSIRemoteTargetPortalNode[] array = new SrISCSIRemoteTargetPortalNode[portalsConnectedToVSwitch.size()];
        return portalsConnectedToVSwitch.toArray(array);
    }

    public void addPortal(SrISCSIRemoteTargetPortalNode portalNode) {
        if (!this.m_portals.contains(portalNode)) {
            this.m_portals.add(portalNode);
        }
    }

    public void removePortal(SrISCSIRemoteTargetPortalNode portalNode) {
        if (this.m_portals.contains(portalNode)) {
            this.m_portals.remove(portalNode);
        }
    }

    @Override
    public String getProblemOnDeletion() {
        String name = this.getName();
        if (!this.isDisconnected()) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.ISCSI_REMOTE_TARGET_POPUP_CANNOT_DELETE_TARGET_CONNECTED, name);
        }
        if (!this.isConfigured()) {
            return ClientLoader.DATA_VALIDATION_BUNDLE.getString((BundleKeysInterface)SrDataValidationResourceBundleKeys.ISCSI_REMOTE_TARGET_POPUP_CANNOT_DELETE_TARGET_NOT_CONFIGURED, name);
        }
        return super.getProblemOnDeletion();
    }
}

