/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;

public abstract class SrISCSIRemotePortalNode<T extends RemoteObject, I>
extends SrTreeNode<T, I> {
    private String m_ip;
    private Number m_port;
    private ArrayList m_connectedVSwitches = new ArrayList();

    public SrISCSIRemotePortalNode(T stub, I id) {
        super(stub, id);
    }

    public SrISCSIRemotePortalNode(T stub, I id, String ipAddress, Number port) throws RemoteException {
        this(stub, id);
        this.m_ip = ipAddress;
        this.m_port = port;
    }

    @Override
    public String getToolTipText() {
        return this.getIP() + ":" + this.getPort();
    }

    public void setConnectedOnVSwitches(VSwitch[] connectedVswitches) {
        this.m_connectedVSwitches.clear();
        if (connectedVswitches == null) {
            return;
        }
        for (int index = 0; index < connectedVswitches.length; ++index) {
            this.m_connectedVSwitches.add(connectedVswitches[index]);
        }
    }

    public boolean isConnectedToVSwitch(String vswitchName) {
        for (int index = 0; index < this.m_connectedVSwitches.size(); ++index) {
            VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub((VSwitch)this.m_connectedVSwitches.get(index));
            if (!vswitchNode.getName().equals(vswitchName)) continue;
            return true;
        }
        return false;
    }

    public void setIP(String ip) {
        this.m_ip = ip;
    }

    public String getIP() {
        return this.m_ip;
    }

    public void setPort(BigInteger port) {
        this.m_port = port;
    }

    public Number getPort() {
        return this.m_port;
    }

    @Override
    public String toString() {
        return this.type();
    }

    @Override
    public String type() {
        return null;
    }
}

