/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsListener;
import com.sanrad.nms.client.gui.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsTableHeader;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.ArrayList;
import java.util.Vector;

public class SrISCSIRemoteDiscoveryPortalsTableModel
extends SrTableModel
implements SrISCSIRemoteDiscoveryPortalsListener {
    protected ArrayList m_allISCSIRemoteDiscoveryPortalNodes = new ArrayList();

    protected SrISCSIRemoteDiscoveryPortalsTableModel(SrDefaultTableColumns columns) {
        super(columns);
    }

    @Override
    public void removeListeners() {
        SrISCSIRemoteDiscoveryPortalsManager.getInstance().removeISCSIRemoteDiscoveryPortalsListener(this);
    }

    @Override
    public void addListeners() {
        SrISCSIRemoteDiscoveryPortalsManager.getInstance().addISCSIRemoteDiscoveryPortalsListener(this);
    }

    @Override
    public void iscsiRemoteDiscoveryPortalCreated(SrISCSIRemoteDiscoveryPortalEvent e) {
        this.addRemoteDiscoveryPortalEntryToTable(e.getISCSIRemoteDiscoveryPortalNode());
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    @Override
    public void iscsiRemoteDiscoveryPortalRemoved(SrISCSIRemoteDiscoveryPortalEvent e) {
        this.removeRemoteDiscoveryPortalEntryFromTable(e.getISCSIRemoteDiscoveryPortalNode());
    }

    @Override
    public void iscsiRemoteDiscoveryPortalChanged(SrISCSIRemoteDiscoveryPortalEvent e) {
        this.updateRemoteDiscoveryPortalEntry(e.getISCSIRemoteDiscoveryPortalNode());
    }

    protected void addRemoteDiscoveryPortalEntryToTable(SrISCSIRemoteDiscoveryPortalNode portalNode) {
    }

    protected void updateRemoteDiscoveryPortalEntry(SrISCSIRemoteDiscoveryPortalNode portalNode) {
    }

    private void removeRemoteDiscoveryPortalEntryFromTable(SrISCSIRemoteDiscoveryPortalNode portalNode) {
        int rowCount = this.getRowCount();
        int remoteDiscoveryPortalStubCol = this.getColumnIndex(SrISCSIRemoteDiscoveryPortalsTableHeader.REMOTE_DISCOVERY_PORTAL_STUB.getColumnName());
        for (int i = 0; i < rowCount; ++i) {
            ISCSIRemotePortalDiscovery remoteDiscoveryPortalStub = (ISCSIRemotePortalDiscovery)this.getValueAt(i, remoteDiscoveryPortalStubCol);
            if (!((ISCSIRemotePortalDiscovery)portalNode.getStub()).equals(remoteDiscoveryPortalStub)) continue;
            this.removeRow(i);
            this.m_allISCSIRemoteDiscoveryPortalNodes.remove(portalNode);
        }
    }

    protected boolean isRemoteDiscoveryPortalExistedInModel(SrISCSIRemoteDiscoveryPortalNode portalNode) {
        int size = this.getRowCount();
        int remoteDiscoveryPortalStubCol = this.getColumnIndex(SrISCSIRemoteDiscoveryPortalsTableHeader.REMOTE_DISCOVERY_PORTAL_STUB.getColumnName());
        for (int i = 0; i < size; ++i) {
            ISCSIRemotePortalDiscovery remoteDiscoveryPortalStub = (ISCSIRemotePortalDiscovery)this.getValueAt(i, remoteDiscoveryPortalStubCol);
            if (!((ISCSIRemotePortalDiscovery)portalNode.getStub()).equals(remoteDiscoveryPortalStub)) continue;
            return true;
        }
        return false;
    }

    protected void initModel(ClusterNode clusterNode) {
        this.removeAllRows();
        Vector<VSwitchNode> clusterVswitches = VSwitchManager.getInstance().getAvailableVSwitches(clusterNode);
        for (int index = 0; index < clusterVswitches.size(); ++index) {
            VSwitchNode vswitchNode = clusterVswitches.elementAt(index);
            this.initModel(vswitchNode, false);
        }
        this.fireTableRowsInserted(0, this.getLastRowIndex());
    }

    protected void initModel(VSwitchNode vswitchNode) {
        this.initModel(vswitchNode, true);
    }

    protected void initModel(VSwitchNode vswitchNode, boolean fireRowsInserted) {
        SrInitiatorNode[] vswitchInitiators = vswitchNode.getISCSIInitiators();
        for (int index1 = 0; index1 < vswitchInitiators.length; ++index1) {
            SrInitiatorNode initiatorNode = vswitchInitiators[index1];
            SrISCSIRemoteDiscoveryPortalNode[] remoteDiscoveryPortals = initiatorNode.getRemoteDiscoveryPortals();
            for (int index2 = 0; index2 < remoteDiscoveryPortals.length; ++index2) {
                SrISCSIRemoteDiscoveryPortalNode portalNode = remoteDiscoveryPortals[index2];
                if (this.isRemoteDiscoveryPortalExistedInModel(portalNode)) continue;
                this.addRemoteDiscoveryPortalEntryToTable(portalNode);
            }
        }
        if (fireRowsInserted) {
            this.fireTableRowsInserted(0, this.getLastRowIndex());
        }
    }

    public RemoteObject getSelectedRemoteDiscoveryPortalStub(int selectedRow) {
        int stubCol = this.getColumnIndex(SrISCSIRemoteDiscoveryPortalsTableHeader.REMOTE_DISCOVERY_PORTAL_STUB.getColumnName());
        RemoteObject selectedRemoteDiscoveryPortalStub = (RemoteObject)this.getValueAt(selectedRow, stubCol);
        return selectedRemoteDiscoveryPortalStub;
    }

    public SrISCSIRemoteDiscoveryPortalNode getSelectedRemoteDiscoveryPortalNode(int selectedRow) {
        RemoteObject selectedRemoteDiscoveryPortalStub = this.getSelectedRemoteDiscoveryPortalStub(selectedRow);
        SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode = (SrISCSIRemoteDiscoveryPortalNode)SystemRootNode.getInstance().getRefByStub(selectedRemoteDiscoveryPortalStub);
        return remoteDiscoveryPortalNode;
    }

    public SrISCSIRemoteDiscoveryPortalNode[] getISCSIRemoteDiscoveryPortalsTableNodes() {
        SrISCSIRemoteDiscoveryPortalNode[] array = new SrISCSIRemoteDiscoveryPortalNode[this.m_allISCSIRemoteDiscoveryPortalNodes.size()];
        return this.m_allISCSIRemoteDiscoveryPortalNodes.toArray(array);
    }

    public void updateRemoteDiscoveryPortalNumOfPortals(SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode) {
        this.updateRemoteDiscoveryPortalEntry(remoteDiscoveryPortalNode);
    }
}

