/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.activeobject.ClientAOImpl;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.cluster.ClusterNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalNode;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalEvent;
import com.sanrad.nms.client.event.iscsi.remotetarget.SrISCSIRemoteDiscoveryPortalsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class SrISCSIRemoteDiscoveryPortalsManager
extends ElementManager {
    private static SrISCSIRemoteDiscoveryPortalsManager s_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiRemoteDiscoveryPortalCreatedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteDiscoveryPortalsListener, SrISCSIRemoteDiscoveryPortalEvent>(){

        @Override
        public void inform(SrISCSIRemoteDiscoveryPortalsListener listener, SrISCSIRemoteDiscoveryPortalEvent event) {
            listener.iscsiRemoteDiscoveryPortalCreated(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteDiscoveryPortalChangedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteDiscoveryPortalsListener, SrISCSIRemoteDiscoveryPortalEvent>(){

        @Override
        public void inform(SrISCSIRemoteDiscoveryPortalsListener listener, SrISCSIRemoteDiscoveryPortalEvent event) {
            listener.iscsiRemoteDiscoveryPortalChanged(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteDiscoveryPortalRemovedInformer = new SrEventListenerManager.Informer<SrISCSIRemoteDiscoveryPortalsListener, SrISCSIRemoteDiscoveryPortalEvent>(){

        @Override
        public void inform(SrISCSIRemoteDiscoveryPortalsListener listener, SrISCSIRemoteDiscoveryPortalEvent event) {
            listener.iscsiRemoteDiscoveryPortalRemoved(event);
        }
    };

    private SrISCSIRemoteDiscoveryPortalsManager() {
    }

    public static synchronized SrISCSIRemoteDiscoveryPortalsManager getInstance() {
        if (s_instance == null) {
            s_instance = new SrISCSIRemoteDiscoveryPortalsManager();
        }
        return s_instance;
    }

    public void addISCSIRemoteDiscoveryPortalsListener(SrISCSIRemoteDiscoveryPortalsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSIRemoteDiscoveryPortalsListener(SrISCSIRemoteDiscoveryPortalsListener listener) {
        this.m_listeners.remove(listener);
    }

    public ArrayList getRemoteDiscoveryPortalsNodes(ISCSIInitiator initiator, ISCSIRemotePortalDiscovery[] remoteDiscoveryPortals) {
        ArrayList<SrISCSIRemoteDiscoveryPortalNode> remoteDiscoveryPortalsNodes = new ArrayList<SrISCSIRemoteDiscoveryPortalNode>();
        for (int index = 0; index < remoteDiscoveryPortals.length; ++index) {
            ISCSIRemotePortalDiscovery remoteDiscoveryPortal = remoteDiscoveryPortals[index];
            SrISCSIRemoteDiscoveryPortalNode portalNode = (SrISCSIRemoteDiscoveryPortalNode)SystemRootNode.getInstance().getRefByStub(remoteDiscoveryPortal);
            if (portalNode == null) {
                portalNode = this.discoverRemoteDiscoveryPortal(initiator, remoteDiscoveryPortal);
            }
            remoteDiscoveryPortalsNodes.add(portalNode);
        }
        return remoteDiscoveryPortalsNodes;
    }

    public ArrayList readAllInitiatorRemoteDiscoveryPortals(ISCSIInitiator initiator) {
        ArrayList<SrISCSIRemoteDiscoveryPortalNode> remoteDiscoveryPortalsNodes = new ArrayList<SrISCSIRemoteDiscoveryPortalNode>();
        try {
            ISCSIRemotePortalDiscovery[] remoteDiscoveryPortals = initiator.getISCSIRemoteDiscoveryPortals();
            if (remoteDiscoveryPortals != null && remoteDiscoveryPortals.length > 0) {
                for (int index = 0; index < remoteDiscoveryPortals.length; ++index) {
                    ISCSIRemotePortalDiscovery remoteDiscoveryPortal = remoteDiscoveryPortals[index];
                    SrISCSIRemoteDiscoveryPortalNode portalNode = this.discoverRemoteDiscoveryPortal(initiator, remoteDiscoveryPortal);
                    remoteDiscoveryPortalsNodes.add(portalNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            SrISCSIRemoteDiscoveryPortalsManager.onConnectionError("Failed to get initiator remote discovery portals table from the Server.");
        }
        return remoteDiscoveryPortalsNodes;
    }

    public SrISCSIRemoteDiscoveryPortalNode discoverRemoteDiscoveryPortal(ISCSIInitiator initiator, ISCSIRemotePortalDiscovery remoteDiscoveryPortal) {
        SrISCSIRemoteDiscoveryPortalNode portalNode = (SrISCSIRemoteDiscoveryPortalNode)SystemRootNode.getInstance().getRefByStub(remoteDiscoveryPortal);
        if (portalNode == null) {
            try {
                portalNode = new SrISCSIRemoteDiscoveryPortalNode(remoteDiscoveryPortal, remoteDiscoveryPortal.getIPAddress(), remoteDiscoveryPortal.getPort(), remoteDiscoveryPortal.getPeriod());
                portalNode.setClusterState(remoteDiscoveryPortal.getClusterDisplayedState());
                portalNode.setState(remoteDiscoveryPortal.getVSwitchDisplayedState());
                portalNode.setLastFailureType(remoteDiscoveryPortal.getLastFailureType());
                portalNode.setLastSuccessfulDiscovery(remoteDiscoveryPortal.getLastSuccessfulDiscovery());
                HashMap nexts = this.convertNextsToDate(remoteDiscoveryPortal.getNextPlannedDiscovery(), remoteDiscoveryPortal, initiator.getParentVSwitch());
                portalNode.setNextPlannedDiscovery(nexts);
                if (initiator == null) {
                    Object[] connectedInitiators = remoteDiscoveryPortal.getAllConnectedInitiators();
                    portalNode.setConnectedInititors(connectedInitiators);
                }
                SystemRootNode.getInstance().putRefAndStub(remoteDiscoveryPortal, portalNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                SrISCSIRemoteDiscoveryPortalsManager.onConnectionError("Failed to discover initiator discovery portals.");
            }
        }
        if (initiator != null) {
            portalNode.addConnectedInititor(initiator);
        } else {
            this.setInitiatorsWithCreatedRemoteDiscoveryPortal(portalNode);
        }
        return portalNode;
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    protected SrISCSIRemoteDiscoveryPortalNode initializeRemoteDiscoveryPortalNode(ISCSIRemotePortalDiscovery element, HashMap values, boolean isCreate) {
        try {
            SrISCSIRemoteDiscoveryPortalNode portalNode;
            Object periodObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_PERIOD, isCreate);
            Object lastFailureTypeObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_LAST_FAILURE, isCreate);
            Object lastSuccessfulDiscoveryObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_LAST_SUCCESSFUL_DISCOVERY, isCreate);
            Object nextPlannedDiscoveryObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_NEXT_PLANNED_DISCOVERY, isCreate);
            ISCSIInitiator[] connectedInitiatorsObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_CONNECTED_INITIATORS, isCreate);
            ISCSIRemotePortalDiscovery discoveryPortal = element;
            if (connectedInitiatorsObj == null) {
                connectedInitiatorsObj = discoveryPortal.getAllConnectedInitiators();
            }
            Object[] connectedInitiators = connectedInitiatorsObj;
            if (isCreate) {
                portalNode = new SrISCSIRemoteDiscoveryPortalNode(discoveryPortal, discoveryPortal.getIPAddress(), discoveryPortal.getPort(), periodObj == null ? discoveryPortal.getPeriod() : (Integer)periodObj);
                portalNode.setConnectedInititors(connectedInitiators);
            } else {
                portalNode = (SrISCSIRemoteDiscoveryPortalNode)SystemRootNode.getInstance().getRefByStub(element);
            }
            if (isCreate) {
                SystemRootNode.getInstance().putRefAndStub(element, portalNode);
                this.setInitiatorsWithCreatedRemoteDiscoveryPortal(portalNode);
            }
            portalNode.setClusterState(discoveryPortal.getClusterDisplayedState());
            portalNode.setState(discoveryPortal.getVSwitchDisplayedState());
            portalNode.setLastFailureType(lastFailureTypeObj == null ? discoveryPortal.getLastFailureType() : (HashMap)lastFailureTypeObj);
            portalNode.setLastSuccessfulDiscovery(lastSuccessfulDiscoveryObj == null ? discoveryPortal.getLastSuccessfulDiscovery() : (HashMap)lastSuccessfulDiscoveryObj);
            HashMap nexts = this.convertNextsToDate(nextPlannedDiscoveryObj == null ? discoveryPortal.getNextPlannedDiscovery() : (HashMap)nextPlannedDiscoveryObj, discoveryPortal, null);
            portalNode.setNextPlannedDiscovery(nexts);
            return portalNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "SrISCSIRemoteDiscoveryPortalsManager: failed to create an ISCSI remote discovery portal.");
            SrISCSIRemoteDiscoveryPortalsManager.onConnectionError();
            return null;
        }
    }

    private HashMap convertNextsToDate(HashMap nexts, ISCSIRemotePortalDiscovery portal, VSwitch vswitch) throws RemoteException {
        VSwitch dateFromVswitch = vswitch;
        HashMap<String, Date> convertedNexts = new HashMap<String, Date>();
        for (String vswitchName : nexts.keySet()) {
            if (dateFromVswitch == null) {
                VSwitchNode vswitchNode = SystemRootNode.getInstance().getClusterNodeOfStub(portal).getVSwitchByName(vswitchName);
                dateFromVswitch = (VSwitch)vswitchNode.getStub();
            }
            BigInteger time = (BigInteger)nexts.get(vswitchName);
            long nextDiscoverySession = dateFromVswitch.getDateAndTime() + (long)(time.intValue() * 1000);
            convertedNexts.put(vswitchName, new Date(nextDiscoverySession));
        }
        return convertedNexts;
    }

    public SrFuture<Void> createISCSIRemoteDiscoveryPortal(String remoteDiscoveryPortalIPAddress, int remoteDiscoveryPortalPort, ClusterNode clusterNode) {
        theLogger.trace(SrLogCategories.LEGACY, "SrISCSIRemoteDiscoveryPortalsManager: trying to create new ISCSI Remote discovery portal:  ", remoteDiscoveryPortalIPAddress, ":", remoteDiscoveryPortalPort);
        return ClientAOImpl.getInstance().createRemoteDiscoveryPortal((CommKeyClassId)clusterNode.getIdentifier(), remoteDiscoveryPortalIPAddress, remoteDiscoveryPortalPort);
    }

    private void setInitiatorsWithCreatedRemoteDiscoveryPortal(SrISCSIRemoteDiscoveryPortalNode portalNode) {
        SrInitiatorNode[] connectedInititors = portalNode.getConnectedInititors();
        for (int index = 0; index < connectedInititors.length; ++index) {
            SrInitiatorNode initiatorNode = connectedInititors[index];
            initiatorNode.addRemoteDiscoveryPortal(portalNode);
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "SrISCSIRemoteDiscoveryPortalsManager: remote discovery portal created");
        HashMap params = this.getParameterList(e);
        ISCSIRemotePortalDiscovery remoteDiscoveryPortal = (ISCSIRemotePortalDiscovery)element;
        SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode = this.initializeRemoteDiscoveryPortalNode(remoteDiscoveryPortal, params, true);
        this.fireISCSIRemoteDiscoveryPortalCreated(remoteDiscoveryPortalNode);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "SrISCSIRemoteDiscoveryPortalsManager: remote discovery portal changed");
        HashMap params = this.getParameterList(e);
        ISCSIRemotePortalDiscovery remoteDiscoveryPortal = (ISCSIRemotePortalDiscovery)element;
        SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode = this.initializeRemoteDiscoveryPortalNode(remoteDiscoveryPortal, params, false);
        this.fireISCSIRemoteDiscoveryPortalChanged(remoteDiscoveryPortalNode, params);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "SrISCSIRemoteDiscoveryPortalsManager: remote discovery portal removed");
        ISCSIRemotePortalDiscovery remoteDiscoveryPortal = (ISCSIRemotePortalDiscovery)element;
        SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode = (SrISCSIRemoteDiscoveryPortalNode)SystemRootNode.getInstance().getRefByStub(remoteDiscoveryPortal);
        this.removeFromInitiators(remoteDiscoveryPortalNode);
        this.fireISCSIRemoteDiscoveryPortalRemoved(remoteDiscoveryPortalNode);
        SystemRootNode.getInstance().removeRefAndIdByStub(element);
    }

    private void removeFromInitiators(SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode) {
        SrInitiatorNode[] initiatorNodes = remoteDiscoveryPortalNode.getConnectedInititors();
        for (int index = 0; index < initiatorNodes.length; ++index) {
            SrInitiatorNode initiatorNode = initiatorNodes[index];
            if (initiatorNode == null) continue;
            initiatorNode.removeRemoteDiscoveryPortal(remoteDiscoveryPortalNode);
        }
    }

    protected void fireISCSIRemoteDiscoveryPortalCreated(SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode) {
        SrISCSIRemoteDiscoveryPortalEvent event = new SrISCSIRemoteDiscoveryPortalEvent((Object)this, remoteDiscoveryPortalNode);
        this.m_listeners.fireEvent(SrISCSIRemoteDiscoveryPortalsListener.class, event, this.iscsiRemoteDiscoveryPortalCreatedInformer);
    }

    protected void fireISCSIRemoteDiscoveryPortalChanged(SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode, HashMap params) {
        SrISCSIRemoteDiscoveryPortalEvent event = new SrISCSIRemoteDiscoveryPortalEvent((Object)this, remoteDiscoveryPortalNode, params);
        this.m_listeners.fireEvent(SrISCSIRemoteDiscoveryPortalsListener.class, event, this.iscsiRemoteDiscoveryPortalChangedInformer);
    }

    protected void fireISCSIRemoteDiscoveryPortalRemoved(SrISCSIRemoteDiscoveryPortalNode remoteDiscoveryPortalNode) {
        SrISCSIRemoteDiscoveryPortalEvent event = new SrISCSIRemoteDiscoveryPortalEvent((Object)this, remoteDiscoveryPortalNode);
        this.m_listeners.fireEvent(SrISCSIRemoteDiscoveryPortalsListener.class, event, this.iscsiRemoteDiscoveryPortalRemovedInformer);
    }

    public SrFuture<Void> discoverPortalRemoteTargets(SrISCSIRemoteDiscoveryPortalNode[] remoteDiscoveryPortalNodes) {
        theLogger.trace(SrLogCategories.LEGACY, "SrISCSIRemoteDiscoveryPortalsManager: trying to discover ISCSI Remote targets");
        CommKeyClassId[] stubs = new CommKeyClassId[remoteDiscoveryPortalNodes.length];
        for (int index = 0; index < remoteDiscoveryPortalNodes.length; ++index) {
            stubs[index] = (CommKeyClassId)remoteDiscoveryPortalNodes[index].getIdentifier();
        }
        return ClientAOImpl.getInstance().discoverRemoteTargets(SystemRootNode.getInstance().getCurrentClusterNode().getStorageID(), stubs);
    }

    public SrFuture<Void> refreshRemoteDiscoveryPortalsTable(ArrayList<VSwitchNode> vswitchesToRefresh) {
        ArrayList<CommKeyClassId> ids = new ArrayList<CommKeyClassId>(vswitchesToRefresh.size());
        for (int index = 0; index < vswitchesToRefresh.size(); ++index) {
            VSwitchNode vswitchNode = vswitchesToRefresh.get(index);
            ids.add((CommKeyClassId)vswitchNode.getIdentifier());
        }
        return ClientAOImpl.getInstance().refreshRemoteDiscoveryPortalsTable(ids);
    }
}

