/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remotetarget;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.initiator.SrInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remotetarget.SrISCSIRemotePortalNode;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.ISCSIRemotePortalDiscoveryFailureTypeConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class SrISCSIRemoteDiscoveryPortalNode
extends SrISCSIRemotePortalNode<ISCSIRemotePortalDiscovery, CommKeyClassId> {
    private ArrayList m_connectedInitiators = new ArrayList();
    private HashMap m_vswitchState = new HashMap();
    private String m_clusterState;
    private Integer m_period;
    private HashMap m_failureType = new HashMap();
    private HashMap m_lastSuccessfulDiscovery = new HashMap();
    private HashMap m_nextPlannedDiscovery = new HashMap();

    public SrISCSIRemoteDiscoveryPortalNode(ISCSIRemotePortalDiscovery remoteDiscoveryPortalStub, String ipAddress, Integer port, Integer period) throws RemoteException {
        super(remoteDiscoveryPortalStub, remoteDiscoveryPortalStub.getCommKeyClassId(), ipAddress, port);
        this.m_period = period;
    }

    @Override
    public String type() {
        return "Remote discovery portal " + this.getIP();
    }

    @Override
    public String getToolTipText() {
        return this.getIP() + ":" + this.getPort();
    }

    public void setClusterState(String state) throws RemoteException {
        this.m_clusterState = state;
    }

    public String getClusterState() {
        return this.m_clusterState;
    }

    public void setState(HashMap states) {
        this.m_vswitchState.clear();
        for (String vswitchName : states.keySet()) {
            String state = (String)states.get(vswitchName);
            this.m_vswitchState.put(vswitchName, state);
        }
    }

    public String getState(String vswitchName) {
        return (String)this.m_vswitchState.get(vswitchName);
    }

    public Integer getPeriod() {
        return this.m_period;
    }

    public void setLastFailureType(HashMap types) {
        this.m_failureType.clear();
        for (String vswitchName : types.keySet()) {
            ISCSIRemotePortalDiscoveryFailureTypeConstant type = (ISCSIRemotePortalDiscoveryFailureTypeConstant)types.get(vswitchName);
            this.m_failureType.put(vswitchName, type);
        }
    }

    public ISCSIRemotePortalDiscoveryFailureTypeConstant getLastFailureType(String vswitchName) {
        return (ISCSIRemotePortalDiscoveryFailureTypeConstant)this.m_failureType.get(vswitchName);
    }

    public void setLastSuccessfulDiscovery(HashMap times) {
        this.m_lastSuccessfulDiscovery.clear();
        for (String vswitchName : times.keySet()) {
            Long time = (Long)times.get(vswitchName);
            this.m_lastSuccessfulDiscovery.put(vswitchName, new Date(time));
        }
    }

    public String getLastSuccessfulDiscovery(String vswitchName) {
        Date time = (Date)this.m_lastSuccessfulDiscovery.get(vswitchName);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        if (hour == 0 && min == 0 && sec == 0) {
            return "N/A";
        }
        return time.toString();
    }

    public void setNextPlannedDiscovery(HashMap nexts) {
        this.m_nextPlannedDiscovery.clear();
        for (String vswitchName : nexts.keySet()) {
            Date time = (Date)nexts.get(vswitchName);
            this.m_nextPlannedDiscovery.put(vswitchName, time);
        }
    }

    public Date getNextPlannedDiscovery(String vswitchName) {
        return (Date)this.m_nextPlannedDiscovery.get(vswitchName);
    }

    public void setConnectedInititors(Object[] initiators) {
        ArrayList<ISCSIInitiator> initiatorsArr = new ArrayList<ISCSIInitiator>(initiators.length);
        for (int index = 0; index < initiators.length; ++index) {
            ISCSIInitiator initiator = (ISCSIInitiator)initiators[index];
            initiatorsArr.add(initiator);
        }
        this.setConnectedInititors(initiatorsArr);
    }

    public void setConnectedInititors(ArrayList initiators) {
        this.m_connectedInitiators.clear();
        for (int index = 0; index < initiators.size(); ++index) {
            ISCSIInitiator initiator = (ISCSIInitiator)initiators.get(index);
            SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
            if (initiatorNode == null) continue;
            this.m_connectedInitiators.add(initiatorNode);
        }
    }

    public SrInitiatorNode[] getConnectedInititors() {
        SrInitiatorNode[] array = new SrInitiatorNode[this.m_connectedInitiators.size()];
        return this.m_connectedInitiators.toArray(array);
    }

    public void addConnectedInititor(ISCSIInitiator initiator) {
        SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
        if (!this.m_connectedInitiators.contains(initiatorNode)) {
            this.m_connectedInitiators.add(initiatorNode);
        }
    }

    public void removeConnectedInititor(ISCSIInitiator initiator) {
        SrInitiatorNode initiatorNode = (SrInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
        if (this.m_connectedInitiators.contains(initiatorNode)) {
            this.m_connectedInitiators.remove(initiatorNode);
        }
    }
}

