/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics;

import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorStatisticsNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorsStatisticsManager;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorsStatisticsListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorsStatisticsTableHeader;
import com.sanrad.nms.client.gui.util.Utility;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatistics;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class SrISCSIRemoteInitiatorsStatisticsTableModel
extends SrTableModel
implements ISCSIRemoteInitiatorsStatisticsListener,
TargetListener,
VSwitchListener {
    private ArrayList m_tableNodes = new ArrayList();

    protected SrISCSIRemoteInitiatorsStatisticsTableModel() {
        super(new SrDefaultTableColumns(ISCSIRemoteInitiatorsStatisticsTableHeader.getColumnNames()));
    }

    @Override
    public void removeListeners() {
        ISCSIRemoteInitiatorsStatisticsManager.getInstance().removeISCSIRemoteInitiatorsStatisticsListener(this);
        TargetManager.getInstance().removeTargetListener(this);
    }

    @Override
    public void addListeners() {
        ISCSIRemoteInitiatorsStatisticsManager.getInstance().addISCSIRemoteInitiatorsStatisticsListener(this);
        TargetManager.getInstance().addTargetListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int initiatorNameIndex = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.INITIATOR_NAME.getColumnName());
        if (col == initiatorNameIndex) {
            return true;
        }
        return super.isCellEditable(row, col);
    }

    protected void addEntryToTable(ISCSIRemoteInitiatorStatisticsNode remoteInitiatorStatisticsNode, VSwitchNode vswitchNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(remoteInitiatorStatisticsNode.getStub());
        rowData.addElement(remoteInitiatorStatisticsNode.getTargetStub());
        rowData.addElement(remoteInitiatorStatisticsNode.getParentStub());
        rowData.addElement(remoteInitiatorStatisticsNode.getVSwitchName());
        rowData.addElement(remoteInitiatorStatisticsNode.getInitiatorAlias());
        rowData.addElement(remoteInitiatorStatisticsNode.getInitiatorName());
        rowData.addElement(remoteInitiatorStatisticsNode.getTargetAlias());
        rowData.addElement(remoteInitiatorStatisticsNode.getTargetName());
        rowData.addElement(remoteInitiatorStatisticsNode.getAttachedTimes());
        rowData.addElement(remoteInitiatorStatisticsNode.getOutCommands());
        rowData.addElement(remoteInitiatorStatisticsNode.getReadMB());
        rowData.addElement(remoteInitiatorStatisticsNode.getWrittenMB());
        this.m_tableNodes.add(remoteInitiatorStatisticsNode);
        this.addRowQuetly(rowData.toArray(), -1);
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    protected void addEntryToTable(ISCSIRemoteInitiatorStatisticsNode remoteInitiatorStatisticsNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(remoteInitiatorStatisticsNode.getStub());
        rowData.addElement(remoteInitiatorStatisticsNode.getTargetStub());
        rowData.addElement(Utility.NO_VAL);
        rowData.addElement(Utility.NO_VAL);
        rowData.addElement(remoteInitiatorStatisticsNode.getInitiatorAlias());
        rowData.addElement(remoteInitiatorStatisticsNode.getInitiatorName());
        rowData.addElement(remoteInitiatorStatisticsNode.getTargetAlias());
        rowData.addElement(remoteInitiatorStatisticsNode.getTargetName());
        rowData.addElement(remoteInitiatorStatisticsNode.getAttachedTimes());
        rowData.addElement(remoteInitiatorStatisticsNode.getOutCommands());
        rowData.addElement(remoteInitiatorStatisticsNode.getReadMB());
        rowData.addElement(remoteInitiatorStatisticsNode.getWrittenMB());
        this.m_tableNodes.add(remoteInitiatorStatisticsNode);
        this.addRowQuetly(rowData.toArray(), -1);
        this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
    }

    public ISCSIRemoteInitiatorStatisticsNode[] getRemoteInitiatorStatisticsNodes() {
        ISCSIRemoteInitiatorStatisticsNode[] array = new ISCSIRemoteInitiatorStatisticsNode[this.m_tableNodes.size()];
        return this.m_tableNodes.toArray(array);
    }

    private void removeEntriesFromTable(ISCSIRemoteInitiatorStatisticsNode initiatorNode) {
        int rowCount = this.getRowCount();
        int initiatorStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.REMOTE_INITIATOR_STATISTICS_STUB.getColumnName());
        for (int i = rowCount - 1; i >= 0; --i) {
            ISCSIRemoteInitiatorStatistics initiatorStub = (ISCSIRemoteInitiatorStatistics)this.getValueAt(i, initiatorStubCol);
            if (!((ISCSIRemoteInitiatorStatistics)initiatorNode.getStub()).equals(initiatorStub)) continue;
            this.removeRow(i);
        }
    }

    @Override
    public void iscsiRemoteInitiatorStatisticsCreated(StatisticsEvent e) {
        ISCSIRemoteInitiatorStatisticsNode statisticsNode = (ISCSIRemoteInitiatorStatisticsNode)e.getStatisticsNode();
        VSwitch vswitch = statisticsNode.getParentStub();
        VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitch);
        this.addEntryToTable(statisticsNode, vswitchNode);
    }

    @Override
    public void iscsiRemoteInitiatorStatisticsRemoved(StatisticsEvent e) {
        ISCSIRemoteInitiatorStatisticsNode statisticsNode = (ISCSIRemoteInitiatorStatisticsNode)e.getStatisticsNode();
        this.removeEntriesFromTable(statisticsNode);
    }

    @Override
    public void statisticsElementChanged(StatisticsEvent e) {
        ISCSIRemoteInitiatorStatisticsNode statisticsNode = (ISCSIRemoteInitiatorStatisticsNode)e.getStatisticsNode();
        HashMap changedValsMap = statisticsNode.getChangedValues();
        Object changedRowStub = statisticsNode.getStub();
        int rows = this.getRowCount();
        int rowStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.REMOTE_INITIATOR_STATISTICS_STUB.getColumnName());
        int targetStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.TARGET_STUB.getColumnName());
        int initiatorAliasCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.INITIATOR_ALIAS.getColumnName());
        int initiatorNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.INITIATOR_NAME.getColumnName());
        int targetAliasCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.TARGET_ALIAS.getColumnName());
        int targetNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.TARGET_NAME.getColumnName());
        int vswitchCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.VSWITCH_STUB.getColumnName());
        int vswitchNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.VSWITCH.getColumnName());
        int attachedTimesCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.ATTACHED_TIMES.getColumnName());
        int outCmdsCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.OUT_COMMANDS.getColumnName());
        int readMbCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.READ_MB.getColumnName());
        int writtenMbCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.WRITTEN_MB.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object tableRowStub = this.getValueAt(i, rowStubCol);
            if (!changedRowStub.equals(tableRowStub)) continue;
            this.setValueAt(statisticsNode.getTargetStub(), i, targetStubCol);
            this.setValueAt(statisticsNode.getInitiatorAlias(), i, initiatorAliasCol);
            this.setValueAt(statisticsNode.getInitiatorName(), i, initiatorNameCol);
            this.setValueAt(statisticsNode.getTargetAlias(), i, targetAliasCol);
            this.setValueAt(statisticsNode.getTargetName(), i, targetNameCol);
            this.setValueAt(statisticsNode.getParentStub(), i, vswitchCol);
            this.setValueAt(statisticsNode.getVSwitchName(), i, vswitchNameCol);
            BigInteger attachedTimesVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES);
            BigInteger outCommandsVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_REMOTE_INITIATOR_OUT_COMMANDS);
            BigInteger readMBVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_REMOTE_INITIATOR_READ_MB);
            BigInteger writtenMBVal = (BigInteger)changedValsMap.get(ClientParameterCode.ISCSI_REMOTE_INITIATOR_WRITTEN_MB);
            if (attachedTimesVal != null) {
                this.setValueAt(attachedTimesVal, i, attachedTimesCol);
            }
            if (outCommandsVal != null) {
                this.setValueAt(outCommandsVal, i, outCmdsCol);
            }
            if (readMBVal != null) {
                this.setValueAt(readMBVal, i, readMbCol);
            }
            if (writtenMBVal == null) continue;
            this.setValueAt(writtenMBVal, i, writtenMbCol);
        }
    }

    @Override
    public void newTargetCreate(TargetEvent e) {
    }

    @Override
    public void targetRemove(TargetEvent e) {
    }

    @Override
    public void targetAliasChanged(TargetEvent e) {
        int rows = this.getRowCount();
        int targetRowCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.TARGET_STUB.getColumnName());
        int targetAliasCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.TARGET_ALIAS.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object targetRowStub = this.getValueAt(i, targetRowCol);
            if (!targetRowStub.equals(e.getStub())) continue;
            this.setValueAt(e.getAlias(), i, targetAliasCol);
        }
    }

    @Override
    public void targetNameChanged(TargetEvent e) {
    }

    @Override
    public void targetVSwitchNameChanged(TargetEvent e) {
    }

    @Override
    public void targetStatusCanged(TargetEvent e) {
    }

    @Override
    public void targetUserNameChanged(TargetEvent e) {
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        int rows = this.getRowCount();
        int vswitchCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.VSWITCH_STUB.getColumnName());
        int vswitchNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsStatisticsTableHeader.VSWITCH.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object vswitchRowStub = this.getValueAt(i, vswitchCol);
            String vswitchName = (String)this.getValueAt(i, vswitchNameCol);
            if (!vswitchRowStub.equals(e.getStub())) continue;
            String name = e.getName();
            if (name == null || name.equalsIgnoreCase(vswitchName)) break;
            this.setValueAt(name, i, vswitchNameCol);
            break;
        }
    }
}

