/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.ISCSIRemoteInitiatorStatisticsNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics.RemoteInitiatorsGroupStatisticsNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorsStatisticsListener;
import com.sanrad.nms.client.event.statistics.StatisticsEvent;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatistics;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorsGroupStatistics;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ISCSIRemoteInitiatorsStatisticsManager
extends ElementManager {
    private static ISCSIRemoteInitiatorsStatisticsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiRemoteInitiatorStatisticsCreatedInformer = new SrEventListenerManager.Informer<ISCSIRemoteInitiatorsStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(ISCSIRemoteInitiatorsStatisticsListener listener, StatisticsEvent event) {
            listener.iscsiRemoteInitiatorStatisticsCreated(event);
        }
    };
    SrEventListenerManager.Informer statisticsElementChangedInformer = new SrEventListenerManager.Informer<ISCSIRemoteInitiatorsStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(ISCSIRemoteInitiatorsStatisticsListener listener, StatisticsEvent event) {
            listener.statisticsElementChanged(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteInitiatorStatisticsRemovedInformer = new SrEventListenerManager.Informer<ISCSIRemoteInitiatorsStatisticsListener, StatisticsEvent>(){

        @Override
        public void inform(ISCSIRemoteInitiatorsStatisticsListener listener, StatisticsEvent event) {
            listener.iscsiRemoteInitiatorStatisticsRemoved(event);
        }
    };

    private ISCSIRemoteInitiatorsStatisticsManager() {
        ISCSISessionsManager.getInstance();
    }

    public static synchronized ISCSIRemoteInitiatorsStatisticsManager getInstance() {
        if (m_instance == null) {
            m_instance = new ISCSIRemoteInitiatorsStatisticsManager();
        }
        return m_instance;
    }

    public void addISCSIRemoteInitiatorsStatisticsListener(ISCSIRemoteInitiatorsStatisticsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSIRemoteInitiatorsStatisticsListener(ISCSIRemoteInitiatorsStatisticsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public RemoteInitiatorsGroupStatisticsNode readISCSIRemoteInitiatorsGroupStatistics(VSwitchNode aVSwitchNode) {
        try {
            ISCSIRemoteInitiatorsGroupStatistics remoteInitiatorsGroupStatistics = ((VSwitch)aVSwitchNode.getStub()).getISCSIRemoteInitiatorsGroupStatistics();
            RemoteInitiatorsGroupStatisticsNode remoteInitiatorsGroupStatisticsNode = new RemoteInitiatorsGroupStatisticsNode(remoteInitiatorsGroupStatistics, aVSwitchNode);
            SystemRootNode.getInstance().putRefAndStub(remoteInitiatorsGroupStatistics, remoteInitiatorsGroupStatisticsNode);
            return remoteInitiatorsGroupStatisticsNode;
        }
        catch (RemoteException re) {
            theLogger.trace(SrLogCategories.LEGACY, "Failed to create ISCSIRemoteInitiators Statistics Group.");
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSIRemoteInitiatorsStatisticsManager.onConnectionError("Failed to create ISCSIRemoteInitiators Statistics Group.");
            return null;
        }
    }

    public Vector readAllISCSIRemoteInitiatorsStatistics(VSwitch vSwitch) {
        Vector<ISCSIRemoteInitiatorStatisticsNode> iscsiRemoteInitiatorStatisticsNodes = new Vector<ISCSIRemoteInitiatorStatisticsNode>();
        try {
            Vector<? extends ISCSIRemoteInitiatorStatistics> iscsiRemoteInitiatorsStatisticsTable = vSwitch.getISCSIRemoteInitiatorsStatisticsTable();
            if (iscsiRemoteInitiatorsStatisticsTable != null && !iscsiRemoteInitiatorsStatisticsTable.isEmpty()) {
                for (int index = 0; index < iscsiRemoteInitiatorsStatisticsTable.size(); ++index) {
                    ISCSIRemoteInitiatorStatistics initiator = iscsiRemoteInitiatorsStatisticsTable.get(index);
                    ISCSIRemoteInitiatorStatisticsNode remoteInitiatorStatisticsNode = this.discoverRemoteInitiatorStatistics(initiator);
                    iscsiRemoteInitiatorStatisticsNodes.addElement(remoteInitiatorStatisticsNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSIRemoteInitiatorsStatisticsManager.onConnectionError("Failed to get ISCSI RemoteInitiator Statistics Table from the Server.");
        }
        return iscsiRemoteInitiatorStatisticsNodes;
    }

    protected ISCSIRemoteInitiatorStatisticsNode discoverRemoteInitiatorStatistics(ISCSIRemoteInitiatorStatistics initiatorStatistics) {
        ISCSIRemoteInitiatorStatisticsNode remoteInitiatorStatisticsNode = (ISCSIRemoteInitiatorStatisticsNode)SystemRootNode.getInstance().getRefByStub(initiatorStatistics);
        if (remoteInitiatorStatisticsNode == null) {
            try {
                remoteInitiatorStatisticsNode = new ISCSIRemoteInitiatorStatisticsNode(initiatorStatistics, initiatorStatistics.getInitiatorAlias(), initiatorStatistics.getInitiatorName(), initiatorStatistics.getTarget(), initiatorStatistics.getVSwitch());
                remoteInitiatorStatisticsNode.setAttachedTimes(initiatorStatistics.getAttachedTimes());
                remoteInitiatorStatisticsNode.setOutCommands(initiatorStatistics.getOutCommands());
                remoteInitiatorStatisticsNode.setReadMB(initiatorStatistics.getReadMB());
                remoteInitiatorStatisticsNode.setWrittenMB(initiatorStatistics.getWrittenMB());
                SystemRootNode.getInstance().putRefAndStub(initiatorStatistics, remoteInitiatorStatisticsNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                ISCSIRemoteInitiatorsStatisticsManager.onConnectionError("Failed to discover Remote Initiator Statistics.");
            }
        }
        return remoteInitiatorStatisticsNode;
    }

    public ArrayList getRemoteInitiatorsStatisticsNodes(ISCSIRemoteInitiatorStatistics[] remoteInitiatorsStatistics) {
        ArrayList<ISCSIRemoteInitiatorStatisticsNode> remoteInitiatorsStatisticsNodes = new ArrayList<ISCSIRemoteInitiatorStatisticsNode>();
        for (int index = 0; index < remoteInitiatorsStatistics.length; ++index) {
            ISCSIRemoteInitiatorStatistics remoteInitiatorStatistics = remoteInitiatorsStatistics[index];
            ISCSIRemoteInitiatorStatisticsNode remoteInitiatorStatisticsNode = (ISCSIRemoteInitiatorStatisticsNode)SystemRootNode.getInstance().getRefByStub(remoteInitiatorStatistics);
            if (remoteInitiatorStatisticsNode == null) {
                remoteInitiatorStatisticsNode = this.discoverRemoteInitiatorStatistics(remoteInitiatorStatistics);
            }
            remoteInitiatorsStatisticsNodes.add(remoteInitiatorStatisticsNode);
        }
        return remoteInitiatorsStatisticsNodes;
    }

    protected ISCSIRemoteInitiatorStatisticsNode initializeRemoteInitiatorNode(RemoteObject element, HashMap values, boolean isCreate) {
        try {
            ISCSIRemoteInitiatorStatistics initiatorStatistics = (ISCSIRemoteInitiatorStatistics)element;
            ISCSIRemoteInitiatorStatisticsNode remoteInitiatorStatisticsNode = isCreate ? new ISCSIRemoteInitiatorStatisticsNode(initiatorStatistics, initiatorStatistics.getInitiatorAlias(), initiatorStatistics.getInitiatorName(), initiatorStatistics.getTarget(), initiatorStatistics.getVSwitch()) : (ISCSIRemoteInitiatorStatisticsNode)SystemRootNode.getInstance().getRefByStub(element);
            if (remoteInitiatorStatisticsNode != null) {
                remoteInitiatorStatisticsNode.setAttachedTimes(initiatorStatistics.getAttachedTimes());
                remoteInitiatorStatisticsNode.setOutCommands(initiatorStatistics.getOutCommands());
                remoteInitiatorStatisticsNode.setReadMB(initiatorStatistics.getReadMB());
                remoteInitiatorStatisticsNode.setWrittenMB(initiatorStatistics.getWrittenMB());
            }
            if (isCreate) {
                SystemRootNode.getInstance().putRefAndStub(element, remoteInitiatorStatisticsNode);
            }
            return remoteInitiatorStatisticsNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "ISCSIRemoteInitiatorsStatisticsManager: failed to create an ISCSI remote target statistics.");
            ISCSIRemoteInitiatorsStatisticsManager.onConnectionError();
            return null;
        }
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIRemoteInitiatorsStatisticsManager: remote initiator statistics created");
        HashMap params = this.getParameterList(e);
        ISCSIRemoteInitiatorStatistics remoteInitiatorStatistics = (ISCSIRemoteInitiatorStatistics)element;
        try {
            VSwitch vswitch = remoteInitiatorStatistics.getParentVSwitch();
            ISCSIRemoteInitiatorStatisticsNode remoteInitiatorStatisticsNode = this.initializeRemoteInitiatorNode(remoteInitiatorStatistics, params, true);
            VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitch);
            vswitchNode.addISCSIRemoteInitiatorStatisticsTableNode(remoteInitiatorStatisticsNode);
            this.fireISCSIRemoteInitiatorStatisticsCreatedEvent(remoteInitiatorStatisticsNode);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSIRemoteInitiatorsStatisticsManager.onConnectionError("Failed to create remote inititor Statistics.");
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        HashMap map = e.getParameterList();
        ISCSIRemoteInitiatorStatisticsNode node = this.initializeRemoteInitiatorNode(element, map, false);
        if (node != null) {
            node.setChangedValues(map);
            this.fireRemoteInitiatorStatisticsChanged(node);
        }
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        ISCSIRemoteInitiatorStatistics initiator = (ISCSIRemoteInitiatorStatistics)e.getElement();
        if (this.isClusterInDiscovery(initiator)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "RemoteInitiatorManager: initiator removed");
        ISCSIRemoteInitiatorStatisticsNode remoteInitiatorNode = (ISCSIRemoteInitiatorStatisticsNode)SystemRootNode.getInstance().getRefByStub(initiator);
        VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(remoteInitiatorNode.getParentStub());
        vswitchNode.removeISCSIRemoteInitiatorStatistics(remoteInitiatorNode);
        this.fireRemoteInitiatorStatisticsRemovedEvent(remoteInitiatorNode);
        SystemRootNode.getInstance().removeRefAndIdByStub(initiator);
    }

    private void fireISCSIRemoteInitiatorStatisticsCreatedEvent(ISCSIRemoteInitiatorStatisticsNode node) {
        StatisticsEvent event = new StatisticsEvent(this, node);
        this.m_listeners.fireEvent(ISCSIRemoteInitiatorsStatisticsListener.class, event, this.iscsiRemoteInitiatorStatisticsCreatedInformer);
    }

    private void fireRemoteInitiatorStatisticsChanged(ISCSIRemoteInitiatorStatisticsNode node) {
        StatisticsEvent event = new StatisticsEvent(this, node);
        this.m_listeners.fireEvent(ISCSIRemoteInitiatorsStatisticsListener.class, event, this.statisticsElementChangedInformer);
    }

    private void fireRemoteInitiatorStatisticsRemovedEvent(ISCSIRemoteInitiatorStatisticsNode node) {
        StatisticsEvent event = new StatisticsEvent(this, node);
        this.m_listeners.fireEvent(ISCSIRemoteInitiatorsStatisticsListener.class, event, this.iscsiRemoteInitiatorStatisticsRemovedInformer);
    }

    public void clearStatisticNodeParamsList(VSwitchNode node) {
        Vector nodes = node.getISCSIRemoteInitiatorsStatisticsTableNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                ISCSIRemoteInitiatorStatisticsNode statisticsNode = (ISCSIRemoteInitiatorStatisticsNode)nodes.get(i);
                statisticsNode.setChangedValues(null);
            }
        }
    }
}

