/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remoteinitiator.statistics;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.client.data.target.TargetManager;
import com.sanrad.nms.client.data.vswitch.TableRowNode;
import com.sanrad.nms.client.event.target.TargetEvent;
import com.sanrad.nms.client.event.target.TargetListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.util.Utility;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatistics;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;

public class ISCSIRemoteInitiatorStatisticsNode
extends TableRowNode<ISCSIRemoteInitiatorStatistics>
implements TargetListener,
VSwitchListener {
    private String m_initiatorAlias;
    private String m_initiatorName;
    private Object m_tagretStub;
    private String m_targetAlias;
    private String m_targetName;
    private BigInteger m_attachedTimes;
    private BigInteger m_outCommands;
    private BigInteger m_readMB;
    private BigInteger m_writtenMB;
    private HashMap m_values;

    public ISCSIRemoteInitiatorStatisticsNode(ISCSIRemoteInitiatorStatistics stub, String initiatorAlias, String initiatorName, Object tagretStub, VSwitch vswitchStub) throws RemoteException {
        super(stub, vswitchStub);
        TargetManager.getInstance().addTargetListener(this);
        this.m_initiatorAlias = initiatorAlias;
        this.m_initiatorName = initiatorName;
        this.m_tagretStub = tagretStub;
        try {
            if (this.m_tagretStub != null) {
                this.m_targetAlias = ((ISCSITarget)this.m_tagretStub).getAlias();
                this.m_targetName = ((ISCSITarget)this.m_tagretStub).getName();
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
        }
        if (this.m_targetAlias == null) {
            this.m_targetAlias = Utility.NO_VAL;
            this.m_targetName = Utility.NO_VAL;
        }
    }

    public void removeListeners() {
        TargetManager.getInstance().removeTargetListener(this);
    }

    @Override
    public String type() {
        return "Remote Initiator Statistics Node";
    }

    public String getInitiatorAlias() {
        return this.m_initiatorAlias;
    }

    public String getInitiatorName() {
        return this.m_initiatorName;
    }

    public void setInitiatorName(String name) {
        this.m_initiatorName = name;
    }

    public void setChangedValues(HashMap values) {
        this.m_values = values;
    }

    public HashMap getChangedValues() {
        return this.m_values;
    }

    public Object getTargetStub() {
        return this.m_tagretStub;
    }

    public String getTargetAlias() {
        return this.m_targetAlias;
    }

    public void setTargetAlias(String alias) {
        this.m_targetAlias = alias;
    }

    public String getTargetName() {
        return this.m_targetName;
    }

    public void setTargetName(String name) {
        this.m_targetName = name;
    }

    public void setAttachedTimes(BigInteger attachedTimes) {
        this.m_attachedTimes = attachedTimes;
    }

    public BigInteger getAttachedTimes() {
        return this.m_attachedTimes;
    }

    public void setOutCommands(BigInteger outCommands) {
        this.m_outCommands = outCommands;
    }

    public BigInteger getOutCommands() {
        return this.m_outCommands;
    }

    public void setReadMB(BigInteger readMB) {
        this.m_readMB = readMB;
    }

    public BigInteger getReadMB() {
        return this.m_readMB;
    }

    public void setWrittenMB(BigInteger writtenMB) {
        this.m_writtenMB = writtenMB;
    }

    public BigInteger getWrittenMB() {
        return this.m_writtenMB;
    }

    @Override
    public void newTargetCreate(TargetEvent e) {
    }

    @Override
    public void targetRemove(TargetEvent e) {
    }

    @Override
    public void targetAliasChanged(TargetEvent e) {
        if (this.m_tagretStub.equals(e.getStub())) {
            this.setTargetAlias(e.getAlias());
        }
    }

    @Override
    public void targetNameChanged(TargetEvent e) {
    }

    @Override
    public void targetVSwitchNameChanged(TargetEvent e) {
    }

    @Override
    public void targetStatusCanged(TargetEvent e) {
    }

    @Override
    public void targetUserNameChanged(TargetEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        String name;
        if (this.getParentStub().equals(e.getStub()) && (name = e.getName()) != null) {
            this.setVSwitchName(name);
        }
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }
}

