/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remoteinitiator.show;

import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorsManager;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorEvent;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorsListener;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionEvent;
import com.sanrad.nms.client.event.iscsi.session.ISCSISessionsListener;
import com.sanrad.nms.client.event.vswitch.VSwitchEvent;
import com.sanrad.nms.client.event.vswitch.VSwitchListener;
import com.sanrad.nms.client.gui.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorsTableHeader;
import com.sanrad.nms.client.gui.util.Utility;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.swing.SrDefaultTableColumns;
import com.sanrad.swing.SrTableModel;
import java.util.Vector;

public class SrISCSIRemoteInitiatorsTableModel
extends SrTableModel
implements ISCSISessionsListener,
ISCSIRemoteInitiatorsListener,
VSwitchListener {
    protected SrISCSIRemoteInitiatorsTableModel() {
        super(new SrDefaultTableColumns(ISCSIRemoteInitiatorsTableHeader.getColumnNames()));
    }

    @Override
    public void removeListeners() {
        ISCSIRemoteInitiatorsManager.getInstance().removeISCSIRemoteInitiatorsListener(this);
        ISCSISessionsManager.getInstance().removeISCSISessionsListener(this);
    }

    @Override
    public void addListeners() {
        ISCSIRemoteInitiatorsManager.getInstance().addISCSIRemoteInitiatorsListener(this);
        ISCSISessionsManager.getInstance().addISCSISessionsListener(this);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int initiatorNameIndex = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.INITIATOR_NAME.getColumnName());
        if (col == initiatorNameIndex) {
            return true;
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public void iscsiRemoteInitiatorCreated(ISCSIRemoteInitiatorEvent e) {
        Vector sessions = e.getISCSIRemoteInitiatorNode().getInitiatorSessions();
        if (sessions == null || sessions.size() == 0) {
            this.addEntryByRemoteInitiatorToTable(e.getISCSIRemoteInitiatorNode());
            this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
        }
    }

    @Override
    public void iscsiRemoteInitiatorRemoved(ISCSIRemoteInitiatorEvent e) {
        this.removeEntriesFromTable(e.getISCSIRemoteInitiatorNode());
    }

    @Override
    public void iscsiRemoteInitiatorChanged(ISCSIRemoteInitiatorEvent e) {
    }

    @Override
    public void iscsiSessionCreated(ISCSISessionEvent e) {
        ISCSISessionNode sessionNode = e.getISCSISessionNode();
        if (sessionNode.getDirection().equals(SessionDirectionConstant.IN_BOUND)) {
            this.addEntryBySessionToTable(sessionNode);
            this.fireTableRowsInserted(this.getLastRowIndex(), this.getLastRowIndex());
        }
    }

    @Override
    public void iscsiSessionRemoved(ISCSISessionEvent e) {
        ISCSISessionNode sessionNode = e.getISCSISessionNode();
        if (sessionNode.getDirection().equals(SessionDirectionConstant.IN_BOUND)) {
            this.removeEntriesFromTable(sessionNode);
        }
    }

    @Override
    public void iscsiSessionChanged(ISCSISessionEvent e) {
        ISCSISessionNode sessionNode = e.getISCSISessionNode();
        if (sessionNode.getDirection().equals(SessionDirectionConstant.IN_BOUND)) {
            this.updateEntryTableBySession(sessionNode);
        }
    }

    protected void addRemoteInitiatorSessionsNodesToTable(ISCSIRemoteInitiatorNode remoteInitiatorNode) {
        Vector initiatorSessions = remoteInitiatorNode.getInitiatorSessions();
        int lastRowIndex = this.getLastRowIndex();
        if (initiatorSessions.size() > 0) {
            for (int index = 0; index < initiatorSessions.size(); ++index) {
                ISCSISessionNode sessionNode = (ISCSISessionNode)initiatorSessions.elementAt(index);
                this.addEntryBySessionToTable(remoteInitiatorNode, sessionNode);
            }
        } else {
            this.addEntryByRemoteInitiatorToTable(remoteInitiatorNode);
        }
        this.fireTableRowsInserted(lastRowIndex == 0 ? lastRowIndex : lastRowIndex + 1, this.getLastRowIndex());
    }

    protected void addEntryBySessionToTable(ISCSIRemoteInitiatorNode remoteInitiatorNode, ISCSISessionNode sessionNode) {
        boolean sessionAdded = false;
        int rowCount = this.getRowCount();
        Object initiatorStub = remoteInitiatorNode.getStub();
        int initiatorStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.REMOTE_INITIATOR_STUB.getColumnName());
        for (int index = 0; index < rowCount; ++index) {
            ISCSIRemoteInitiator initiatorStubFromCol = (ISCSIRemoteInitiator)this.getValueAt(index, initiatorStubCol);
            if (!initiatorStubFromCol.equals(initiatorStub)) continue;
            this.setTableRow(index, sessionNode);
            sessionAdded = true;
            break;
        }
        if (!sessionAdded) {
            this.addTableRow(sessionNode);
        }
    }

    protected void addEntryBySessionToTable(ISCSISessionNode sessionNode) {
        boolean sessionAdded = false;
        int rowCount = this.getRowCount();
        LogicObject initiatorStub = sessionNode.getInitiatorStub();
        int initiatorStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.REMOTE_INITIATOR_STUB.getColumnName());
        for (int index = 0; index < rowCount; ++index) {
            ISCSIRemoteInitiator initiatorStubFromCol = (ISCSIRemoteInitiator)this.getValueAt(index, initiatorStubCol);
            if (!initiatorStubFromCol.equals(initiatorStub)) continue;
            this.setTableRow(index, sessionNode);
            sessionAdded = true;
            break;
        }
        if (!sessionAdded) {
            this.addTableRow(sessionNode);
        }
    }

    private void addTableRow(ISCSISessionNode sessionNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(sessionNode.getInitiatorStub());
        rowData.addElement(sessionNode.getStub());
        rowData.addElement(sessionNode.getParentStub());
        rowData.addElement(sessionNode.getVswitch());
        rowData.addElement(sessionNode.getInitiatorAlias());
        rowData.addElement(sessionNode.getInitiatorName());
        rowData.addElement(sessionNode.getISID());
        rowData.addElement(sessionNode.getTargetAlias());
        rowData.addElement(sessionNode.getTargetName());
        rowData.addElement(sessionNode.getTSIH());
        this.addRowQuetly(rowData.toArray(), -1);
    }

    private void setTableRow(int rowIndex, ISCSISessionNode sessionNode) {
        int sessionStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.SESSION_STUB.getColumnName());
        int vswitchStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.VSWITCH_STUB.getColumnName());
        int vswitchNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.VSWITCH.getColumnName());
        int initiatorAliasCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.INITIATOR_ALIAS.getColumnName());
        int initiatorNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.INITIATOR_NAME.getColumnName());
        int isidCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.ISID.getColumnName());
        int targetAliasCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.TARGET_ALIAS.getColumnName());
        int targetNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.TARGET_NAME.getColumnName());
        int tsihCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.TSIH.getColumnName());
        boolean remove = sessionNode == null;
        this.setValueAt(remove ? null : (ISCSISession)sessionNode.getStub(), rowIndex, sessionStubCol);
        this.setValueAt(remove ? null : sessionNode.getParentStub(), rowIndex, vswitchStubCol);
        this.setValueAt(remove ? Utility.NO_VAL : sessionNode.getVswitch(), rowIndex, vswitchNameCol);
        this.setValueAt(remove ? Utility.NO_VAL : sessionNode.getInitiatorAlias(), rowIndex, initiatorAliasCol);
        String currentInitiatorName = (String)this.getValueAt(rowIndex, initiatorNameCol);
        this.setValueAt(remove ? currentInitiatorName : sessionNode.getInitiatorName(), rowIndex, initiatorNameCol);
        this.setValueAt(remove ? Utility.NO_VAL : sessionNode.getISID(), rowIndex, isidCol);
        this.setValueAt(remove ? Utility.NO_VAL : sessionNode.getTargetAlias(), rowIndex, targetAliasCol);
        this.setValueAt(remove ? Utility.NO_VAL : sessionNode.getTargetName(), rowIndex, targetNameCol);
        this.setValueAt(remove ? Utility.NO_VAL : sessionNode.getTSIH(), rowIndex, tsihCol);
    }

    protected void addEntryByRemoteInitiatorToTable(ISCSIRemoteInitiatorNode initiatorNode) {
        Vector<Object> rowData = new Vector<Object>();
        rowData.addElement(initiatorNode.getStub());
        rowData.addElement(null);
        rowData.addElement(null);
        rowData.addElement(Utility.NO_VAL);
        rowData.addElement(Utility.NO_VAL);
        rowData.addElement(initiatorNode.getInitiatorName());
        rowData.addElement(Utility.NO_VAL);
        rowData.addElement(Utility.NO_VAL);
        rowData.addElement(Utility.NO_VAL);
        rowData.addElement(Utility.NO_VAL);
        this.addRowQuetly(rowData.toArray(), -1);
    }

    private void removeSessionFromTable(ISCSISessionNode sessionNode) {
        int rowCount = this.getRowCount();
        int sessionStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.SESSION_STUB.getColumnName());
        for (int i = rowCount - 1; i >= 0; --i) {
            Object sessionStub = this.getValueAt(i, sessionStubCol);
            if (sessionStub == null || !((ISCSISession)sessionNode.getStub()).equals(sessionStub)) continue;
            this.setTableRow(i, null);
        }
    }

    private void removeEntriesFromTable(ISCSIRemoteInitiatorNode initiatorNode) {
        int rowCount = this.getRowCount();
        int initiatorStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.REMOTE_INITIATOR_STUB.getColumnName());
        for (int i = rowCount - 1; i >= 0; --i) {
            ISCSIRemoteInitiator initiatorStub = (ISCSIRemoteInitiator)this.getValueAt(i, initiatorStubCol);
            if (!((ISCSIRemoteInitiator)initiatorNode.getStub()).equals(initiatorStub)) continue;
            this.removeRow(i);
        }
    }

    private void removeEntriesFromTable(ISCSISessionNode sessionNode) {
        int rowCount = this.getRowCount();
        int sessionStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.SESSION_STUB.getColumnName());
        for (int i = rowCount - 1; i >= 0; --i) {
            ISCSISession sessionStub = (ISCSISession)this.getValueAt(i, sessionStubCol);
            if (sessionStub == null || !((ISCSISession)sessionNode.getStub()).equals(sessionStub)) continue;
            this.setTableRow(i, null);
        }
    }

    private void updateEntryTableBySession(ISCSISessionNode sessionNode) {
        int rowCount = this.getRowCount();
        int initiatorAliasCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.INITIATOR_ALIAS.getColumnName());
        int targetAliasCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.TARGET_ALIAS.getColumnName());
        int vswitchNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.VSWITCH.getColumnName());
        int sessionStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.SESSION_STUB.getColumnName());
        for (int index = 0; index < rowCount; ++index) {
            ISCSISession sessionStub = (ISCSISession)this.getValueAt(index, sessionStubCol);
            if (sessionStub == null || !sessionStub.equals(sessionNode.getStub())) continue;
            this.setValueAt(sessionNode.getInitiatorAlias(), index, initiatorAliasCol);
            this.setValueAt(sessionNode.getTargetAlias(), index, targetAliasCol);
            this.setValueAt(sessionNode.getVswitch(), index, vswitchNameCol);
            break;
        }
    }

    protected boolean isRemoteInitiatorExistedInModel(ISCSIRemoteInitiatorNode initiatorNode) {
        int size = this.getRowCount();
        int initiatorStubCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.REMOTE_INITIATOR_STUB.getColumnName());
        for (int i = 0; i < size; ++i) {
            ISCSIRemoteInitiator initiatorStub = (ISCSIRemoteInitiator)this.getValueAt(i, initiatorStubCol);
            if (!((ISCSIRemoteInitiator)initiatorNode.getStub()).equals(initiatorStub)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void vSwitchCreated(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRemoved(VSwitchEvent e) {
    }

    @Override
    public void vSwitchRediscovered(VSwitchEvent e) {
    }

    @Override
    public void resetVSwitchStarted(VSwitchEvent e) {
    }

    @Override
    public void vSwitchPropertiesChanged(VSwitchEvent e) {
        int rows = this.getRowCount();
        int vswitchCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.VSWITCH_STUB.getColumnName());
        int vswitchNameCol = this.getColumnIndex(ISCSIRemoteInitiatorsTableHeader.VSWITCH.getColumnName());
        for (int i = 0; i < rows; ++i) {
            Object vswitchRowStub = this.getValueAt(i, vswitchCol);
            String vswitchName = (String)this.getValueAt(i, vswitchNameCol);
            if (!vswitchRowStub.equals(e.getStub())) continue;
            String name = e.getName();
            if (name == null || name.equalsIgnoreCase(vswitchName)) break;
            this.setValueAt(name, i, vswitchNameCol);
            break;
        }
    }
}

