/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.remoteinitiator.show;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.remoteinitiator.show.ISCSIRemoteInitiatorNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionsManager;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorEvent;
import com.sanrad.nms.client.event.iscsi.remoteinitiator.ISCSIRemoteInitiatorsListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ISCSIRemoteInitiatorsManager
extends ElementManager {
    private static ISCSIRemoteInitiatorsManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiRemoteInitiatorRemovedInformer = new SrEventListenerManager.Informer<ISCSIRemoteInitiatorsListener, ISCSIRemoteInitiatorEvent>(){

        @Override
        public void inform(ISCSIRemoteInitiatorsListener listener, ISCSIRemoteInitiatorEvent event) {
            listener.iscsiRemoteInitiatorRemoved(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteInitiatorChangedInformer = new SrEventListenerManager.Informer<ISCSIRemoteInitiatorsListener, ISCSIRemoteInitiatorEvent>(){

        @Override
        public void inform(ISCSIRemoteInitiatorsListener listener, ISCSIRemoteInitiatorEvent event) {
            listener.iscsiRemoteInitiatorChanged(event);
        }
    };
    SrEventListenerManager.Informer iscsiRemoteInitiatorCreatedInformer = new SrEventListenerManager.Informer<ISCSIRemoteInitiatorsListener, ISCSIRemoteInitiatorEvent>(){

        @Override
        public void inform(ISCSIRemoteInitiatorsListener listener, ISCSIRemoteInitiatorEvent event) {
            listener.iscsiRemoteInitiatorCreated(event);
        }
    };

    private ISCSIRemoteInitiatorsManager() {
        ISCSISessionsManager.getInstance();
    }

    public static synchronized ISCSIRemoteInitiatorsManager getInstance() {
        if (m_instance == null) {
            m_instance = new ISCSIRemoteInitiatorsManager();
        }
        return m_instance;
    }

    public void addISCSIRemoteInitiatorsListener(ISCSIRemoteInitiatorsListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSIRemoteInitiatorsListener(ISCSIRemoteInitiatorsListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public Vector readAllISCSIRemoteInitiators(VSwitch vSwitch) {
        Vector<ISCSIRemoteInitiatorNode> iscsiRemoteInitiatorNodes = new Vector<ISCSIRemoteInitiatorNode>();
        try {
            Vector<? extends ISCSIRemoteInitiator> iscsiRemoteInitiatorsTable = vSwitch.getISCSIRemoteInitiatorsTable();
            if (iscsiRemoteInitiatorsTable != null && !iscsiRemoteInitiatorsTable.isEmpty()) {
                for (int index = 0; index < iscsiRemoteInitiatorsTable.size(); ++index) {
                    ISCSIRemoteInitiator initiator = iscsiRemoteInitiatorsTable.get(index);
                    ISCSIRemoteInitiatorNode remoteInitiatorNode = this.discoverRemoteInitiator(initiator);
                    iscsiRemoteInitiatorNodes.addElement(remoteInitiatorNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSIRemoteInitiatorsManager.onConnectionError("Failed to get ISCSI RemoteInitiator Table from the Server.");
        }
        return iscsiRemoteInitiatorNodes;
    }

    public ISCSIRemoteInitiatorNode discoverRemoteInitiator(ISCSIRemoteInitiator initiator) {
        ISCSIRemoteInitiatorNode remoteInitiatorNode = (ISCSIRemoteInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
        if (remoteInitiatorNode == null) {
            try {
                remoteInitiatorNode = new ISCSIRemoteInitiatorNode(initiator, initiator.getInitiatorVswitchParent(), initiator.getInitiatorName());
                remoteInitiatorNode.setInitiatorAlias(initiator.getInitiatorAlias());
                ISCSISession[] initiatorSessions = initiator.getInitiatorSessions();
                Vector initiatorSessionsNodes = this.getInitiatorSessionsNodes(initiatorSessions);
                remoteInitiatorNode.setInitiatorSessions(initiatorSessionsNodes);
                SystemRootNode.getInstance().putRefAndStub(initiator, remoteInitiatorNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                ISCSIRemoteInitiatorsManager.onConnectionError("Failed to discover Remote Initiator.");
            }
        }
        return remoteInitiatorNode;
    }

    public ArrayList getRemoteInitiatorsNodes(ISCSIRemoteInitiator[] remoteInitiators) {
        ArrayList<ISCSIRemoteInitiatorNode> remoteInitiatorsNodes = new ArrayList<ISCSIRemoteInitiatorNode>();
        for (int index = 0; index < remoteInitiators.length; ++index) {
            ISCSIRemoteInitiator remoteInitiator = remoteInitiators[index];
            ISCSIRemoteInitiatorNode remoteInitiatorNode = (ISCSIRemoteInitiatorNode)SystemRootNode.getInstance().getRefByStub(remoteInitiator);
            if (remoteInitiatorNode == null) {
                remoteInitiatorNode = this.discoverRemoteInitiator(remoteInitiator);
            }
            remoteInitiatorsNodes.add(remoteInitiatorNode);
        }
        return remoteInitiatorsNodes;
    }

    private Vector getInitiatorSessionsNodes(ISCSISession[] sessions) {
        Vector<ISCSISessionNode> sessionsNodes = new Vector<ISCSISessionNode>();
        if (sessions != null && sessions.length > 0) {
            for (int index = 0; index < sessions.length; ++index) {
                ISCSISession iscsiSession = sessions[index];
                ISCSISessionNode sessionNode = (ISCSISessionNode)SystemRootNode.getInstance().getRefByStub(iscsiSession);
                if (sessionNode == null) {
                    sessionNode = ISCSISessionsManager.getInstance().discoverSession(iscsiSession);
                    SystemRootNode.getInstance().putRefAndStub(iscsiSession, sessionNode);
                }
                sessionsNodes.addElement(sessionNode);
            }
        }
        return sessionsNodes;
    }

    protected ISCSIRemoteInitiatorNode initializeRemoteInitiatorNode(ISCSIRemoteInitiator element, HashMap values, boolean isCreate) {
        Object initiatorName = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_INITIATOR_NAME, isCreate);
        Object initiatorAlias = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_INITIATOR_ALIAS, isCreate);
        ISCSISession[] initiatorSessions = this.getObjectForParam(values, ClientParameterCode.ISCSI_REMOTE_INITIATOR_SESSIONS, isCreate);
        try {
            ISCSIRemoteInitiator remoteInitiator = element;
            if (initiatorName == null) {
                initiatorName = remoteInitiator.getInitiatorName();
            }
            if (initiatorAlias == null) {
                initiatorAlias = remoteInitiator.getInitiatorAlias();
            }
            if (initiatorSessions == null) {
                initiatorSessions = remoteInitiator.getInitiatorSessions();
            }
            ISCSIRemoteInitiatorNode remoteInitiatorNode = isCreate ? new ISCSIRemoteInitiatorNode(element, remoteInitiator.getInitiatorVswitchParent(), (String)initiatorName) : (ISCSIRemoteInitiatorNode)SystemRootNode.getInstance().getRefByStub(element);
            remoteInitiatorNode.setInitiatorAlias((String)initiatorAlias);
            Vector initiatorSessionsNodes = this.getInitiatorSessionsNodes(initiatorSessions);
            remoteInitiatorNode.setInitiatorSessions(initiatorSessionsNodes);
            if (isCreate) {
                SystemRootNode.getInstance().putRefAndStub(element, remoteInitiatorNode);
            }
            return remoteInitiatorNode;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSIRemoteInitiatorsManager.onConnectionError("Failed to create the remote initiator.");
            return null;
        }
    }

    private void fireRemoteInitiatorRemovedEvent(ISCSIRemoteInitiatorNode remoteInitiatorNode) {
        ISCSIRemoteInitiatorEvent event = new ISCSIRemoteInitiatorEvent((Object)this, remoteInitiatorNode);
        this.m_listeners.fireEvent(ISCSIRemoteInitiatorsListener.class, event, this.iscsiRemoteInitiatorRemovedInformer);
    }

    private void fireRemoteInitiatorChanged(ISCSIRemoteInitiatorNode remoteInitiatorNode, HashMap values) {
        ISCSIRemoteInitiatorEvent event = new ISCSIRemoteInitiatorEvent((Object)this, remoteInitiatorNode, values);
        this.m_listeners.fireEvent(ISCSIRemoteInitiatorsListener.class, event, this.iscsiRemoteInitiatorChangedInformer);
    }

    private void fireISCSIRemoteInitiatorCreatedEvent(ISCSIRemoteInitiatorNode remoteInitiatorNode) {
        ISCSIRemoteInitiatorEvent event = new ISCSIRemoteInitiatorEvent((Object)this, remoteInitiatorNode);
        this.m_listeners.fireEvent(ISCSIRemoteInitiatorsListener.class, event, this.iscsiRemoteInitiatorCreatedInformer);
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        ISCSIRemoteInitiator initiator = (ISCSIRemoteInitiator)e.getElement();
        if (this.isClusterInDiscovery(initiator)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "RemoteInitiatorManager: initiator removed");
        ISCSIRemoteInitiatorNode remoteInitiatorNode = (ISCSIRemoteInitiatorNode)SystemRootNode.getInstance().getRefByStub(initiator);
        VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(remoteInitiatorNode.getParentStub());
        if (vswitchNode != null) {
            vswitchNode.removeISCSIRemoteInitiator(remoteInitiatorNode);
        }
        this.fireRemoteInitiatorRemovedEvent(remoteInitiatorNode);
        SystemRootNode.getInstance().removeRefAndIdByStub(initiator);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "RemoteInitiatorManager: initiator created");
        ISCSIRemoteInitiator initiator = (ISCSIRemoteInitiator)element;
        HashMap params = this.getParameterList(e);
        ISCSIRemoteInitiatorNode remoteInitiatorNode = this.initializeRemoteInitiatorNode(initiator, params, true);
        VSwitch vswitch = remoteInitiatorNode.getParentStub();
        VSwitchNode vswitchNode = (VSwitchNode)SystemRootNode.getInstance().getRefByStub(vswitch);
        vswitchNode.addISCSIRemoteInitiator(remoteInitiatorNode);
        this.fireISCSIRemoteInitiatorCreatedEvent(remoteInitiatorNode);
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "RemoteInitiatorManager: initiator changed");
        HashMap params = this.getParameterList(e);
        ISCSIRemoteInitiator initiator = (ISCSIRemoteInitiator)element;
        ISCSIRemoteInitiatorNode remoteInitiatorNode = this.initializeRemoteInitiatorNode(initiator, params, false);
        this.fireRemoteInitiatorChanged(remoteInitiatorNode, params);
    }
}

