/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.instance;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.client.comm.CommunicationEvent;
import com.sanrad.nms.client.data.ElementManager;
import com.sanrad.nms.client.data.SrTreeNode;
import com.sanrad.nms.client.data.SystemRootNode;
import com.sanrad.nms.client.data.iscsi.connection.ISCSIConnectionsManager;
import com.sanrad.nms.client.data.iscsi.instance.ISCSIInstanceInfo;
import com.sanrad.nms.client.data.vswitch.VSwitchNode;
import com.sanrad.nms.client.event.iscsi.instance.ISCSIInstanceEvent;
import com.sanrad.nms.client.event.iscsi.instance.ISCSIInstancesListener;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.iscsi.ISCSIInstance;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.SessionFailureTypeConstant;
import com.sanrad.util.SrEventListenerManager;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class ISCSIInstancesManager
extends ElementManager {
    private static ISCSIInstancesManager m_instance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    SrEventListenerManager.Informer iscsiInstanceChangedInformer = new SrEventListenerManager.Informer<ISCSIInstancesListener, ISCSIInstanceEvent>(){

        @Override
        public void inform(ISCSIInstancesListener listener, ISCSIInstanceEvent event) {
            listener.iscsiInstanceChanged(event);
        }
    };
    SrEventListenerManager.Informer iscsiInstanceCreatedInformer = new SrEventListenerManager.Informer<ISCSIInstancesListener, ISCSIInstanceEvent>(){

        @Override
        public void inform(ISCSIInstancesListener listener, ISCSIInstanceEvent event) {
            listener.iscsiInstanceCreated(event);
        }
    };

    private ISCSIInstancesManager() {
        ISCSIConnectionsManager.getInstance();
    }

    public static synchronized ISCSIInstancesManager getInstance() {
        if (m_instance == null) {
            m_instance = new ISCSIInstancesManager();
        }
        return m_instance;
    }

    public void addISCSIInstancesListener(ISCSIInstancesListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeISCSIInstancesListener(ISCSIInstancesListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    protected Object discoverElement() {
        return null;
    }

    public Vector readAllISCSIInstances(VSwitch vSwitch) {
        Vector<ISCSIInstanceInfo> iscsiInstanceInfoNodes = new Vector<ISCSIInstanceInfo>();
        try {
            Vector<? extends ISCSIInstance> iscsiInstanceInfos = vSwitch.getISCSIInstancesTable();
            if (iscsiInstanceInfos != null && !iscsiInstanceInfos.isEmpty()) {
                for (int index = 0; index < iscsiInstanceInfos.size(); ++index) {
                    ISCSIInstance instanceInfo = iscsiInstanceInfos.get(index);
                    ISCSIInstanceInfo instanceInfoNode = this.discoverInstance(instanceInfo);
                    iscsiInstanceInfoNodes.addElement(instanceInfoNode);
                }
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
            ISCSIInstancesManager.onConnectionError("Failed to get ISCSI Instances Table from the Server.");
        }
        return iscsiInstanceInfoNodes;
    }

    protected ISCSIInstanceInfo discoverInstance(ISCSIInstance instanceInfo) {
        ISCSIInstanceInfo instanceInfoNode = (ISCSIInstanceInfo)SystemRootNode.getInstance().getRefByStub(instanceInfo);
        if (instanceInfoNode == null) {
            try {
                instanceInfoNode = new ISCSIInstanceInfo(instanceInfo, instanceInfo.getParentVSwitch());
                instanceInfoNode.setMinVersionSupported(instanceInfo.getMinVersionSupported());
                instanceInfoNode.setMaxVersionSupported(instanceInfo.getMaxVersionSupported());
                instanceInfoNode.setVendorId(instanceInfo.getVendorId());
                instanceInfoNode.setVendorVersion(instanceInfo.getVendorVersion());
                instanceInfoNode.setNumOfPortals(instanceInfo.getNumOfPortals());
                instanceInfoNode.setNumOfNodes(instanceInfo.getNumOfNodes());
                instanceInfoNode.setNumOfSessions(instanceInfo.getNumOfSessions());
                instanceInfoNode.setNumOfSessionFailures(instanceInfo.getNumOfSessionFailures());
                instanceInfoNode.setLastFailureType(instanceInfo.getLastFailureType());
                instanceInfoNode.setLastRemoteNodeName(instanceInfo.getLastRemoteNodeName());
                SystemRootNode.getInstance().putRefAndStub(instanceInfo, instanceInfoNode);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, re, new Object[0]);
                ISCSIInstancesManager.onConnectionError("Failed to discover iscsi instance.");
            }
        }
        return instanceInfoNode;
    }

    protected ISCSIInstanceInfo initializeInstanceInfo(ISCSIInstance element, HashMap values, boolean isCreate) {
        VSwitch parentStub = null;
        try {
            Object minVersionSupportedObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_MIN_VERSION_SUPPORTED, isCreate);
            Object maxVersionSupportedObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_MAX_VERSION_SUPPORTED, isCreate);
            Object vendorIdObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_VENDOR_ID, isCreate);
            Object vendorVersionObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_VENDOR_VERSION, isCreate);
            Object numOfPortalsObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS, isCreate);
            Object numOfNodesObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_NUM_OF_NODES, isCreate);
            Object numOfSessionsObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS, isCreate);
            Object numOfSessionFailuresObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURES, isCreate);
            Object lastFailureTypeObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE, isCreate);
            Object lastRemoteNodeNameObj = this.getObjectForParam(values, ClientParameterCode.ISCSI_INSTANCE_LAST_REMOTE_NODE_NAME, isCreate);
            VSwitch instanceVswitchObj = (VSwitch)this.getObjectForParam(values, ClientParameterCode.VSWITCH_SWITCH_ID, isCreate);
            ISCSIInstance instance = element;
            parentStub = instance.getParentVSwitch();
            ISCSIInstanceInfo instanceInfo = isCreate ? new ISCSIInstanceInfo(element, instanceVswitchObj) : (ISCSIInstanceInfo)SystemRootNode.getInstance().getRefByStub(element);
            if (instanceInfo != null) {
                SrTreeNode instanceVswitch;
                instanceInfo.setMinVersionSupported(minVersionSupportedObj == null ? instance.getMinVersionSupported() : (Integer)minVersionSupportedObj);
                instanceInfo.setMaxVersionSupported(maxVersionSupportedObj == null ? instance.getMaxVersionSupported() : (Integer)maxVersionSupportedObj);
                instanceInfo.setVendorId(vendorIdObj == null ? instance.getVendorId() : (String)vendorIdObj);
                instanceInfo.setVendorVersion(vendorVersionObj == null ? instance.getVendorVersion() : (String)vendorVersionObj);
                instanceInfo.setNumOfPortals(numOfPortalsObj == null ? instance.getNumOfPortals() : (BigInteger)numOfPortalsObj);
                instanceInfo.setNumOfNodes(numOfNodesObj == null ? instance.getNumOfNodes() : (BigInteger)numOfNodesObj);
                instanceInfo.setNumOfSessions(numOfSessionsObj == null ? instance.getNumOfSessions() : (BigInteger)numOfSessionsObj);
                instanceInfo.setNumOfSessionFailures(numOfSessionFailuresObj == null ? instance.getNumOfSessionFailures() : (BigInteger)numOfSessionFailuresObj);
                instanceInfo.setLastFailureType(lastFailureTypeObj == null ? instance.getLastFailureType() : (SessionFailureTypeConstant)lastFailureTypeObj);
                instanceInfo.setLastRemoteNodeName(lastRemoteNodeNameObj == null ? instance.getLastRemoteNodeName() : (String)lastRemoteNodeNameObj);
                if (instanceVswitchObj == null) {
                    instanceVswitchObj = instance.getParentVSwitch();
                }
                if (isCreate) {
                    SystemRootNode.getInstance().putRefAndStub(element, instanceInfo);
                }
                if ((instanceVswitch = SystemRootNode.getInstance().getRefByStub(instanceVswitchObj)) != null) {
                    ((VSwitchNode)instanceVswitch).addISCSIInstanceInfo(instanceInfo);
                }
                return instanceInfo;
            }
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, re, "ISCSISessionsManager: failed to create an ISCSI instance info.");
            ISCSIInstancesManager.onConnectionError();
        }
        return null;
    }

    @Override
    public void elementRemove(CommunicationEvent e) {
        super.elementRemove(e);
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIInstancesManager: instance removed");
        ISCSIInstance instance = (ISCSIInstance)element;
        ISCSIInstanceInfo instanceInfo = (ISCSIInstanceInfo)SystemRootNode.getInstance().getRefByStub(instance);
        this.fireISCSIInstanceRemovedEvent(instanceInfo);
        SystemRootNode.getInstance().removeRefAndIdByStub(instance);
    }

    @Override
    public void elementCreate(CommunicationEvent e) {
        ISCSIInstance element = (ISCSIInstance)e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        if (this.alreadyExist(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIInstancesManager: instance created");
        HashMap params = this.getParameterList(e);
        ISCSIInstanceInfo instanceInfo = this.initializeInstanceInfo(element, params, true);
        if (instanceInfo != null) {
            this.fireISCSIInstanceInfoCreatedEvent(instanceInfo);
        }
    }

    @Override
    public void elementChanged(CommunicationEvent e) {
        RemoteObject element = e.getElement();
        if (this.isClusterInDiscovery(element)) {
            return;
        }
        theLogger.trace(SrLogCategories.LEGACY, "ISCSIInstancesManager: iscsi instance info changed");
        HashMap map = this.getParameterList(e);
        ISCSIInstance instance = (ISCSIInstance)element;
        ISCSIInstanceInfo instanceInfo = this.initializeInstanceInfo(instance, map, false);
        if (instanceInfo != null) {
            this.fireISCSIInstanceInfoChanged(instanceInfo, map);
        }
    }

    private void fireISCSIInstanceRemovedEvent(ISCSIInstanceInfo instanceInfo) {
        ISCSIInstanceEvent event = new ISCSIInstanceEvent((Object)this, instanceInfo);
        this.m_listeners.fireEvent(ISCSIInstancesListener.class, event, this.iscsiInstanceChangedInformer);
    }

    protected void fireISCSIInstanceInfoCreatedEvent(ISCSIInstanceInfo instanceInfo) {
        ISCSIInstanceEvent event = new ISCSIInstanceEvent((Object)this, instanceInfo);
        this.m_listeners.fireEvent(ISCSIInstancesListener.class, event, this.iscsiInstanceCreatedInformer);
    }

    protected void fireISCSIInstanceInfoChanged(ISCSIInstanceInfo instanceInfo, HashMap map) {
        ISCSIInstanceEvent event = new ISCSIInstanceEvent((Object)this, instanceInfo, map);
        this.m_listeners.fireEvent(ISCSIInstancesListener.class, event, this.iscsiInstanceChangedInformer);
    }
}

