/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.client.data.iscsi.connection;

import com.sanrad.nms.client.data.iscsi.session.show.ISCSISessionNode;
import com.sanrad.nms.client.gui.components.SrClientLabel;
import com.sanrad.nms.client.gui.iscsi.connection.ISCSIConnectionsTableHeader;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.swing.SrTableColumns;
import com.sanrad.swing.components.SrWidget;
import java.util.Vector;

public class SrSessionConnectionsTableColumns
extends SrTableColumns {
    public SrSessionConnectionsTableColumns(Vector colNames, ISCSISessionNode sessionNode) {
        Vector colDefs = sessionNode != null ? this.getColDefsBySessionDirection(colNames, sessionNode) : this.getDefaultColDefs(colNames);
        this.setColumns(colDefs);
    }

    private Vector getDefaultColDefs(Vector colNames) {
        Vector<SrWidget> colDefs = new Vector<SrWidget>(colNames.size());
        for (int i = 0; i < colNames.size(); ++i) {
            String colName = (String)colNames.get(i);
            SrWidget widget = new SrWidget(colName, new SrClientLabel());
            widget.setReadOnly(true);
            colDefs.add(widget);
        }
        return colDefs;
    }

    private Vector getColDefsBySessionDirection(Vector colNames, ISCSISessionNode sessionNode) {
        boolean isSessionInbound = sessionNode.getDirection().equals(SessionDirectionConstant.IN_BOUND);
        String initiatorAddressGroupPrefix = isSessionInbound ? ISCSIConnectionsTableHeader.REMOTE_HEADER_GROUP_TITLE : ISCSIConnectionsTableHeader.LOCAL_HEADER_GROUP_TITLE;
        String targetAddressGroupPrefix = isSessionInbound ? ISCSIConnectionsTableHeader.LOCAL_HEADER_GROUP_TITLE : ISCSIConnectionsTableHeader.REMOTE_HEADER_GROUP_TITLE;
        Vector<SrWidget> colDefs = new Vector<SrWidget>(colNames.size());
        for (int i = 0; i < colNames.size(); ++i) {
            String colName = (String)colNames.get(i);
            if (colName.equals(ISCSIConnectionsTableHeader.INITIATOR_IP.getColumnName()) || colName.equals(ISCSIConnectionsTableHeader.INITIATOR_PORT.getColumnName())) {
                colName = initiatorAddressGroupPrefix + " " + colName;
            } else if (colName.equals(ISCSIConnectionsTableHeader.TARGET_IP.getColumnName()) || colName.equals(ISCSIConnectionsTableHeader.TARGET_PORT.getColumnName())) {
                colName = targetAddressGroupPrefix + " " + colName;
            }
            SrWidget widget = new SrWidget(colName, new SrClientLabel());
            widget.setReadOnly(true);
            colDefs.add(widget);
        }
        return colDefs;
    }
}

